/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.RenderSelfItem;
import io.sedu.mc.parties.client.overlay.effects.ClientEffect;
import io.sedu.mc.parties.client.overlay.effects.EffectHolder;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import org.joml.Matrix4f;

public abstract class PEffects
extends RenderSelfItem {
    protected int maxSize;
    protected int maxPerRow;
    int borderSize = 1;
    static int beneColor = 11134463;
    static int badColor = 0xFFA9A9;
    static int flashColor = 0xFFFFFF;
    private int xOff;
    private int yOff;
    private int eleWidth;
    private int eleHeight;
    private static final List<PEffects> effectItems = new ArrayList<PEffects>();
    private final MutableComponent instantText = Component.m_237115_((String)"ui.sedparties.tooltip.effectinstant");
    private static Desc desc = new Desc(){};

    @Override
    public RenderItem.SmallBound changeVisibility(boolean data) {
        int index = effectItems.indexOf(this);
        if (data) {
            if (index == -1) {
                effectItems.add(this);
            }
        } else {
            if (index == -1) {
                return null;
            }
            effectItems.remove(index);
        }
        return super.changeVisibility(data);
    }

    public PEffects(String name) {
        super(name);
    }

    public static void checkEffectTooltip(int posX, int posY, BiConsumer<PEffects, Integer> action) {
        effectItems.forEach(item -> {
            int newX;
            if (posX > item.xPos && (newX = (posX - item.xPos) / (item.width / 2)) < item.maxPerRow) {
                int eleIndex = posY - item.yPos;
                if (eleIndex < 0) {
                    return;
                }
                if ((eleIndex = eleIndex / (item.height / 2) * item.maxPerRow + newX) < item.maxSize && eleIndex > -1) {
                    action.accept((PEffects)item, eleIndex);
                }
            }
        });
    }

    @Override
    int getColor() {
        return beneColor;
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isOnline) {
            this.renderEffect(x, y, id, g, partialTicks);
        }
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        this.renderEffect(x, y, id, g, partialTicks);
    }

    void renderOverflow(GuiGraphics g, int x, int y, int iX, int iY, float partialTicks) {
        this.drawOverflowText(g, (int)(this.rX(x, iX) / this.scale) + 3, (int)(this.rY(y, iY) / this.scale) + 3, (int)Mth.m_14036_((float)(255.0f * (float)(0.5 + Math.sin(((float)PEffects.guiTicks() + partialTicks) / 4.0f) / 2.0)), (float)10.0f, (float)245.0f));
    }

    void drawOverflowText(GuiGraphics g, int x, int y, int alpha) {
        this.text(x, y - 1, g, "\u25aa\u25aa\u25aa", beneColor);
        this.text(x, y, g, "\u25ab\u25ab\u25ab", badColor | alpha << 24);
    }

    boolean checkRow(int x) {
        return x + 1 > this.maxPerRow;
    }

    void renderEffect(ClientEffect effect, GuiGraphics g, int x, int y, int iX, int iY, float partialTicks) {
        int tY;
        int tX;
        if (effect.isInstant() && (PEffects.guiTicks() >> 3 & 1) == 0) {
            this.rectInscribedFlash(g.m_280168_().m_85850_().m_252922_(), this.borderSize, this.sX(x, iX), this.sY(y, iY), 26, 26, 0xFFFFFF, effect.getEffect().m_19484_());
        } else {
            this.rectInscribed(g.m_280168_().m_85850_().m_252922_(), this.borderSize, this.sX(x, iX), this.sY(y, iY), 26, 26, effect.getEffect().m_19484_(), effect.bene());
        }
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91306_().m_118732_(effect.getEffect());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
        RenderSystem.enableBlend();
        if (effect.isDying()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(0.75 + Math.sin(((float)PEffects.guiTicks() + partialTicks) / 2.0f) / 4.0)));
        } else {
            PEffects.resetColor();
        }
        g.m_280159_(this.sX(x, iX) + 4, this.sY(y, iY) + 4, 0, 18, 18, sprite);
        if (!effect.getRomanTrimmed().isEmpty()) {
            tX = this.sX(x, iX) + 24 - PEffects.getFont().m_92895_(effect.getRomanTrimmed());
            tY = this.sY(y, iY) + 16;
            this.text(tX, tY, g, effect.getRomanTrimmed(), 16766720, true);
        }
        if (this.textEnabled && !effect.isInstant() && !effect.isInfinite()) {
            tX = this.sX(x, iX) + effect.getOffset() + 7;
            tY = this.sY(y, iY) + 29;
            this.text(tX, tY, g, effect.getDisplay(), 0xFFFFFF, true);
        }
    }

    public void renderTooltip(GuiGraphics g, EffectHolder effects, Integer buffIndex, int pMouseX, int pMouseY) {
        if (this.getClientEffect(effects, buffIndex, effect -> {
            Component[] list = new Component[]{Component.m_237115_((String)effect.getEffect().m_19481_()).m_130946_(" ").m_130946_(effect.getRoman()), effect.bene() ? Component.m_237115_((String)"ui.sedparties.tooltip.effectbene").m_130940_(ChatFormatting.BOLD).m_130948_(Style.f_131099_.m_178520_(beneColor)) : Component.m_237115_((String)"ui.sedparties.tooltip.effectbad").m_130940_(ChatFormatting.BOLD).m_130948_(Style.f_131099_.m_178520_(badColor)), effect.isInfinite() ? Component.m_237113_((String)"\u221e").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)ColorAPI.getRainbowColor()))) : Component.m_237113_((String)PEffects.format(effect.getDur())).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)effect.getEffect().m_19484_()))), Component.m_237113_((String)Objects.requireNonNull(BuiltInRegistries.f_256974_.m_7981_((Object)effect.getEffect())).toString()).m_130940_(ChatFormatting.GRAY)};
            desc.render(this, g, pMouseX, pMouseY, list, effect.getEffect());
        })) {
            this.renderOverflow(effects, g, pMouseX, pMouseY);
        }
    }

    public static void updateDescription() {
        desc = new Desc(){

            @Override
            public void render(PEffects p, GuiGraphics g, int mX, int mY, Component[] list, MobEffect effect) {
                ResourceLocation loc;
                List<Component> desc = Screen.m_96638_() ? ((loc = BuiltInRegistries.f_256974_.m_7981_((Object)effect)) != null ? RenderUtils.splitTooltip(I18n.m_118938_((String)("effect." + loc.m_214298_() + ".description"), (Object[])new Object[0]), 40, false, false) : RenderUtils.splitTooltip(I18n.m_118938_((String)"ui.sedparties.tooltip.effectshift", (Object[])new Object[0]), 40, false, true)) : RenderUtils.splitTooltip(I18n.m_118938_((String)"ui.sedparties.tooltip.effectshift", (Object[])new Object[0]), 40, false, true);
                int max = 0;
                for (Component c : desc) {
                    max = Math.max(max, RenderItem.getFont().m_92852_((FormattedText)c) / 2);
                }
                p.renderSingleEffectTooltipModded(g, mX, mY, list, desc, max, effect);
            }
        };
    }

    public static String format(int duration) {
        int minutes = duration / 60;
        return minutes + ":" + String.format("%02d", Math.max(0, duration - minutes * 60));
    }

    abstract void renderEffect(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);

    protected boolean getClientEffect(EffectHolder effects, Integer buffIndex, Consumer<ClientEffect> action) {
        return effects.getEffect(this.maxSize, effects.sortedEffectAll, buffIndex, action);
    }

    protected void renderOverflow(EffectHolder effects, GuiGraphics g, int mouseX, int mouseY) {
        ArrayList c = new ArrayList();
        effects.forAllRemainder(this.maxSize, effect -> c.add(Component.m_237115_((String)effect.getEffect().m_19481_()).m_130946_(" ").m_130946_(effect.getRoman()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)(effect.getEffect().m_19486_() ? beneColor : badColor))))));
        g.m_280666_(PEffects.getFont(), c, mouseX, mouseY);
    }

    void start(PoseStack poseStack, int x, int y, int size) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        RenderSystem.enableDepthTest();
    }

    void end(PoseStack poseStack) {
        PEffects.resetColor();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private void rectInscribed(Matrix4f pose, int radius, int x, int y, int width, int height, int outColor, boolean ben) {
        if (ben) {
            RenderUtils.sizeRectNoA(pose, x, y, 0, width, height, beneColor, beneColor);
        } else {
            RenderUtils.sizeRectNoA(pose, x, y, 0, width, height, badColor, badColor);
        }
        RenderUtils.sizeRectNoA(pose, x + radius, y + radius, 0, width - radius * 2, height - radius * 2, 0x212121, (outColor & 0xFEFEFE) >> 1);
    }

    private void rectInscribedFlash(Matrix4f pose, int radius, int x, int y, int width, int height, int flashColor, int outColor) {
        RenderUtils.sizeRectNoA(pose, x, y, 0, width, height, flashColor, flashColor);
        RenderUtils.sizeRectNoA(pose, x + radius, y + radius, 0, width - radius * 2, height - radius * 2, 0x212121, (outColor & 0xFEFEFE) >> 1);
    }

    private int sX(int x, int bI) {
        return (int)((float)(x << 1) / this.scale + (float)(this.width * bI)) + this.xOff / 2;
    }

    private float rX(int x, int bI) {
        return (float)x + (float)this.width / 2.0f * this.scale * (float)bI;
    }

    private int sY(int y, int bI) {
        return (int)((float)(y << 1) / this.scale + (float)(this.width * bI)) + this.xOff / 2;
    }

    private float rY(int y, int bI) {
        return (float)y + (float)this.height / 2.0f * this.scale * (float)bI;
    }

    @Override
    protected RenderItem.SmallBound setWidth(Integer d) {
        this.width = d;
        this.xOff = (this.width - 26) / 2;
        this.eleWidth = this.width * this.maxPerRow / 2;
        return new RenderItem.SmallBound(2, (int)((float)(this.width / 2 * this.maxPerRow) * this.scale));
    }

    @Override
    protected RenderItem.SmallBound setHeight(Integer d) {
        this.height = d;
        this.yOff = (this.height - 26) / 2;
        this.eleHeight = (int)((double)this.height * Math.ceil((float)this.maxSize / (float)this.maxPerRow) / 2.0);
        return new RenderItem.SmallBound(3, (int)((double)(this.height / 2) * Math.ceil(1.0f * (float)this.maxSize / (float)this.maxPerRow) * (double)this.scale));
    }

    @Override
    protected int maxX() {
        return Math.max(0, frameEleW - (int)((float)this.eleWidth * this.scale));
    }

    @Override
    protected int maxY() {
        return Math.max(0, frameEleH - (int)((float)this.eleHeight * this.scale));
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("display");
        c.addBooleanEntry("display", this.isEnabled());
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addSliderEntry("bsize", 1, () -> 4, this.borderSize);
        this.getColorEntry(c);
        c.addTitleEntry("position");
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addTitleEntry("icon");
        c.addBooleanEntry("bgdisplay", this.iconEnabled);
        c.addSliderEntry("spacex", 1, () -> 64, this.width, true);
        c.addSliderEntry("spacey", 1, () -> 64, this.height, true);
        this.getLimitEntries(c);
        return c;
    }

    protected void updateAffectedSliders(HashMap<String, ConfigOptionsList.SliderEntry> sliders) {
        sliders.computeIfPresent("totalmax", (s, sliderEntry) -> sliderEntry.forceUpdate(Math.max(this.maxPerRow, this.maxSize)));
        sliders.computeIfPresent("rowmax", (s, sliderEntry) -> sliderEntry.forceUpdate(Math.min(this.maxPerRow, this.maxSize)));
    }

    protected void getLimitEntries(ConfigOptionsList c) {
        HashMap<String, ConfigOptionsList.SliderEntry> entries = new HashMap<String, ConfigOptionsList.SliderEntry>();
        entries.put("rowmax", c.addSliderWithUpdater("rowmax", 1, () -> this.maxSize, this.maxPerRow, () -> this.updateAffectedSliders(entries), false));
        entries.put("totalmax", c.addSliderWithUpdater("totalmax", this.maxPerRow, () -> 64, this.maxSize, () -> this.updateAffectedSliders(entries), false));
    }

    protected void getColorEntry(ConfigOptionsList c) {
    }

    @Override
    public RenderItem.SmallBound setColor(int type, int data) {
        switch (type) {
            case 0: {
                beneColor = data;
                break;
            }
            case 1: {
                badColor = data;
                break;
            }
            case 2: {
                flashColor = data;
            }
        }
        return null;
    }

    @Override
    public int getColor(int type) {
        switch (type) {
            case 0: {
                return beneColor;
            }
            case 1: {
                return badColor;
            }
            case 2: {
                return flashColor;
            }
        }
        return 0;
    }

    public RenderItem.SmallBound setBorderSize(int data) {
        this.borderSize = data;
        return null;
    }

    public RenderItem.SmallBound setMaxSize(int data) {
        this.maxSize = data;
        return new RenderItem.SmallBound(2, (int)((float)(this.width / 2 * this.maxPerRow) * this.scale)){

            @Override
            public void update(BiConsumer<Integer, Integer> action) {
                action.accept(this.type, this.value);
                action.accept(3, (int)((double)(PEffects.this.height / 2) * Math.ceil(1.0f * (float)PEffects.this.maxSize / (float)PEffects.this.maxPerRow) * (double)PEffects.this.scale));
            }
        };
    }

    public RenderItem.SmallBound setMaxPerRow(int data) {
        this.maxPerRow = data;
        return new RenderItem.SmallBound(2, (int)((float)(this.width / 2 * this.maxPerRow) * this.scale)){

            @Override
            public void update(BiConsumer<Integer, Integer> action) {
                action.accept(this.type, this.value);
                action.accept(3, (int)((double)(PEffects.this.height / 2) * Math.ceil(1.0f * (float)PEffects.this.maxSize / (float)PEffects.this.maxPerRow) * (double)PEffects.this.scale));
            }
        };
    }

    @Override
    public RenderItem.ItemBound getRenderItemBound() {
        return new RenderItem.ItemBound(this.xPos, this.yPos, (int)((float)(this.width / 2 * this.maxPerRow) * this.scale), (int)((double)(this.height / 2) * Math.ceil(1.0f * (float)this.maxSize / (float)this.maxPerRow) * (double)this.scale));
    }

    @Override
    public RenderItem.SmallBound setScale(int data) {
        switch (data) {
            case 1: {
                this.scale = 0.5f;
                this.scalePos = 1.0f;
                break;
            }
            case 2: {
                this.scale = 1.0f;
                this.scalePos = 0.0f;
                break;
            }
            case 3: {
                this.scale = 2.0f;
                this.scalePos = -0.5f;
            }
        }
        return new RenderItem.SmallBound(2, (int)((float)(this.width / 2 * this.maxPerRow) * this.scale)){

            @Override
            public void update(BiConsumer<Integer, Integer> action) {
                action.accept(this.type, this.value);
                action.accept(3, (int)((double)(PEffects.this.height / 2) * Math.ceil(1.0f * (float)PEffects.this.maxSize / (float)PEffects.this.maxPerRow) * (double)PEffects.this.scale));
            }
        };
    }

    public static interface Desc {
        default public void render(PEffects p, GuiGraphics g, int mX, int mY, Component[] list, MobEffect effect) {
            p.renderSingleEffectTooltip(g, mX, mY, list, effect);
        }
    }
}

