/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.config.DimConfig;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.PHead;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.RenderSelfItem;
import io.sedu.mc.parties.client.overlay.ScaleItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.client.overlay.anim.DimAnim;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.AnimUtils;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.joml.Vector3f;

public class PDimIcon
extends RenderSelfItem
implements TooltipItem,
ScaleItem {
    private PHead head;
    private float globalScale;

    public PDimIcon(String name, PHead head) {
        super(name);
        this.width = 10;
        this.height = 10;
        this.globalScale = 1.0f;
        this.head = head;
    }

    @Override
    boolean isInBound(int mouseX, int mouseY) {
        return mouseX > this.xPos - 2 && mouseY > this.yPos - 2 && (float)mouseX < (float)(this.xPos + 2) + (float)this.width * this.head.scale && (float)mouseY < (float)(this.yPos + 2) + (float)this.height * this.head.scale;
    }

    @Override
    public void setGlobalScale(float scale) {
        this.globalScale = scale;
    }

    @Override
    int getColor() {
        return 9683555;
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
        DimConfig.entry("minecraft:overworld", (icon, color) -> this.renderGuiItemMenu((ItemStack)icon, b.m_252754_() + 7, b.m_252907_() + 3));
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isOnline) {
            if (id.isSpectator) {
                return;
            }
            if (id.getDim().active) {
                this.worldAnim(x, y, g, id.getDim(), partialTicks);
            } else {
                this.world(x, y, id);
            }
        }
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isSpectator) {
            return;
        }
        if (id.getDim().active) {
            this.worldAnim(x, y, g, id.getDim(), partialTicks);
        } else {
            this.world(x, y, id);
        }
    }

    private void world(int x, int y, ClientPlayerData id) {
        DimConfig.entry(id.getDim().dimension, (icon, color) -> RenderUtils.renderGuiItem(icon, x, y, 0.75f * this.head.scale, 5.0f * this.head.scale, this.zPos, this.globalScale));
    }

    protected void renderGuiItemMenu(ItemStack iStack, int pX, int pY) {
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(iStack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_((float)pX + 5.0f, (float)pY + 5.0f, (float)(this.zPos + 2));
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85841_(0.75f, 0.75f, 1.0f);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.setupGuiFlatDiffuseLighting((Vector3f)RenderUtils.POS, (Vector3f)RenderUtils.NEG);
        Minecraft.m_91087_().m_91291_().m_115143_(iStack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    protected void renderGuiItem(ItemStack iStack, int pX, int pY, float x, float y, float scale, float scalePos, float playerScale) {
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(iStack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_(((float)pX + x + scalePos) * playerScale, ((float)pY + y + scalePos) * playerScale, (float)(this.zPos + 2));
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 1.0f);
        posestack.m_85841_(playerScale, playerScale, 1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85841_(scale * this.head.scale, scale * this.head.scale, 1.0f);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.setupGuiFlatDiffuseLighting((Vector3f)RenderUtils.POS, (Vector3f)RenderUtils.NEG);
        Minecraft.m_91087_().m_91291_().m_115143_(iStack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private void worldAnim(int x, int y, GuiGraphics g, DimAnim dim, float partialTicks) {
        int currTick = 0;
        float translateX = this.head.xPos - this.xPos;
        float translateY = this.head.yPos - this.yPos;
        float scale = 2.0f;
        float scalePos = 16.0f * this.head.scale;
        boolean renderText = false;
        float offY = 0.0f;
        if (dim.animTime > 90) {
            currTick = 10 - (dim.animTime - 90);
            float curPos = AnimUtils.animPos(currTick, partialTicks, true, 10, 2.0f);
            translateX = (float)(this.head.xPos - this.xPos) * curPos;
            translateY = (float)(this.head.yPos - this.yPos) * curPos;
            offY = (float)currTick + partialTicks - 5.0f;
            offY *= -offY;
            offY += 25.0f;
            scale = 0.75f + 1.25f * curPos;
            scalePos = (5.0f + 11.0f * curPos) * this.head.scale;
        } else if (dim.animTime > 10) {
            currTick = dim.animTime - 10;
            renderText = true;
        } else {
            float curPos = AnimUtils.animPos(dim.animTime, partialTicks, false, 10, 2.0f);
            translateX = (float)(this.head.xPos - this.xPos) * curPos;
            translateY = (float)(this.head.yPos - this.yPos) * curPos;
            scale = 0.75f + 1.25f * curPos;
            scalePos = (5.0f + 11.0f * curPos) * this.head.scale;
        }
        this.renderGuiItem(DimConfig.item(dim.dimension), x, y, translateX, translateY += offY, scale, scalePos, this.globalScale);
        if (renderText) {
            this.doTextRender(g, x, y, currTick, partialTicks, dim, DimConfig.color(dim.dimension));
        }
        PDimIcon.resetColor();
    }

    private void doTextRender(GuiGraphics g, int xO, int yO, int currTick, float partialTicks, DimAnim dim, int color) {
        if (!this.textEnabled) {
            return;
        }
        float transX = 0.0f;
        float alphaPercent = 0.0f;
        if (currTick <= 75) {
            if (currTick > 70) {
                alphaPercent = 1.0f - ((float)(currTick -= 70) - partialTicks) / 5.0f;
                transX = 10.0f + ((float)currTick - partialTicks) * 4.0f;
            } else if (currTick > 10) {
                alphaPercent = 1.0f;
                transX = 20.0f * (((float)(currTick -= 10) - partialTicks) / 60.0f) - 10.0f;
            } else if (currTick > 5) {
                alphaPercent = ((float)currTick - partialTicks) / 5.0f;
                transX = -10.0f - (10.0f - ((float)currTick - partialTicks)) * 4.0f;
            } else {
                transX = -10.0f - (10.0f - ((float)currTick - partialTicks)) * 4.0f;
            }
        }
        RenderSystem.enableDepthTest();
        for (int j = 0; j < dim.dimName.size(); ++j) {
            g.m_280168_().m_85836_();
            if (j % 2 == 1) {
                g.m_280168_().m_252880_(-transX, 0.0f, (float)(this.zPos + 10));
            } else {
                g.m_280168_().m_252880_(transX, 0.0f, (float)(this.zPos + 10));
            }
            int x = (int)((float)xO - (float)PDimIcon.getFont().m_92895_(dim.dimName.get(j)) / 2.0f) + 16;
            Objects.requireNonNull(PDimIcon.getFont());
            Objects.requireNonNull(PDimIcon.getFont());
            int y = yO - 9 + j * 9 - (9 * dim.dimName.size() - 1 >> 1);
            if (alphaPercent > 0.0f) {
                this.text(x, y, g, dim.dimName.get(j), color | (int)(255.0f * alphaPercent) << 24, true);
            }
            g.m_280168_().m_85849_();
        }
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("display");
        c.addBooleanEntry("display", this.isEnabled());
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("danim", DimAnim.animActive);
        c.addTitleEntry("position");
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        return c;
    }

    @Override
    protected void itemStart(GuiGraphics g) {
        g.m_280168_().m_85836_();
        if (this.head != null) {
            g.m_280168_().m_85841_(this.head.scale, this.head.scale, 1.0f);
        }
        g.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zPos);
    }

    @Override
    protected int maxX() {
        return Math.max(0, frameEleW - (int)((float)this.width * this.head.scale));
    }

    @Override
    protected int maxY() {
        return Math.max(0, frameEleH - (int)((float)this.height * this.head.scale));
    }

    @Override
    protected void updateValues() {
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("danim", true, 1);
        e.addEntry("xpos", 4, 12);
        e.addEntry("ypos", 32, 12);
        e.addEntry("zpos", 1, 4);
        return e;
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public RenderItem.ItemBound getRenderItemBound() {
        return null;
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        if (p.isOnline && !p.isSpectator) {
            int color = DimConfig.color(p.getDim().dimension);
            int darkCol = (color & 0xFEFEFE) >> 1;
            this.renderTooltip(g, mouseX, mouseY, 10, 0, p.getDim().dimNorm, darkCol, color, 0, darkCol, color);
        }
    }

    @Override
    public RenderItem.SmallBound changeVisibility(boolean data) {
        DimAnim.animActive = data;
        return super.changeVisibility(data);
    }
}

