/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PDead
extends RenderIconTextItem {
    private Renderer render;

    public PDead(String name) {
        super(name);
        this.width = 9;
        this.height = 9;
        this.render = (x, y, id, guiGraphics, partialTicks) -> {
            if (id.isDead && this.iconEnabled) {
                PDead.setup();
                this.blit(guiGraphics, GUI_ICONS, x, y, 16 + (PDead.guiTicks() >> 4 & 1) * 9, 0, 9, 9);
            }
        };
    }

    @Override
    protected int attachedX() {
        return 18;
    }

    @Override
    protected int attachedY() {
        return 1;
    }

    @Override
    int getColor() {
        return 0xAAAAAA;
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 1, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 160, 12);
        e.addEntry("ypos", 8, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("tcolor", 0xBF6666, 24);
        e.addEntry("tattached", false, 1);
        e.addEntry("xtpos", 25, 12);
        e.addEntry("ytpos", 20, 12);
        return e;
    }

    @Override
    public int getId() {
        return 9;
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        this.render.render(x, y, id, g, partialTicks);
    }

    public void updateRendererForMods() {
        this.render = (x, y, id, g, partialTicks) -> {
            if (id.isDead) {
                if (this.iconEnabled) {
                    PDead.setup();
                    this.blit(g, GUI_ICONS, x, y, 16 + (PDead.guiTicks() >> 4 & 1) * 9, 0, 9, 9);
                }
                return;
            }
            if (id.isBleeding()) {
                if (this.iconEnabled) {
                    PDead.setup();
                    this.blit(g, GUI_ICONS, x, y, 16, 0, 9, 9);
                    RenderItem.useAlpha((float)(0.5 + Math.sin(((float)PDead.guiTicks() + partialTicks) / 6.0f) / 2.0));
                    this.blit(g, GUI_ICONS, x, y, 142, 0, 9, 9);
                    RenderItem.resetColor();
                }
                if (this.textEnabled) {
                    this.textCentered(x + this.tX(), y + this.tY(), g, String.valueOf(id.getTimer()), this.color);
                }
            }
            if (id.isDowned()) {
                if (this.iconEnabled) {
                    PDead.setup();
                    this.blit(g, GUI_ICONS, x, y, 16, 0, 9, 9);
                    RenderItem.useAlpha((float)(0.5 + Math.sin(((float)PDead.guiTicks() + partialTicks) / 4.0f) / 2.0));
                    this.blit(g, GUI_ICONS, x, y, 142, 45, 9, 9);
                    RenderItem.resetColor();
                }
                if (this.textEnabled) {
                    this.textCentered(x + this.tX(), y + this.tY(), g, String.valueOf(id.getTimer()), this.color);
                }
            }
        };
    }

    @Override
    void textCentered(int x, int y, GuiGraphics g, String text, int color) {
        this.text((int)((float)x - (float)PDead.getFont().m_92895_(text) / 2.0f), y, g, text, color);
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        this.renderMember(x, y, id, g, partialTicks);
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.isEnabled());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addColorEntry("tcolor", this.color);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        return c;
    }

    private static interface Renderer {
        public void render(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);
    }
}

