/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.mod.ironspellbooks.ISSCompatManager;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.anim.CastAnim;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.fml.ModList;

public class PCastBar
extends RenderIconTextItem {
    protected boolean textHalfSize = true;

    public PCastBar(String name) {
        super(name);
    }

    @Override
    int getColor() {
        return 14521404;
    }

    protected int maxW() {
        return (int)Math.ceil((float)frameEleW / this.scale);
    }

    protected int maxH() {
        return (int)Math.ceil((float)frameEleH / this.scale);
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (ISSCompatManager.active()) {
            updater.get("display").onUpdate(this, true);
        }
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 0, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 172, 12);
        e.addEntry("ypos", 18, 12);
        e.addEntry("width", 64, 12);
        e.addEntry("height", 6, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", true, 1);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        e.addEntry("thalfsize", true, 1);
        return e;
    }

    @Override
    public int getId() {
        return 21;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = new ConfigOptionsList(this::getColor, s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.elementEnabled);
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos, true);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos, true);
        c.addSliderEntry("width", 1, this::maxW, this.width, true);
        c.addSliderEntry("height", 1, this::maxH, this.height, true);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        c.addBooleanEntry("thalfsize", this.textHalfSize);
        return c;
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getCastInfo(castAnim -> this.renderSpell(x, y, (CastAnim)castAnim, g, partialTicks));
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        id.getCastInfo(castAnim -> this.renderSpell(x, y, (CastAnim)castAnim, g, partialTicks));
    }

    void renderSpell(int x, int y, CastAnim castAnim, GuiGraphics g, float partialTicks) {
        if (castAnim.active) {
            castAnim.getSpell(partialTicks, (spell, percent) -> {
                RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 0.0f, this.width, this.height, 14329932, 12755294);
                RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, this.width, this.height, 0x502200, 3479809);
                RenderUtils.offRectNoA(g.m_280168_().m_85850_().m_252922_(), x, y, this.zPos, 1.0f, (float)this.width * percent.floatValue(), this.height, spell.color, (spell.color & 0xFEFEFE) >> 1);
                int xOffset = 0;
                if (this.iconEnabled) {
                    xOffset = 9;
                    PCastBar.resetColor();
                    g.m_280163_(spell.location, x, y - 8, 0.0f, 0.0f, 8, 8, 8, 8);
                    PCastBar.resetColor();
                }
                if (this.textEnabled) {
                    if (this.textHalfSize) {
                        g.m_280168_().m_85836_();
                        g.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                        this.whiterText(x + this.tX() + xOffset << 1, (y + this.tY() << 1) + 9, g, spell.name, spell.color);
                        g.m_280168_().m_85849_();
                    } else {
                        this.text(x + this.tX() + xOffset, y + this.tY() + 2, g, spell.name, spell.color);
                    }
                }
            });
        }
    }

    static void setupSpell(ResourceLocation location) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
    }

    @Override
    protected int attachedX() {
        return 2;
    }

    @Override
    protected int attachedY() {
        return -11;
    }

    protected void rectAnim(PoseStack p, int x, int y, float rightPosition, int startColor, int endColor) {
        RenderUtils.rectNoA(p.m_85850_().m_252922_(), this.zPos, Math.max(x, x + (this.width - 2)) + 1, y + 1, Math.min((float)(x + this.width - 1), (float)(x + 1) + (float)(this.width - 2) * rightPosition), y + this.height - 1, startColor, endColor);
    }

    @Override
    public boolean isEnabled() {
        return this.elementEnabled && ModList.get().isLoaded("irons_spellbooks");
    }
}

