/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.data.config.ClientConfigData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PArmor
extends RenderIconTextItem
implements TooltipItem {
    private MutableComponent tipName = Component.m_237115_((String)"ui.sedparties.tooltip.armor");
    private static ToughnessRender render = (p, x, y, g, armor, toughness, alpha) -> p.renderArmor(x, y, g, armor, alpha);

    public PArmor(String name) {
        super(name);
        this.width = 9;
        this.height = 9;
    }

    @Override
    int getColor() {
        return 12106180;
    }

    @Override
    void renderElement(PoseStack poseStack, ForgeGui gui, Button b) {
    }

    @Override
    void updateDefaultPositionForMods(HashMap<String, RenderItem.Update> updater) {
        if (PArmor.barModsPresent() > 0) {
            updater.get("ypos").onUpdate(this, 17);
        }
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics guiGraphics, float partialTicks) {
        if (!id.isSpectator) {
            render.render(this, x, y, guiGraphics, id.getArmor(), id.getToughness(), id.alpha);
        }
    }

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics guiGraphics, float partialTicks) {
        if (id.isOnline && !id.isSpectator) {
            render.render(this, x, y, guiGraphics, id.getArmor(), id.getToughness(), id.alpha);
        }
    }

    void renderArmor(int x, int y, GuiGraphics guiGraphics, int armor, float alpha) {
        if (this.iconEnabled) {
            PArmor.setup(alpha);
            this.blit(guiGraphics, GUI_ICONS, x, y, 34, 9, 9, 9);
            PArmor.resetColor();
        }
        if (this.textEnabled) {
            this.text(x + this.tX(), y + this.tY(), guiGraphics, String.valueOf(armor), this.color);
        }
    }

    void renderArmorWithToughness(int x, int y, GuiGraphics guiGraphics, int armor, int toughness, float alpha) {
        if (this.iconEnabled) {
            PArmor.setup(alpha);
            this.blit(guiGraphics, GUI_ICONS, x, y, 34, 9, 9, 9);
            PArmor.resetColor();
        }
        if (this.textEnabled) {
            this.text(x + this.tX(), y + this.tY(), guiGraphics, armor + (String)(toughness == 0 ? "" : "\u00a79+" + toughness + "\u00a7r"), this.color);
        }
    }

    public static void updateRendererForToughness() {
        Parties.debug("Editing toughness render...", new Object[0]);
        render = (Boolean)ClientConfigData.toughnessRender.get() != false ? PArmor::renderArmorWithToughness : (p, x, y, g, armor, toughness, alpha) -> p.renderArmor(x, y, g, armor, alpha);
    }

    @Override
    protected int attachedX() {
        return 11;
    }

    @Override
    protected int attachedY() {
        return 1;
    }

    @Override
    protected ConfigOptionsList getConfigOptions(SettingsScreen s, Minecraft minecraft, int x, int y, int w, int h, boolean parse) {
        ConfigOptionsList c = super.getConfigOptions(s, minecraft, x, y, w, h, parse);
        c.addTitleEntry("general");
        c.addBooleanEntry("display", this.isEnabled());
        c.addSliderEntry("scale", 1, () -> 3, this.getScale(), true);
        c.addSliderEntry("zpos", 0, () -> 10, this.zPos);
        c.addTitleEntry("icon");
        c.addBooleanEntry("idisplay", this.iconEnabled);
        c.addSliderEntry("xpos", 0, this::maxX, this.xPos);
        c.addSliderEntry("ypos", 0, this::maxY, this.yPos);
        c.addTitleEntry("text");
        c.addBooleanEntry("tdisplay", this.textEnabled);
        c.addBooleanEntry("tshadow", this.textShadow);
        c.addColorEntry("tcolor", this.color);
        ArrayList<ConfigOptionsList.Entry> entries = new ArrayList<ConfigOptionsList.Entry>();
        c.addBooleanEntry("tattached", this.textAttached, () -> this.toggleTextAttach(entries));
        entries.add(c.addSliderEntry("xtpos", 0, () -> Math.max(0, frameEleW), this.textX));
        entries.add(c.addSliderEntry("ytpos", 0, () -> {
            Objects.requireNonNull(minecraft.f_91062_);
            return Math.max(0, frameEleH - (int)(9.0f * this.scale));
        }, this.textY));
        this.toggleTextAttach(entries);
        return c;
    }

    @Override
    public ConfigEntry getDefaults() {
        ConfigEntry e = new ConfigEntry();
        e.addEntry("display", true, 1);
        e.addEntry("scale", 2, 2);
        e.addEntry("zpos", 0, 4);
        e.addEntry("idisplay", true, 1);
        e.addEntry("xpos", 46, 12);
        e.addEntry("ypos", 19, 12);
        e.addEntry("tdisplay", true, 1);
        e.addEntry("tshadow", false, 1);
        e.addEntry("tcolor", 0xDDF3FF, 24);
        e.addEntry("tattached", true, 1);
        e.addEntry("xtpos", 0, 12);
        e.addEntry("ytpos", 0, 12);
        return e;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public void renderTooltip(GuiGraphics g, ClientPlayerData p, int mouseX, int mouseY) {
        if (p.isOnline && !p.isSpectator) {
            this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + p.getArmor(), 11271423, 6462366, 0xD1D1D1);
            this.renderTooltip(g, mouseX, mouseY, 10, 0, this.tipName.getString() + p.getToughness(), 11271423, 6462366, 0xD1D1D1);
        }
    }

    private static interface ToughnessRender {
        public void render(PArmor var1, int var2, int var3, GuiGraphics var4, int var5, int var6, float var7);
    }
}

