/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.overlay.ClickArea;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.PArmor;
import io.sedu.mc.parties.client.overlay.PCastBar;
import io.sedu.mc.parties.client.overlay.PDead;
import io.sedu.mc.parties.client.overlay.PDimIcon;
import io.sedu.mc.parties.client.overlay.PEffects;
import io.sedu.mc.parties.client.overlay.PEffectsBad;
import io.sedu.mc.parties.client.overlay.PEffectsBene;
import io.sedu.mc.parties.client.overlay.PEffectsBoth;
import io.sedu.mc.parties.client.overlay.PHead;
import io.sedu.mc.parties.client.overlay.PHealth;
import io.sedu.mc.parties.client.overlay.PHunger;
import io.sedu.mc.parties.client.overlay.PLeader;
import io.sedu.mc.parties.client.overlay.PLevelBar;
import io.sedu.mc.parties.client.overlay.PMana;
import io.sedu.mc.parties.client.overlay.PManaI;
import io.sedu.mc.parties.client.overlay.PManaSS;
import io.sedu.mc.parties.client.overlay.PName;
import io.sedu.mc.parties.client.overlay.POffline;
import io.sedu.mc.parties.client.overlay.POrigin;
import io.sedu.mc.parties.client.overlay.PRectD;
import io.sedu.mc.parties.client.overlay.PStamina;
import io.sedu.mc.parties.client.overlay.PTemp;
import io.sedu.mc.parties.client.overlay.PThirst;
import io.sedu.mc.parties.client.overlay.PresetEntry;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.RenderSelfItem;
import io.sedu.mc.parties.client.overlay.ScaleItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.util.RenderUtils;
import io.sedu.mc.parties.util.TriConsumer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Frame {
    int frameCount = 0;
    ClientPlayerData[] data;
    private final LinkedHashMap<String, RenderItem> items = new LinkedHashMap();
    private final List<RenderSelfItem> selfItems = new ArrayList<RenderSelfItem>();
    private final List<RenderItem> memberItems = new ArrayList<RenderItem>();
    private final List<RenderItem> tooltipItems = new ArrayList<RenderItem>();
    private PresetEntry preset;
    private final Type type;
    private int width;
    private int height;
    private int paddingWidth;
    private int paddingHeight;
    private int xOff;
    private int yOff;
    private static final LinkedHashMap<Type, Frame> FRAMES = new LinkedHashMap();

    public void initItems() {
        this.items.put("head", new PHead("head"));
        this.items.put("name", new PName("name"));
        this.items.put("leader", new PLeader("leader"));
        this.items.put("dim", new PDimIcon("dim", (PHead)this.items.get("head")));
        this.items.put("armor", new PArmor("armor"));
        this.items.put("offline", new POffline("offline"));
        this.items.put("dead", new PDead("dead"));
        this.items.put("effects", new PEffectsBoth("effects"));
        this.items.put("effects_b", new PEffectsBene("effects_b"));
        this.items.put("effects_d", new PEffectsBad("effects_d"));
        this.items.put("lvlbar", new PLevelBar("lvlbar"));
        this.items.put("health", new PHealth("health"));
        this.items.put("hunger", new PHunger("hunger"));
        this.items.put("thirst", new PThirst("thirst"));
        this.items.put("stam", new PStamina("stam"));
        this.items.put("mana", new PMana("mana"));
        this.items.put("mana_ss", new PManaSS("mana_ss"));
        this.items.put("mana_i", new PManaI("mana_i"));
        this.items.put("castbar", new PCastBar("castbar"));
        this.items.put("temp", new PTemp("temp"));
        this.items.put("origin", new POrigin("origin"));
        this.items.put("bg1", new PRectD("bg1"));
        this.items.put("bgc", new ClickArea("bgc"));
    }

    public void changeScale(boolean goingUp) {
        this.preset.scale = goingUp ? (this.preset.scale < 0.25 ? 0.25 : (this.preset.scale < 0.5 ? 0.5 : (this.preset.scale < 1.0 ? 1.0 : (this.preset.scale < 2.0 ? 2.0 : 4.0)))) : (this.preset.scale > 4.0 ? 4.0 : (this.preset.scale > 2.0 ? 2.0 : (this.preset.scale > 1.0 ? 1.0 : (this.preset.scale > 0.5 ? 0.5 : 0.25))));
        ((ScaleItem)((Object)this.items.get("dim"))).setGlobalScale((float)this.preset.scale);
        ((ScaleItem)((Object)this.items.get("head"))).setGlobalScale((float)this.preset.scale);
        this.setOffsets();
    }

    public void addX(int i) {
        this.setX(this.trueX() + i);
    }

    public void addY(int i) {
        this.setY(this.trueY() + i);
    }

    public void bindFrame(int width, int height) {
        this.setOffsets();
        this.preset.xPos = (int)Mth.m_14008_((double)this.x(), (double)0.0, (double)Math.max(0.0, (double)width - (double)RenderItem.frameEleW * this.scale())) - this.xOff;
        this.preset.yPos = (int)Mth.m_14008_((double)this.y(), (double)0.0, (double)Math.max(0.0, (double)height - (double)RenderItem.frameEleH * this.scale())) - this.yOff;
    }

    public String getPositionString() {
        return this.trueX() + ", " + this.trueY();
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public Frame(Type t, PresetEntry e) {
        this.type = t;
        this.preset = e;
    }

    public double scale() {
        return this.preset.scale;
    }

    public void setScale(double scale) {
        this.preset.scale = scale;
        ((ScaleItem)((Object)this.items.get("dim"))).setGlobalScale((float)this.preset.scale);
        ((ScaleItem)((Object)this.items.get("head"))).setGlobalScale((float)this.preset.scale);
    }

    public int x() {
        return this.preset.xPos + this.xOff;
    }

    public int y() {
        return this.preset.yPos + this.yOff;
    }

    public int trueX() {
        return this.preset.xPos;
    }

    public int trueY() {
        return this.preset.yPos;
    }

    public void setAnchor(PresetEntry.Anchor a) {
        this.preset.anchor = a;
        this.setOffsets();
    }

    public void setOffsets() {
        switch (this.getAnchor()) {
            case TOP_LEFT: 
            case LEFT: 
            case BOTTOM_LEFT: {
                this.xOff = 0;
                break;
            }
            case TOP_CENTER: 
            case CENTER: 
            case BOTTOM_CENTER: {
                this.xOff = (int)((double)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0 - (double)RenderItem.frameEleW * this.scale() / 2.0);
                break;
            }
            case TOP_RIGHT: 
            case RIGHT: 
            case BOTTOM_RIGHT: {
                this.xOff = (int)((double)Minecraft.m_91087_().m_91268_().m_85445_() - (double)RenderItem.frameEleW * this.scale());
            }
        }
        switch (this.getAnchor()) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                this.yOff = 0;
                break;
            }
            case LEFT: 
            case CENTER: 
            case RIGHT: {
                this.yOff = (int)((double)Minecraft.m_91087_().m_91268_().m_85446_() / 2.0 - (double)RenderItem.frameEleH * this.scale() / 2.0);
                break;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                this.yOff = (int)((double)Minecraft.m_91087_().m_91268_().m_85446_() - (double)RenderItem.frameEleH * this.scale());
            }
        }
        Parties.debug("Offsets have been set to {}, {}, for anchor {}", new Object[]{this.xOff, this.yOff, this.getAnchor()});
    }

    public PresetEntry.Anchor getAnchor() {
        if (this.preset.anchor == null) {
            this.setAnchor(PresetEntry.Anchor.TOP_LEFT);
        }
        return this.preset.anchor;
    }

    public void setX(int x) {
        this.preset.xPos = x;
    }

    public void setY(int y) {
        this.preset.yPos = y;
    }

    public LinkedHashMap<String, RenderItem> getAllItems() {
        return this.items;
    }

    public void updatePresetString(String presetString) {
        this.preset.updatePresetString(presetString);
        ((ScaleItem)((Object)this.items.get("dim"))).setGlobalScale((float)this.preset.scale);
        ((ScaleItem)((Object)this.items.get("head"))).setGlobalScale((float)this.preset.scale);
    }

    public void selfRender(GuiGraphics guiGraphics, float partialTicks) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_((float)this.scale(), (float)this.scale(), 1.0f);
        int x = (int)((double)this.x() / this.scale());
        int y = (int)((double)this.y() / this.scale());
        ClientPlayerData.forSelf(id -> {
            for (RenderSelfItem renderSelfItem : this.selfItems) {
                this.renderSelfItem(renderSelfItem, guiGraphics, x + renderSelfItem.xPos, y + renderSelfItem.yPos, (ClientPlayerData)id, partialTicks);
            }
            for (RenderItem renderItem : this.memberItems) {
                this.renderItem(renderItem, guiGraphics, x + renderItem.xPos, y + renderItem.yPos, (ClientPlayerData)id, partialTicks);
            }
        });
        guiGraphics.m_280168_().m_85849_();
    }

    public void selfRenderParty(GuiGraphics guiGraphics, float partialTicks) {
        if (ClientPlayerData.partySize() > 1) {
            this.selfRender(guiGraphics, partialTicks);
        }
    }

    public int getScaleModifier(float scale) {
        if ((double)scale == 0.5) {
            return 1;
        }
        return 0;
    }

    public void memberRender(GuiGraphics guiGraphics, float partialTicks) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_((float)this.scale(), (float)this.scale(), 1.0f);
        int xN = (int)((double)this.x() / this.scale());
        int yN = (int)((double)this.y() / this.scale());
        ClientPlayerData.forOthersOrdered((i, id) -> {
            int x = xN + RenderItem.framePosW * (i - 1);
            int y = yN + RenderItem.framePosH * (i - 1);
            for (RenderSelfItem renderSelfItem : this.selfItems) {
                this.renderItem(renderSelfItem, guiGraphics, x + renderSelfItem.xPos, y + renderSelfItem.yPos, (ClientPlayerData)id, partialTicks);
            }
            for (RenderItem renderItem : this.memberItems) {
                this.renderItem(renderItem, guiGraphics, x + renderItem.xPos, y + renderItem.yPos, (ClientPlayerData)id, partialTicks);
            }
        });
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderItem(RenderItem item, GuiGraphics guiGraphics, int x, int y, ClientPlayerData id, float partialTicks) {
        item.itemStart(guiGraphics);
        try {
            int s = this.getScaleModifier(item.scale);
            guiGraphics.m_280168_().m_252880_((float)(x * s), (float)(y * s), 0.0f);
            item.renderMember(x, y, id, guiGraphics, partialTicks);
        }
        catch (Exception e) {
            this.sendErrorMessage(item, e);
        }
        item.itemEnd(guiGraphics);
    }

    private void renderSelfItem(RenderSelfItem item, GuiGraphics guiGraphics, int x, int y, ClientPlayerData id, float partialTicks) {
        item.itemStart(guiGraphics);
        try {
            int s = this.getScaleModifier(item.scale);
            guiGraphics.m_280168_().m_252880_((float)(x * s), (float)(y * s), 0.0f);
            item.renderSelf(x, y, id, guiGraphics, partialTicks);
        }
        catch (Exception e) {
            this.sendErrorMessage(item, e);
        }
        item.itemEnd(guiGraphics);
    }

    private void sendErrorMessage(RenderItem item, Exception e) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"messages.sedparties.api.partiesprefix").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)).m_7220_((Component)Component.m_237110_((String)"messages.sedparties.crash.message", (Object[])new Object[]{item.getId(), Component.m_237115_((String)"messages.sedparties.crash.name").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("\u00a7c" + e + "\n\u00a7o\u00a77" + I18n.m_118938_((String)"messages.sedparties.crash.click", (Object[])new Object[0]))))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ExceptionUtils.getStackTrace((Throwable)e))))}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE))));
            item.setEnabled(false);
            RenderItem.isDirty = true;
            Parties.LOGGER.error("Render element #{} crashed.", (Object)item.getId(), (Object)e);
        }
    }

    public void memberRenderFake(GuiGraphics guiGraphics, float partialTicks) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_((float)this.scale(), (float)this.scale(), 1.0f);
        int xN = (int)((double)this.x() / this.scale());
        int yN = (int)((double)this.y() / this.scale());
        for (int i = 0; i <= this.frameCount; ++i) {
            ClientPlayerData id = ClientPlayerData.getOrderedPlayer(i + 1);
            if (id == null) {
                id = this.data[i];
            }
            if (id == null) {
                id = this.data[i] = ClientPlayerData.initFakeData();
            }
            int x = xN + RenderItem.framePosW * i;
            int y = yN + RenderItem.framePosH * i;
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            RenderUtils.renderFrameOutline(x, y, 1.0f, guiGraphics.m_280168_());
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -100.0f);
            for (RenderSelfItem renderSelfItem : this.selfItems) {
                this.renderItem(renderSelfItem, guiGraphics, x + renderSelfItem.xPos, y + renderSelfItem.yPos, id, partialTicks);
            }
            for (RenderItem renderItem : this.memberItems) {
                this.renderItem(renderItem, guiGraphics, x + renderItem.xPos, y + renderItem.yPos, id, partialTicks);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static void init() {
        FRAMES.put(Type.PLAYER, new Frame(Type.PLAYER, new PresetEntry("", 0, 0, 1.0, PresetEntry.Anchor.TOP_LEFT)));
        FRAMES.put(Type.PARTY, new Frame(Type.PARTY, new PresetEntry("", 0, 0, 0.5, PresetEntry.Anchor.LEFT)){

            @Override
            public void changeFakeDisplay(boolean increasing) {
                int n = this.frameCount = increasing ? Math.min(this.frameCount + 1, 4) : Math.max(this.frameCount - 1, 0);
                if (this.frameCount < Math.min(4, ClientPlayerData.partySize()) - 2) {
                    this.frameCount = ClientPlayerData.partySize() - 2;
                }
            }

            @Override
            public void storeFakeData(int partySize) {
                this.frameCount = partySize;
                if (this.data == null) {
                    this.data = new ClientPlayerData[5];
                }
            }

            @Override
            public void getPositionIndex(int mouseX, int mouseY, TriConsumer<Integer, Integer, Integer> consumer) {
                for (int i = 1; i < ClientPlayerData.partySize(); ++i) {
                    if (mouseX < 0 || mouseY < 0) continue;
                    if (mouseX < RenderItem.frameEleW && mouseY < RenderItem.frameEleH) {
                        consumer.accept(mouseX, mouseY, i);
                    }
                    mouseX -= RenderItem.framePosW;
                    mouseY -= RenderItem.framePosH;
                }
            }
        });
    }

    public void changeFakeDisplay(boolean increasing) {
    }

    public void storeFakeData(int partySize) {
        this.frameCount = 0;
    }

    public void deleteFakeData() {
        this.data = null;
    }

    public static void forEachHoveredTooltip(GuiGraphics g, int mouseX, int mouseY, BiConsumer<TooltipItem, ClientPlayerData> consumer) {
        Frame.forEach(f -> f.withinFrameBounds(mouseX, mouseY, (mX, mY) -> f.getPositionIndex((int)mX, (int)mY, (oX, oY, i) -> {
            PEffects.checkEffectTooltip(oX, oY, (effect, index) -> effect.renderTooltip(g, Objects.requireNonNull(ClientPlayerData.getOrderedPlayer((int)i.intValue())).effects, (Integer)index, mouseX, mouseY));
            f.tooltipItems.forEach(t -> {
                if (t.isInBound((int)oX, (int)oY) && t.isEnabled()) {
                    consumer.accept((TooltipItem)((Object)t), ClientPlayerData.getOrderedPlayer(i));
                }
            });
        })));
    }

    public static void getHoveredEffect(int mouseX, int mouseY, Consumer<MobEffect> action) {
        Frame.forEach(f -> f.withinFrameBounds(mouseX, mouseY, (mX, mY) -> f.getPositionIndex((int)mX, (int)mY, (oX, oY, i) -> PEffects.checkEffectTooltip(oX, oY, (effect, index) -> effect.getClientEffect(Objects.requireNonNull(ClientPlayerData.getOrderedPlayer((int)i.intValue())).effects, (Integer)index, e -> action.accept(e.getEffect()))))));
    }

    public void getPositionIndex(int mouseX, int mouseY, TriConsumer<Integer, Integer, Integer> consumer) {
        consumer.accept(mouseX, mouseY, 0);
    }

    public static Type getClickedFrame(double mouseX, double mouseY) {
        for (Map.Entry<Type, Frame> e : FRAMES.entrySet()) {
            if (!e.getValue().withinFrameBounds(mouseX, mouseY)) continue;
            return e.getKey();
        }
        return null;
    }

    public boolean withinFrameBounds(double mouseX, double mouseY) {
        mouseX = (mouseX - (double)this.x()) / this.scale();
        mouseY = (mouseY - (double)this.y()) / this.scale();
        if (mouseX < 0.0 || mouseY < 0.0) {
            return false;
        }
        return mouseX < (double)(RenderItem.frameEleW + RenderItem.framePosW * this.frameCount) && mouseY < (double)(RenderItem.frameEleH + RenderItem.framePosH * this.frameCount);
    }

    public void withinFrameBounds(double mouseX, double mouseY, BiConsumer<Integer, Integer> consumer) {
        mouseX = (mouseX - (double)this.x()) / this.scale();
        mouseY = (mouseY - (double)this.y()) / this.scale();
        if (mouseX < 0.0 || mouseY < 0.0) {
            return;
        }
        if (mouseX < (double)(RenderItem.frameEleW + RenderItem.framePosW * this.frameCount) && mouseY < (double)(RenderItem.frameEleH + RenderItem.framePosH * this.frameCount)) {
            consumer.accept((int)mouseX, (int)mouseY);
        }
    }

    public static List<PresetEntry> getEntries() {
        ArrayList<PresetEntry> entries = new ArrayList<PresetEntry>();
        FRAMES.values().forEach(f -> entries.add(f.preset));
        return entries;
    }

    public static Frame get(Type type) {
        return FRAMES.get((Object)type);
    }

    public static void setEntries(List<PresetEntry> entries) {
        Frame f = FRAMES.get((Object)Type.PLAYER);
        f.preset = entries.get(0);
        f.setScale(f.preset.scale);
        f = FRAMES.get((Object)Type.PARTY);
        f.preset = entries.get(1);
        f.setScale(f.preset.scale);
    }

    public static void forEachEntry(BiConsumer<Frame, PresetEntry> consumer) {
        Frame.forEntry(Type.PLAYER, consumer);
        Frame.forEntry(Type.PARTY, consumer);
    }

    public static void forEntry(Type t, BiConsumer<Frame, PresetEntry> consumer) {
        consumer.accept(FRAMES.get((Object)t), Frame.FRAMES.get((Object)((Object)t)).preset);
    }

    public static void forEach(Consumer<Frame> consumer) {
        Frame f = Frame.get(Type.PLAYER);
        if (f != null) {
            consumer.accept(f);
        }
        if ((f = Frame.get(Type.PARTY)) != null) {
            consumer.accept(f);
        }
    }

    public static void reset() {
        FRAMES.values().forEach(f -> {
            f.selfItems.clear();
            f.tooltipItems.clear();
            f.memberItems.clear();
            f.items.forEach((name, item) -> {
                if (item.isEnabled()) {
                    if (item instanceof RenderSelfItem) {
                        RenderSelfItem selfItem = (RenderSelfItem)item;
                        f.selfItems.add(selfItem);
                    } else {
                        f.memberItems.add((RenderItem)item);
                    }
                    if (item instanceof TooltipItem) {
                        f.tooltipItems.add((RenderItem)item);
                    }
                }
            });
        });
    }

    public String toString() {
        return this.type.name();
    }

    public static enum Type {
        PLAYER,
        PARTY;

    }
}

