/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.api.mod.arsnoveau.ANCompatManager;
import io.sedu.mc.parties.api.mod.epicfight.EFCompatManager;
import io.sedu.mc.parties.api.mod.feathers.FCompatManager;
import io.sedu.mc.parties.api.mod.homeostatic.HCompatManager;
import io.sedu.mc.parties.api.mod.ironspellbooks.ISSCompatManager;
import io.sedu.mc.parties.api.mod.spellsandshields.SSCompatManager;
import io.sedu.mc.parties.client.overlay.DataType;
import io.sedu.mc.parties.client.overlay.Frame;
import io.sedu.mc.parties.client.overlay.anim.CastAnim;
import io.sedu.mc.parties.client.overlay.anim.DimAnim;
import io.sedu.mc.parties.client.overlay.anim.HealthAnim;
import io.sedu.mc.parties.client.overlay.anim.HungerAnim;
import io.sedu.mc.parties.client.overlay.anim.ManaAnim;
import io.sedu.mc.parties.client.overlay.anim.ManaIAnim;
import io.sedu.mc.parties.client.overlay.anim.ManaSSAnim;
import io.sedu.mc.parties.client.overlay.anim.StaminAnim;
import io.sedu.mc.parties.client.overlay.anim.ThirstAnim;
import io.sedu.mc.parties.client.overlay.effects.ClientEffect;
import io.sedu.mc.parties.client.overlay.effects.EffectHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class ClientPlayerData {
    public static HashMap<UUID, ClientPlayerData> playerList = new HashMap();
    public static ArrayList<UUID> playerOrderedList = new ArrayList();
    private static UUID leader;
    public Player clientPlayer;
    boolean isOnline;
    boolean isSpectator;
    private String playerName = "???";
    private boolean trackedOnClient = false;
    private boolean isLeader;
    private ResourceLocation skinLoc = null;
    private final HashMap<DataType, Object> data = new HashMap();
    boolean isDead = false;
    float alpha = 0.6f;
    public int alphaI = 216;
    public boolean shouldRenderModel = false;
    public EffectHolder effects = new EffectHolder();

    public ClientPlayerData() {
        this.initData();
    }

    public static void forSelf(Consumer<ClientPlayerData> action) {
        action.accept(playerList.get(playerOrderedList.get(0)));
    }

    public static void forOthersOrdered(BiConsumer<Integer, ClientPlayerData> action) {
        for (int i = 1; i < playerOrderedList.size(); ++i) {
            action.accept(i, playerList.get(playerOrderedList.get(i)));
        }
    }

    public static void completeReset() {
        playerOrderedList.clear();
        playerList.clear();
        leader = null;
    }

    public static ClientPlayerData initFakeData() {
        RandomSource r = RandomSource.m_216335_((long)0L);
        String[] dims = new String[]{"overworld", "the_nether", "the_end"};
        ClientPlayerData p = new ClientPlayerData();
        p.setName("Fake Player");
        int min = ClientPlayerData.rand(0, 40);
        int max = ClientPlayerData.rand(min, (int)((double)min * 1.5));
        p.getHealth().checkAnim(min, max, ClientPlayerData.rand(0, max));
        p.getHunger(h -> h.checkAnim(ClientPlayerData.rand(0, 20), 20.0f, ClientPlayerData.rand(0, 20)));
        p.setArmor(ClientPlayerData.rand(0, 25));
        p.getDim().activate("minecraft:" + dims[ClientPlayerData.rand(0, dims.length - 1)], true);
        p.isLeader = ClientPlayerData.rand(1, 4) == 1;
        p.setXp(ClientPlayerData.rand(1, 100));
        p.setXpBar(Mth.m_216283_((RandomSource)r, (float)0.0f, (float)1.0f));
        p.setOnline();
        if (ClientPlayerData.rand(0, 10) == 0) {
            p.setOffline();
        }
        return p;
    }

    private static int rand(int min, int max) {
        return (int)(Math.floor(Math.random() * (double)(max - min + 1)) + (double)min);
    }

    private void initData() {
        this.data.put(DataType.DIM, new DimAnim(100, this));
        this.data.put(DataType.HEALTH, new HealthAnim(20, true));
        this.data.put(DataType.HUNGER, new HungerAnim(20, true));
        if (ISSCompatManager.active()) {
            this.data.put(DataType.MANAI, new ManaIAnim(20, true));
            this.data.put(DataType.CASTBAR, new CastAnim(0));
        }
        if (EFCompatManager.active() || FCompatManager.active()) {
            this.data.put(DataType.EF_STAM, new StaminAnim(20, true));
        }
        if (ANCompatManager.getHandler().exists()) {
            this.data.put(DataType.MANA, new ManaAnim(20, true));
        }
        if (SSCompatManager.active()) {
            this.data.put(DataType.SSMANA, new ManaSSAnim(20, true));
        }
        if (HCompatManager.active()) {
            this.data.put(DataType.THIRST, new ThirstAnim(20, true));
        }
    }

    public static void getOrderedPlayer(int index, Consumer<ClientPlayerData> action) {
        ClientPlayerData data;
        UUID id;
        if (!playerOrderedList.isEmpty() && (id = playerOrderedList.get(index)) != null && (data = playerList.get(id)) != null) {
            action.accept(data);
        }
    }

    public static ClientPlayerData getOrderedPlayer(int index) {
        ClientPlayerData data;
        UUID id;
        if (!playerOrderedList.isEmpty() && playerOrderedList.size() > index && (id = playerOrderedList.get(index)) != null && (data = playerList.get(id)) != null) {
            return data;
        }
        return null;
    }

    public static void getSelf(Consumer<ClientPlayerData> action) {
        ClientPlayerData.getOrderedPlayer(0, action);
    }

    public static void addClientMember(UUID uuid) {
        ClientPlayerData p = new ClientPlayerData();
        p.setId(uuid);
    }

    public static int partySize() {
        return playerOrderedList.size();
    }

    public static void reset() {
        ClientPlayerData.resetOnly();
    }

    public static void addSelf() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null) {
            ClientPlayerData.addClientMember(p.m_20148_());
            if (Frame.get(Frame.Type.PLAYER).getAllItems().get("dim").isEnabled()) {
                playerList.get(p.m_20148_()).setClientPlayer((Player)p).getDim().activate(String.valueOf(p.m_9236_().m_46472_().m_135782_()), true);
            }
            ClientPlayerData.playerList.get((Object)p.m_20148_()).isOnline = true;
        }
    }

    public DimAnim getDim() {
        return (DimAnim)this.data.get((Object)DataType.DIM);
    }

    public static void changeLeader(UUID uuid) {
        ClientPlayerData.checkParty();
        if (playerList.get(leader) != null) {
            ClientPlayerData.playerList.get((Object)ClientPlayerData.leader).isLeader = false;
        }
        leader = uuid;
        ClientPlayerData.playerList.get((Object)uuid).isLeader = true;
    }

    private static void checkParty() {
        if (ClientPlayerData.partySize() == 0) {
            ClientPlayerData.addSelfParty();
        }
    }

    public static void addSelfParty() {
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null) {
            ClientPlayerData.addClientMember(p.m_20148_());
        }
    }

    public static void resetOnly() {
        UUID selfId = playerOrderedList.size() > 0 ? playerOrderedList.get(0) : null;
        ClientPlayerData self = selfId == null ? null : playerList.get(selfId);
        playerOrderedList.clear();
        playerList.clear();
        leader = null;
        if (self != null) {
            self.isLeader = false;
            playerOrderedList.add(selfId);
            playerList.put(selfId, self);
            Player p = self.clientPlayer;
            if (p != null && Frame.get(Frame.Type.PLAYER).getAllItems().get("dim").isEnabled()) {
                playerList.get(p.m_20148_()).setClientPlayer(p).getDim().activate(String.valueOf(p.m_9236_().m_46472_().m_135782_()), true);
            }
        } else {
            ClientPlayerData.addSelfParty();
        }
    }

    public static void updateSelfDim(String data) {
        ClientPlayerData.getSelf(playerData -> {
            if (Frame.get(Frame.Type.PLAYER).getAllItems().get("dim").isEnabled()) {
                playerData.getDim().activate(data, false);
            }
        });
    }

    public static void markEffectsDirty() {
        playerList.values().forEach(c -> c.effects.refresh());
    }

    public static void forEachOrdered(BiConsumer<Integer, ClientPlayerData> action) {
        for (int i = 0; i < playerOrderedList.size(); ++i) {
            action.accept(i, playerList.get(playerOrderedList.get(i)));
        }
    }

    public void setId(UUID uuid) {
        this.trackedOnClient = false;
        playerList.put(uuid, this);
        playerOrderedList.add(uuid);
    }

    private void setSkin(String name) {
        try {
            SkullBlockEntity.m_155738_((GameProfile)new GameProfile(null, name), filledProfile -> {
                Minecraft minecraft = Minecraft.m_91087_();
                Map map = minecraft.m_91109_().m_118815_(filledProfile);
                this.skinLoc = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.m_118627_((UUID)UUID.randomUUID());
            });
        }
        catch (Exception e) {
            this.skinLoc = DefaultPlayerSkin.m_118627_((UUID)UUID.randomUUID());
        }
    }

    public void setOnline() {
        this.isOnline = true;
        if (this.isTrackedOnServer()) {
            this.alpha = 0.6f;
            this.alphaI = 216;
            return;
        }
        this.alpha = 1.0f;
        this.alphaI = 255;
    }

    public void setSpectator(boolean spec) {
        this.isSpectator = spec;
    }

    public void setOffline() {
        this.isOnline = false;
        this.isDead = false;
        this.alpha = 0.25f;
        this.alphaI = 64;
    }

    public String getName() {
        return this.trackedOnClient ? this.clientPlayer.m_7755_().getString() : this.playerName;
    }

    public ClientPlayerData setClientPlayer(Player entity) {
        this.clientPlayer = entity;
        this.trackedOnClient = true;
        this.shouldRenderModel = true;
        this.playerName = entity.m_7755_().getString();
        if (this.skinLoc == null) {
            this.setSkin(this.playerName);
        }
        this.getHealth().activate(Float.valueOf(entity.m_21223_()), Float.valueOf(entity.m_21233_()), Float.valueOf(entity.m_6103_()));
        this.data.put(DataType.ARMOR, entity.m_21230_());
        this.data.put(DataType.ARMORT, PlayerAPI.getToughnessValue(entity));
        if (this.getHealth().cur > 0.0f) {
            this.markAlive();
        } else {
            this.markDead();
        }
        this.alpha = 1.0f;
        this.alphaI = 255;
        return this;
    }

    public HealthAnim getHealth() {
        return (HealthAnim)this.data.get((Object)DataType.HEALTH);
    }

    public void removeClientPlayer() {
        this.clientPlayer = null;
        this.trackedOnClient = false;
        this.alpha = 0.6f;
        this.alphaI = 192;
        this.shouldRenderModel = false;
    }

    public boolean isTrackedOnServer() {
        return !this.trackedOnClient;
    }

    public static String getName(UUID uuid) {
        return playerList.get(uuid).getName();
    }

    public void setName(String data) {
        this.playerName = data;
        this.setSkin(data);
    }

    public ResourceLocation getHead() {
        return this.skinLoc == null ? DefaultPlayerSkin.m_118626_() : this.skinLoc;
    }

    public int getArmor() {
        return this.clientPlayer != null ? this.clientPlayer.m_21230_() : ((Integer)this.data.getOrDefault((Object)DataType.ARMOR, 0)).intValue();
    }

    public int getToughness() {
        return this.clientPlayer != null ? PlayerAPI.getToughnessValue(this.clientPlayer).intValue() : ((Integer)this.data.getOrDefault((Object)DataType.ARMORT, 0)).intValue();
    }

    public void getHunger(Consumer<HungerAnim> action) {
        this.data.computeIfPresent(DataType.HUNGER, (data, hunger) -> {
            action.accept((HungerAnim)hunger);
            return hunger;
        });
    }

    public int getLevelForced() {
        return this.clientPlayer != null ? this.clientPlayer.f_36078_ : 0;
    }

    public float getXpBarForced() {
        return this.clientPlayer != null ? this.clientPlayer.f_36080_ : 0.0f;
    }

    public float getXpBar() {
        return ((Float)this.data.getOrDefault((Object)DataType.XPPROGRESS, Float.valueOf(0.0f))).floatValue();
    }

    public int getXpLevel() {
        return (Integer)this.data.getOrDefault((Object)DataType.XPLEVEL, 0);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setHealth(float data) {
        this.getHealth().checkHealth(data);
    }

    public float getReviveProgress() {
        return ((Float)this.data.getOrDefault((Object)DataType.REVIVEPROG, Float.valueOf(0.0f))).floatValue();
    }

    public void setAbsorb(float data) {
        this.getHealth().checkAbsorb(data);
    }

    public void setArmor(int data) {
        this.data.put(DataType.ARMOR, data);
    }

    public void setToughness(int data) {
        this.data.put(DataType.ARMORT, data);
    }

    public void setFood(int data) {
        Parties.debug("Setting food for {}: {}", this.playerName, data);
        this.getHunger(hunger -> hunger.checkHealth(data));
    }

    public void setXp(int data) {
        this.data.put(DataType.XPLEVEL, data);
    }

    public void setMaxHealth(float max) {
        this.getHealth().checkMax(max);
    }

    public void markDead() {
        this.isDead = true;
        this.data.put(DataType.BLEEDING, false);
        this.data.put(DataType.DOWNED, false);
        this.effects.markForRemoval();
    }

    public void markAlive() {
        this.isDead = false;
    }

    public void setEffect(int type, int duration, int amp) {
        if (duration == -1024) {
            this.effects.setInfinite(type, amp);
        } else {
            this.effects.set(type, (int)Math.ceil((float)duration / 20.0f), amp);
        }
        if (MobEffect.m_19453_((int)type) == MobEffects.f_19617_) {
            float absorb = (float)(amp + 1) * 4.0f;
            if (this.getHealth().getAbsorb() < absorb) {
                this.getHealth().checkAbsorb(absorb);
            }
        }
    }

    public void removeEffect(int type) {
        this.effects.markForRemoval(type);
        if (MobEffect.m_19453_((int)type) == MobEffects.f_19617_) {
            this.getHealth().checkAbsorb(0.0f);
        }
    }

    public void tick() {
        if (this.trackedOnClient) {
            this.getHealth().checkAnim(this.clientPlayer.m_21223_(), this.clientPlayer.m_21233_(), this.clientPlayer.m_6103_());
        }
    }

    public void slowTick() {
        int bleedTimer;
        if (!this.isDead) {
            this.effects.removeIf(ClientEffect::update);
        }
        if ((bleedTimer = ((Integer)this.data.getOrDefault((Object)DataType.BLEEDTIMER, 0)).intValue()) > 0) {
            this.data.put(DataType.BLEEDTIMER, --bleedTimer);
        }
    }

    public void setXpBar(float data) {
        this.data.put(DataType.XPPROGRESS, Float.valueOf(data));
    }

    public void changeBleeding(boolean isBleeding, Integer datum) {
        this.data.put(DataType.BLEEDING, isBleeding);
        if (isBleeding) {
            this.data.put(DataType.DOWNED, false);
        }
        this.data.put(DataType.BLEEDTIMER, datum);
    }

    public void changeDownedState(boolean isDowned, Integer datum) {
        this.data.put(DataType.DOWNED, isDowned);
        if (isDowned) {
            this.data.put(DataType.BLEEDING, false);
        } else {
            this.data.put(DataType.REVIVEPROG, Float.valueOf(0.0f));
        }
        this.data.put(DataType.BLEEDTIMER, datum - 2);
    }

    public void setReviveProgress(Float data) {
        this.data.put(DataType.REVIVEPROG, data);
    }

    public void getThirst(Consumer<ThirstAnim> action) {
        this.data.computeIfPresent(DataType.THIRST, (data, stam) -> {
            action.accept((ThirstAnim)stam);
            return stam;
        });
    }

    public void setThirst(Integer data) {
        this.getThirst(thirst -> thirst.checkHealth(data.intValue()));
    }

    public void setWorldTemp(Float data) {
        if (HCompatManager.active()) {
            this.data.put(DataType.WORLDTEMP, HCompatManager.getHandler().convertTemp(data.floatValue()));
            this.data.put(DataType.SEVERITY, HCompatManager.getHandler().getWorldTempSev(data.floatValue(), this.getSeverity()));
        }
    }

    public void setBodyTemp(float data) {
        if (HCompatManager.active()) {
            this.data.put(DataType.BODYTEMP, HCompatManager.getHandler().convertTemp(data));
            this.data.put(DataType.SEVERITY, HCompatManager.getHandler().getBodyTempSev(data, this.getSeverity()));
        } else {
            this.data.put(DataType.BODYTEMP, (int)data);
        }
    }

    public void updateTemperatures() {
    }

    public void updateTemperaturesH() {
        if (this.clientPlayer != null) {
            HCompatManager.getHandler().getClientTemperature(this.clientPlayer, (localTemp, bodyTemp, severity) -> {
                this.data.put(DataType.WORLDTEMP, localTemp);
                this.data.put(DataType.SEVERITY, severity);
                this.data.put(DataType.BODYTEMP, bodyTemp);
            });
        }
    }

    public void updateTemperaturesTAN() {
    }

    public void updateThirst() {
        if (this.clientPlayer != null) {
            // empty if block
        }
    }

    public void updateThirstH() {
        if (this.clientPlayer != null) {
            this.getThirst(thirst -> thirst.checkHealth(HCompatManager.getHandler().getWaterLevel(this.clientPlayer)));
        }
    }

    public void updateThirstTAN() {
        if (this.clientPlayer != null) {
            // empty if block
        }
    }

    public void updateThirstTFC() {
    }

    public void setWorldTempTAN(int data) {
        this.data.put(DataType.WORLDTEMP, data);
        this.data.put(DataType.TEMPTYPE, this.getTempType(data));
        if (data == 0 || data == 4) {
            this.data.put(DataType.SEVERITY, 1);
        } else {
            this.data.put(DataType.SEVERITY, 0);
        }
    }

    private String getTempType(int data) {
        Parties.debug("Setting temperature for: " + data, new Object[0]);
        return switch (data) {
            case 0 -> "Icy";
            case 1 -> "Cold";
            case 2 -> "Cool";
            case 3 -> "Warm";
            default -> "Hot";
        };
    }

    public void updateMana() {
        if (this.clientPlayer != null) {
            ANCompatManager.getHandler().getManaValues(this.clientPlayer, (f1, f2) -> this.getMana(mana -> mana.checkValues(f1.floatValue(), (int)f2)));
        }
    }

    public void getMana(Consumer<ManaAnim> action) {
        this.data.computeIfPresent(DataType.MANA, (data, mana) -> {
            action.accept((ManaAnim)mana);
            return mana;
        });
    }

    public void getManaI(Consumer<ManaIAnim> action) {
        this.data.computeIfPresent(DataType.MANAI, (data, mana) -> {
            action.accept((ManaIAnim)mana);
            return mana;
        });
    }

    public void setMana(float data) {
        this.getMana(mana -> mana.checkHealth(data));
    }

    public void setMaxMana(int data) {
        this.getMana(mana -> mana.checkMax(data));
    }

    public boolean bleedOrDowned() {
        return (Boolean)this.data.getOrDefault((Object)DataType.BLEEDING, false) != false || (Boolean)this.data.getOrDefault((Object)DataType.DOWNED, false) != false;
    }

    public boolean isBleeding() {
        return (Boolean)this.data.getOrDefault((Object)DataType.BLEEDING, false);
    }

    public boolean isDowned() {
        return (Boolean)this.data.getOrDefault((Object)DataType.DOWNED, false);
    }

    public int getTimer() {
        return (Integer)this.data.getOrDefault((Object)DataType.BLEEDTIMER, 0);
    }

    public int getWorldTemp() {
        return (Integer)this.data.getOrDefault((Object)DataType.WORLDTEMP, 0);
    }

    public int getBodyTemp() {
        return (Integer)this.data.getOrDefault((Object)DataType.BODYTEMP, 0);
    }

    public String getTempType() {
        return (String)this.data.getOrDefault((Object)DataType.TEMPTYPE, "");
    }

    public int getSeverity() {
        return (Integer)this.data.getOrDefault((Object)DataType.SEVERITY, 0);
    }

    public void getStaminaEF(Consumer<StaminAnim> action) {
        this.data.computeIfPresent(DataType.EF_STAM, (data, stam) -> {
            action.accept((StaminAnim)stam);
            return stam;
        });
    }

    public void updateStamEF() {
        if (this.clientPlayer != null) {
            EFCompatManager.getHandler().getClientValues(this.clientPlayer, (f1, f2) -> this.getStaminaEF(stam -> stam.checkAnim(f1.floatValue(), f2.intValue(), 0.0f)));
        }
    }

    public void setCurrentStamina(float stamina) {
        this.getStaminaEF(stam -> stam.checkHealth(stamina));
    }

    public void setMaxStamina(int stamina) {
        this.getStaminaEF(stam -> stam.checkMax(stamina));
    }

    public void checkHunger() {
        if (this.clientPlayer != null) {
            this.getHunger(hunger -> hunger.checkHealth(this.clientPlayer.m_36324_().m_38702_()));
        }
    }

    public void getManaSS(Consumer<ManaSSAnim> action) {
        this.data.computeIfPresent(DataType.SSMANA, (data, mana) -> {
            action.accept((ManaSSAnim)mana);
            return mana;
        });
    }

    public void updateManaSS() {
        if (this.clientPlayer != null) {
            this.getManaSS(mana -> SSCompatManager.getHandler().getAllMana(this.clientPlayer, mana::checkAnim));
        }
    }

    public void checkMaxManaSS() {
        if (this.clientPlayer != null) {
            this.getManaSS(mana -> mana.checkMax(SSCompatManager.getHandler().getMax(this.clientPlayer)));
        }
    }

    public void setManaSS(Float data) {
        this.getManaSS(mana -> mana.checkHealth(data.floatValue()));
    }

    public void setMaxManaSS(Float data) {
        this.getManaSS(mana -> mana.checkMax(data.floatValue()));
    }

    public void setExtraManaSS(Float data) {
        this.getManaSS(mana -> mana.checkAbsorb(data.floatValue()));
    }

    public void checkStamF() {
        FCompatManager.getHandler().getClientFeathers((cur, max, abs) -> this.getStaminaEF(staminAnim -> staminAnim.checkAnim(Math.min(max, cur), max.intValue(), abs.intValue())));
    }

    public void setExtraStam(Integer data) {
        this.getStaminaEF(stam -> stam.checkAbsorb(data.intValue()));
    }

    public void setQuench(int data) {
        this.getThirst(thirst -> thirst.checkAbsorb(data));
    }

    public void setMaxHunger(float data) {
        Parties.debug("Setting max food for " + this.getName() + ": " + data, new Object[0]);
        this.getHunger(hunger -> hunger.checkMax(data));
    }

    public void setSaturation(float data) {
        this.getHunger(hunger -> hunger.checkAbsorb(data));
    }

    public void setNutrition(float data) {
        this.getHealth().setMultiplier(data);
    }

    public void setOrigin(String data) {
        this.data.put(DataType.ORIGIN, data);
    }

    public void getOrigin(Consumer<String> action) {
        this.data.computeIfPresent(DataType.ORIGIN, (data, origin) -> {
            action.accept((String)origin);
            return origin;
        });
    }

    public void updateManaISS() {
        if (this.clientPlayer != null) {
            ISSCompatManager.getHandler().getClientMana(this.clientPlayer, (i1, i2) -> this.getManaI(mana -> mana.checkValues((int)i1, (int)i2)));
        }
    }

    public void setManaI(Integer data) {
        this.getManaI(mana -> mana.checkHealth(data));
    }

    public void setMaxManaI(Integer data) {
        this.getManaI(mana -> mana.checkMax(data));
    }

    public void getCastInfo(Consumer<CastAnim> action) {
        this.data.computeIfPresent(DataType.CASTBAR, (data, cast) -> {
            action.accept((CastAnim)cast);
            return cast;
        });
    }

    public void initSpell(String spellId, int castDuration) {
        Parties.debug("Casting spell for: " + this.playerName, new Object[0]);
        this.getCastInfo(cast -> cast.activate(spellId, castDuration));
    }

    public void finishSpell() {
        this.getCastInfo(CastAnim::markDone);
    }

    public void updateNutrition() {
    }
}

