/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import io.sedu.mc.parties.api.helper.ColorAPI;
import io.sedu.mc.parties.client.config.ConfigEntry;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.client.overlay.RenderIconTextItem;
import io.sedu.mc.parties.client.overlay.RenderItem;
import io.sedu.mc.parties.client.overlay.TooltipItem;
import io.sedu.mc.parties.client.overlay.gui.ConfigOptionsList;
import io.sedu.mc.parties.client.overlay.gui.SettingsScreen;
import io.sedu.mc.parties.util.RenderUtils;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public abstract class BarBase
extends RenderIconTextItem
implements TooltipItem {
    protected final Component tipName;
    int hue = 0;
    int deadColor;
    int colorTop;
    int colorBot;
    int colorTopMissing;
    int colorBotMissing;
    int colorIncTop;
    int colorIncBot;
    int colorDecTop;
    int colorDecBot;
    int bColorTop;
    int bColorBot;
    private static Renderer renderLastDimmer;
    BarMode renderBar;
    boolean barMode;

    public BarBase(String name, Component c) {
        super(name);
        this.tipName = c;
        renderLastDimmer = (x, y, id, poseStack, barBase) -> {};
        this.renderBar = (x, y, id, g, partialTicks) -> {
            this.renderSelfBar(x, y, id, g, partialTicks);
            renderLastDimmer.render(x, y, id, g, this);
        };
    }

    @Override
    int getColor() {
        return this.colorTop;
    }

    @Override
    protected abstract void renderElement(PoseStack var1, ForgeGui var2, Button var3);

    @Override
    void renderMember(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isOnline && !id.isSpectator) {
            this.renderBar.render(x, y, id, g, partialTicks);
        }
    }

    @Override
    void renderSelf(int x, int y, ClientPlayerData id, GuiGraphics g, float partialTicks) {
        if (id.isSpectator) {
            return;
        }
        this.renderBar.render(x, y, id, g, partialTicks);
    }

    protected abstract void renderSelfBar(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);

    protected abstract void renderSelfIcon(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);

    public static void updateRendererForMods() {
        renderLastDimmer = (x, y, id, g, barItem) -> {
            if (id.bleedOrDowned()) {
                RenderUtils.sizeRect(g.m_280168_().m_85850_().m_252922_(), barItem.xPos, barItem.yPos, barItem.zPos, barItem.width, barItem.height, -1778384896);
            }
        };
    }

    protected void rectRNoA(PoseStack p, int x, int y, float rightPosition, int startColor, int endColor) {
        RenderUtils.sizeRectNoA(p.m_85850_().m_252922_(), x + 1, y + 1, this.zPos, Math.min((float)(this.width - 1), (float)(this.width - 2) * rightPosition), this.height - 2, startColor, endColor);
    }

    protected void rectB(PoseStack p, int x, int y, float leftPosition, float rightPosition, int startColor, int endColor) {
        RenderUtils.rectNoA(p.m_85850_().m_252922_(), this.zPos, Math.max((float)x, (float)x + (float)(this.width - 2) * leftPosition) + 1.0f, y + 1, Math.min((float)(x + this.width - 1), (float)(x + 1) + (float)(this.width - 2) * rightPosition), y + this.height - 1, startColor, endColor);
    }

    protected void rectAnim(PoseStack p, int x, int y, float leftPosition, float rightPosition, int startColor, int endColor) {
        RenderUtils.rectNoA(p.m_85850_().m_252922_(), this.zPos, Math.max((float)x, (float)x + (float)(this.width - 2) * leftPosition) + 1.0f, y + 1, Math.min((float)(x + this.width - 1), (float)(x + 1) + (float)(this.width - 2) * rightPosition), y + this.height - 1, startColor, endColor);
    }

    @Override
    protected int attachedX() {
        return (this.width >> 1) + 1;
    }

    @Override
    protected int attachedY() {
        return (this.height >> 1) + 1;
    }

    public int tXI() {
        return this.textAttached ? this.attachedXIcon() : this.textX;
    }

    public int tYI() {
        return this.textAttached ? this.attachedYIcon() : this.textY;
    }

    protected int attachedXIcon() {
        return 11;
    }

    protected int attachedYIcon() {
        return 1;
    }

    @Override
    protected void updateValues() {
        this.xPos = Mth.m_14045_((int)this.xPos, (int)0, (int)this.maxX());
        this.yPos = Mth.m_14045_((int)this.yPos, (int)0, (int)this.maxY());
        this.width = Mth.m_14045_((int)this.width, (int)0, (int)this.maxW());
        this.height = Mth.m_14045_((int)this.height, (int)0, (int)this.maxH());
    }

    protected int maxW() {
        return (int)Math.ceil((float)frameEleW / this.scale);
    }

    protected int maxH() {
        return (int)Math.ceil((float)frameEleH / this.scale);
    }

    protected void setMainColors() {
        float hue = (float)this.hue / 100.0f;
        this.bColorTop = ColorAPI.HSBtoRGB(hue, 0.5f, 0.25f);
        this.bColorBot = ColorAPI.HSBtoRGB(hue, 0.25f, 0.5f);
        this.color = ColorAPI.HSBtoRGB(hue, 0.2f, 1.0f);
        this.deadColor = ColorAPI.HSBtoRGB(hue, 0.25f, 0.75f);
        this.colorTop = ColorAPI.HSBtoRGB(hue, 0.8f, 0.77f);
        this.colorBot = ColorAPI.HSBtoRGB(hue, 0.88f, 0.42f);
        this.colorTopMissing = ColorAPI.HSBtoRGB(hue, 0.97f, 0.27f);
        this.colorBotMissing = ColorAPI.HSBtoRGB(hue, 0.91f, 0.38f);
    }

    @Override
    public RenderItem.SmallBound setColor(int type, int data) {
        switch (type) {
            case 0: {
                this.colorIncTop = data;
                break;
            }
            case 1: {
                this.colorIncBot = data;
                break;
            }
            case 2: {
                this.colorDecTop = data;
                break;
            }
            case 3: {
                this.colorDecBot = data;
            }
        }
        return null;
    }

    @Override
    public int getColor(int type) {
        switch (type) {
            case 0: {
                return this.colorIncTop;
            }
            case 1: {
                return this.colorIncBot;
            }
            case 2: {
                return this.colorDecTop;
            }
            case 3: {
                return this.colorDecBot;
            }
        }
        return 0;
    }

    protected RenderItem.SmallBound setMainHue(int d) {
        this.hue = d;
        this.setMainColors();
        return null;
    }

    @Override
    public abstract void renderTooltip(GuiGraphics var1, ClientPlayerData var2, int var3, int var4);

    @Override
    public abstract ConfigEntry getDefaults();

    @Override
    protected abstract ConfigOptionsList getConfigOptions(SettingsScreen var1, Minecraft var2, int var3, int var4, int var5, int var6, boolean var7);

    public abstract RenderItem.SmallBound setTextType(int var1);

    public abstract int getTextType();

    public boolean isBarMode() {
        return this.barMode;
    }

    public RenderItem.SmallBound toggleBarMode(boolean b) {
        this.barMode = b;
        if (b) {
            this.renderBar = (x, y, id, g, partialTicks) -> {
                this.renderSelfBar(x, y, id, g, partialTicks);
                renderLastDimmer.render(x, y, id, g, this);
            };
            return new RenderItem.SmallBound(2, (int)((float)this.width * this.scale)){

                @Override
                public void update(BiConsumer<Integer, Integer> action) {
                    action.accept(this.type, this.value);
                    action.accept(3, (int)((float)BarBase.this.height * BarBase.this.scale));
                }
            };
        }
        this.renderBar = this::renderSelfIcon;
        return new RenderItem.SmallBound(2, (int)(9.0f * this.scale)){

            @Override
            public void update(BiConsumer<Integer, Integer> action) {
                action.accept(this.type, this.value);
                action.accept(3, (int)(9.0f * BarBase.this.scale));
            }
        };
    }

    @Override
    boolean isInBound(int mouseX, int mouseY) {
        if (this.barMode) {
            return mouseX > this.xPos - 2 && mouseY > this.yPos - 2 && (float)mouseX < (float)(this.xPos + 2) + (float)this.width * this.scale && (float)mouseY < (float)(this.yPos + 2) + (float)this.height * this.scale;
        }
        return mouseX > this.xPos - 2 && mouseY > this.yPos - 2 && (float)mouseX < (float)(this.xPos + 2) + 9.0f * this.scale && (float)mouseY < (float)(this.yPos + 2) + 9.0f * this.scale;
    }

    private static interface Renderer {
        public void render(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, BarBase var5);
    }

    static interface BarMode {
        public void render(int var1, int var2, ClientPlayerData var3, GuiGraphics var4, float var5);
    }
}

