/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.config;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class DimConfig {
    public static HashMap<String, DimEntry> dimEntries = new HashMap();
    public static HashMap<String, DimEntry> missingEntries = new HashMap();
    public static final DimEntry DEFAULT_ENTRY = new DimEntry(Items.f_41829_, 0xFFFFFFF, 0);

    public static void checkDim(String resource) {
        Parties.debug("Checking for dim called " + resource + ".", new Object[0]);
        if (dimEntries.containsKey(resource) || missingEntries.containsKey(resource)) {
            Parties.debug("Dimension found, no action needed.", new Object[0]);
        } else {
            Parties.debug("Dimension not found, storing in config/dims/missing.json", new Object[0]);
            Config.forEachMissing(list -> list.forEach(DimConfig::addMissingEntry));
            missingEntries.put(resource, new DimEntry(Items.f_41829_, 0xFFFFFF, -1));
            Config.saveMissingDims();
        }
    }

    public static void entry(String loc, BiConsumer<ItemStack, Integer> action) {
        Objects.requireNonNull(action);
        DimEntry d = dimEntries.getOrDefault(loc, missingEntries.getOrDefault(loc, DEFAULT_ENTRY));
        action.accept(d.item, d.color);
    }

    public static int color(String loc) {
        return DimConfig.dimEntries.getOrDefault((Object)loc, (DimEntry)DimConfig.missingEntries.getOrDefault((Object)loc, (DimEntry)DimConfig.DEFAULT_ENTRY)).color;
    }

    public static ItemStack item(String loc) {
        return DimConfig.dimEntries.getOrDefault((Object)loc, (DimEntry)DimConfig.missingEntries.getOrDefault((Object)loc, (DimEntry)DimConfig.DEFAULT_ENTRY)).item;
    }

    public static void init() {
        List<DimEntryConfig> dims = DimConfig.getDefaultDims();
        dims.forEach(DimConfig::addDimEntry);
        Config.saveDefaultDims(dims);
        Config.forEachDimFile(list -> list.forEach(DimConfig::addDimEntry));
        missingEntries.clear();
        Config.forEachMissing(list -> list.forEach(DimConfig::addMissingEntry));
        Config.saveMissingDims();
    }

    public static List<DimEntryConfig> getDefaultDims() {
        ArrayList<DimEntryConfig> dims = new ArrayList<DimEntryConfig>();
        dims.add(new DimEntryConfig("minecraft:overworld", "minecraft:grass_block", 8183709, -1));
        dims.add(new DimEntryConfig("minecraft:the_nether", "minecraft:netherrack", 16767610, -1));
        dims.add(new DimEntryConfig("minecraft:the_end", "minecraft:end_portal_frame", 13597919, -1));
        dims.add(new DimEntryConfig("twilightforest:twilight_forest", "twilightforest:twilight_portal_miniature_structure", 5819318, -1));
        dims.add(new DimEntryConfig("rftoolsdim:dim", "rftoolsdim:dimensional_cross_block", 0xBBDDDD, -2));
        dims.add(new DimEntryConfig("rftoolsdim:dim", "rftoolsutility:matter_transmitter", 0xBBDDDD, -1));
        dims.add(new DimEntryConfig("aether:the_aether", "aether:aether_grass_block", 5759716, -1));
        return dims;
    }

    public static void reload() {
        dimEntries.clear();
        DimConfig.init();
        try {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"messages.sedparties.config.reloadsuccess"), true);
        }
        catch (Exception e) {
            Parties.LOGGER.error((Object)e);
        }
    }

    private static void addDimEntry(DimEntryConfig entry) {
        if (!ModList.get().isLoaded(entry.dimension.substring(0, entry.dimension.indexOf(58)))) {
            return;
        }
        if (dimEntries.containsKey(entry.dimension) && DimConfig.dimEntries.get((Object)entry.dimension).priority >= entry.priority) {
            return;
        }
        ResourceLocation location = new ResourceLocation(entry.item);
        if (DimConfig.resourceInvalid(location)) {
            return;
        }
        dimEntries.put(entry.dimension, new DimEntry((Item)ForgeRegistries.ITEMS.getValue(location), entry.color, entry.priority));
    }

    private static void addMissingEntry(DimEntryConfig entry) {
        if (!ModList.get().isLoaded(entry.dimension.substring(0, entry.dimension.indexOf(58)))) {
            return;
        }
        if (dimEntries.containsKey(entry.dimension)) {
            return;
        }
        ResourceLocation location = new ResourceLocation(entry.item);
        if (DimConfig.resourceInvalid(location)) {
            Parties.LOGGER.warn(" DimEntry {} had an invalid item location. Changing to minecraft:bedrock.", (Object)entry.dimension);
            location = new ResourceLocation("minecraft:bedrock");
        }
        missingEntries.put(entry.dimension, new DimEntry((Item)ForgeRegistries.ITEMS.getValue(location), entry.color, entry.priority));
    }

    private static boolean resourceInvalid(ResourceLocation loc) {
        if (!ForgeRegistries.ITEMS.containsKey(loc)) {
            Parties.LOGGER.warn(" Failed to load dimension item: '" + loc + "'. This may be alright!");
            return true;
        }
        return false;
    }

    public static class DimEntry {
        ItemStack item;
        int color;
        int priority;

        public DimEntry(Item loc, int color, int priority) {
            this.color = color;
            this.item = new ItemStack((ItemLike)loc);
            this.priority = priority;
        }
    }

    public static class DimEntryConfig {
        String dimension;
        String item;
        int color;
        int priority;

        public DimEntryConfig(String dimension, String item, int color, int priority) {
            this.dimension = dimension;
            this.item = item;
            this.color = color;
            this.priority = priority;
        }
    }
}

