/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.config;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ConfigEntry {
    ArrayList<EntryObject> entries = new ArrayList();
    int totalBits;

    public void addEntry(String name, Object value, int bits) {
        this.entries.add(new EntryObject(name, value, bits));
        this.totalBits += bits;
    }

    public void addEntry(EntryObject obj, Object value) {
        this.entries.add(new EntryObject(obj.name, value, obj.bitSize));
        this.totalBits += obj.bitSize;
    }

    public ArrayList<EntryObject> getEntries() {
        return this.entries;
    }

    public JsonObject getJsonEntries(Gson gson) {
        JsonObject json = new JsonObject();
        this.entries.forEach(e -> json.add(e.name, gson.toJsonTree(e.value)));
        return json;
    }

    public String getBits() {
        StringBuilder bits = new StringBuilder();
        this.entries.forEach(e -> bits.append(e.getBits()));
        return bits.toString();
    }

    public void readBits(char[] bits, BiConsumer<String, Object> action) {
        int index = 0;
        for (EntryObject entry : this.entries) {
            entry.updateValue(bits, index);
            action.accept(entry.name, entry.value);
            index += entry.bitSize;
        }
    }

    public void forEachEntry(BiConsumer<EntryObject, Object> action) {
        this.entries.forEach(entryObject -> action.accept((EntryObject)entryObject, entryObject.value));
    }

    public void forEachKey(Consumer<String> action) {
        this.entries.forEach(entryObject -> action.accept(entryObject.name));
    }

    public static class EntryObject {
        String name;
        Object value;
        int bitSize;

        EntryObject(String name, Object value, int bitSize) {
            this.name = name;
            this.value = value;
            this.bitSize = bitSize;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        String getBits() {
            String bits = "";
            Object object = this.value;
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                bits = String.format("%" + this.bitSize + "s", Integer.toBinaryString(i)).replace(' ', '0');
            } else {
                object = this.value;
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    bits = b != false ? "1" : "0";
                }
            }
            return bits;
        }

        void updateValue(char[] bits, int index) {
            if (this.value instanceof Boolean) {
                this.value = bits[index] == '1';
            } else if (this.value instanceof Integer) {
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < this.bitSize; ++i) {
                    s.append(bits[index + i]);
                }
                this.value = Integer.parseInt(s.toString(), 2);
            }
        }
    }
}

