/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.client.config.DimConfig;
import io.sedu.mc.parties.client.overlay.Frame;
import io.sedu.mc.parties.client.overlay.GeneralOptions;
import io.sedu.mc.parties.client.overlay.PArmor;
import io.sedu.mc.parties.client.overlay.PHead;
import io.sedu.mc.parties.client.overlay.PresetEntry;
import io.sedu.mc.parties.client.overlay.RenderItem;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.codec.binary.Base64;

public class Config {
    public static final Path DEFAULT_PRESET_PATH = FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("presets").resolve("default");
    public static final Path PRESET_PATH = FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("presets");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static boolean whitelist;
    public static HashSet<String> stages;

    public static void init() {
        try {
            Files.createDirectories(DEFAULT_PRESET_PATH, new FileAttribute[0]);
            Files.createDirectories(PRESET_PATH, new FileAttribute[0]);
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("dims"), new FileAttribute[0]);
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to create config paths!", (Throwable)e);
        }
    }

    public static void loadStageLists() {
        try (FileReader reader = new FileReader(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("stages").resolve("stages-sync.json").toFile());){
            Gson gson = new Gson();
            JsonObject stagesJson = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            String stagesEntries = stagesJson.getAsJsonPrimitive("entries").getAsString();
            stages = new HashSet();
            if (stagesEntries.isEmpty()) {
                Parties.debug("No entries present in the stage sync list. Ignoring...", new Object[0]);
                whitelist = false;
            } else {
                stages.addAll(List.of(stagesEntries.replaceAll("\\s+", "").toLowerCase().split(",")));
                whitelist = stagesJson.getAsJsonPrimitive("whitelist").getAsBoolean();
                Parties.LOGGER.debug(" Found {} entries in the stage sync list. The list is currently in {} mode.", (Object)stages.size(), (Object)(whitelist ? "whitelist" : "blacklist"));
            }
        }
        catch (IOException e) {
            Parties.LOGGER.warn(" Failed to load the stage sync list.");
            Parties.LOGGER.debug(" Generating default stage sync list...");
            Config.createStageLists();
        }
    }

    private static void createStageLists() {
        JsonObject json = new JsonObject();
        json.addProperty("_comment", "If whitelist is true, then only stages who's names exist in 'entries' will be synced. If false, only stages NOT in 'entries' will be synced. Stages in the 'entries' property are comma-separated and spaces are ignored.");
        json.addProperty("whitelist", Boolean.valueOf(false));
        json.addProperty("entries", "");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("stages"), new FileAttribute[0]);
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to create the stage sync list.", (Throwable)e);
        }
        try (FileWriter writer = new FileWriter(new File(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("stages").toFile(), "stages-sync.json"));){
            writer.write(GSON.toJson((JsonElement)json));
            writer.flush();
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to create the stage sync list.", (Throwable)e);
        }
        stages = new HashSet();
        whitelist = false;
    }

    public static void parseError() {
        Parties.LOGGER.warn(" Failed to load preset.");
    }

    private static boolean applyPresetString(Frame f, char[] bits, HashMap<String, RenderItem.Update> updater) {
        StringBuilder bitBuilder = new StringBuilder();
        boolean newEntry = true;
        boolean hasZeroes = false;
        boolean validPreset = false;
        int eleId = -1;
        int eleVer = 0;
        String elementBits = "";
        ArrayList<RenderItem> itemList = new ArrayList<RenderItem>(f.getAllItems().values());
        for (char bit : bits) {
            if (bit == ':') {
                newEntry = false;
                eleId = Integer.parseInt(bitBuilder.toString());
                bitBuilder.setLength(0);
                continue;
            }
            if (bit == '-') {
                if (newEntry) {
                    eleVer = Integer.parseInt(bitBuilder.toString());
                } else {
                    hasZeroes = true;
                    elementBits = new BigInteger(1, Base64.decodeBase64((String)bitBuilder.toString())).toString(2);
                }
                bitBuilder.setLength(0);
                continue;
            }
            if (bit == '|') {
                elementBits = hasZeroes ? String.format("%" + (elementBits.length() + Integer.parseInt(bitBuilder.toString())) + "s", elementBits).replace(' ', '0') : new BigInteger(1, Base64.decodeBase64((String)bitBuilder.toString())).toString(2);
                if (eleId == 0) {
                    GeneralOptions.INSTANCE.getDefaults().readBits(elementBits.toCharArray(), (name, value) -> ((RenderItem.Update)updater.get(name)).onUpdate(GeneralOptions.INSTANCE, value));
                } else if (eleVer == 0) {
                    String finalElementBits = elementBits;
                    RenderItem.getItemById(f, eleId, item -> {
                        itemList.remove(item);
                        item.getDefaults().readBits(finalElementBits.toCharArray(), (name, value) -> ((RenderItem.Update)updater.get(name)).onUpdate((RenderItem)item, value));
                    });
                } else {
                    Parties.LOGGER.error(" Attempted to load an element from a future version. Reverting to default.");
                    RenderItem.getItemById(f, eleId, item -> {
                        itemList.remove(item);
                        RenderItem.setElementDefaults(item, updater);
                    });
                }
                bitBuilder.setLength(0);
                eleId = -1;
                eleVer = 0;
                hasZeroes = false;
                newEntry = true;
                validPreset = true;
                continue;
            }
            bitBuilder.append(bit);
        }
        if (validPreset) {
            itemList.forEach(item -> {
                RenderItem.setElementDefaults(item, updater);
                item.setEnabled(false);
            });
            RenderItem.isDirty = true;
        }
        return validPreset;
    }

    public static String getPresetString(Frame f, HashMap<String, RenderItem.Getter> getter) {
        StringBuilder bits = new StringBuilder();
        String bitForm = GeneralOptions.INSTANCE.getCurrentValues(getter).getBits();
        BigInteger intForm = Config.bitsToInt(bitForm);
        bits.append("0:").append(Config.intTo64(intForm)).append("-").append(bitForm.length() - intForm.toString(2).length()).append("|");
        RenderItem.forEachToSave(f.getAllItems().values(), item -> {
            String bitF = item.getCurrentValues(getter).getBits();
            BigInteger intF = Config.bitsToInt(bitF);
            bits.append(item.getId()).append(":").append(Config.intTo64(intF));
            int length = bitF.length() - intF.toString(2).length();
            if (length != 0) {
                bits.append("-").append(length);
            }
            bits.append("|");
        });
        return bits.toString();
    }

    public static BigInteger bitsToInt(String bits) {
        return new BigInteger(bits, 2);
    }

    public static String intTo64(BigInteger integer) {
        return Base64.encodeBase64String((byte[])integer.toByteArray());
    }

    public static void saveDefaultDims(List<DimConfig.DimEntryConfig> entries) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (FileWriter writer = new FileWriter(new File(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("dims").toFile(), "default.json"));){
            writer.write(gson.toJson(entries));
            writer.flush();
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to save default dimension entries !", (Throwable)e);
        }
    }

    public static void forEachDimFile(Consumer<List<DimConfig.DimEntryConfig>> action) {
        Gson gson = new Gson();
        Type dimListType = new TypeToken<ArrayList<DimConfig.DimEntryConfig>>(){}.getType();
        Path master = FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("dims");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(master);){
            for (Path path : stream) {
                String pathName;
                if (Files.isDirectory(path, new LinkOption[0]) || !(pathName = path.getFileName().toString()).endsWith(".json") || !(!pathName.equals("default.json") & !pathName.equals("missing.json"))) continue;
                try (FileReader reader = new FileReader(master.resolve(path).toFile());){
                    List l = (List)gson.fromJson((Reader)reader, dimListType);
                    if (l == null) continue;
                    action.accept(l);
                }
            }
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to load dimension entries!", (Throwable)e);
        }
    }

    public static void forEachMissing(Consumer<List<DimConfig.DimEntryConfig>> action) {
        try (FileReader reader = new FileReader(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("dims").resolve("missing.json").toFile());){
            Type dimListType = new TypeToken<ArrayList<DimConfig.DimEntryConfig>>(){}.getType();
            List l = (List)GSON.fromJson((Reader)reader, dimListType);
            if (l != null) {
                action.accept(l);
            }
        }
        catch (IOException e) {
            Parties.debug("missing.json was not found. Generating...", new Object[0]);
        }
    }

    public static void reloadClientConfigs() {
        PHead.updateModelRenderer();
        RenderItem.enableRenderer();
        Config.loadDefaultPreset();
        PArmor.updateRendererForToughness();
    }

    public static void loadDefaultPreset() {
        HashMap<String, RenderItem.Update> updater = new HashMap<String, RenderItem.Update>();
        RenderItem.initUpdater(updater);
        try (FileReader reader = new FileReader(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("active-preset.json").toFile());){
            Type presetType = new TypeToken<ArrayList<PresetEntry>>(){}.getType();
            if (PresetEntry.loadPreset((List)GSON.fromJson((Reader)reader, presetType))) {
                Frame.forEachEntry((frame, entry) -> {
                    char[] bits = entry.getPresetString();
                    if (!Config.applyPresetString(frame, bits, updater)) {
                        Config.parseError();
                    } else {
                        frame.setOffsets();
                    }
                });
            }
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Failed to load preset.");
            Parties.LOGGER.debug("Generating default preset...");
            Config.generateDefaultPreset(updater);
            Config.savePersistentPreset();
        }
    }

    public static void generateDefaultPreset() {
        Parties.LOGGER.debug("Forcefully generating default preset...");
        HashMap<String, RenderItem.Update> updater = new HashMap<String, RenderItem.Update>();
        RenderItem.initUpdater(updater);
        Frame.forEachEntry((frame, entry) -> Config.generateDefaultPreset(frame, updater));
        Config.savePersistentPreset();
    }

    public static void savePersistentPreset() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (FileWriter writer = new FileWriter(new File(FMLPaths.CONFIGDIR.get().resolve("sedparties").toFile(), "active-preset.json"));){
            writer.write(gson.toJson(Frame.getEntries()));
            writer.flush();
            Parties.debug("Preset saved to active-preset.json", new Object[0]);
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to save persistent preset!", (Throwable)e);
        }
    }

    private static void generateDefaultPreset(HashMap<String, RenderItem.Update> updater) {
        Frame.forEach(f -> Config.generateDefaultPreset(f, updater));
    }

    private static void generateDefaultPreset(Frame f, HashMap<String, RenderItem.Update> updater) {
        RenderItem.getGeneralDefaults().forEachEntry((s, v) -> ((RenderItem.Update)updater.get(s.getName())).onUpdate(null, v));
        f.getAllItems().values().forEach(item -> RenderItem.setElementDefaults(item, updater));
        HashMap<String, RenderItem.Getter> getter = new HashMap<String, RenderItem.Getter>();
        RenderItem.initGetter(getter);
        Config.cachePreset(f, getter);
    }

    public static void cachePreset(Frame f, HashMap<String, RenderItem.Getter> getter) {
        f.updatePresetString(Config.getPresetString(f, getter));
        Parties.debug("Updated default preset for frame '{}' in this instance.", f);
    }

    public static void saveMissingDims() {
        ArrayList dims = new ArrayList();
        DimConfig.missingEntries.forEach((loc, dimEntry) -> {
            dimEntry.item.m_41720_();
            dims.add(new DimConfig.DimEntryConfig((String)loc, BuiltInRegistries.f_257033_.m_7981_((Object)dimEntry.item.m_41720_()).toString(), dimEntry.color, dimEntry.priority));
        });
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (FileWriter writer = new FileWriter(new File(FMLPaths.CONFIGDIR.get().resolve("sedparties").resolve("dims").toFile(), "missing.json"));){
            writer.write(gson.toJson(dims));
            writer.flush();
        }
        catch (IOException e) {
            Parties.LOGGER.error(" Error trying to save missing dimension entries !", (Throwable)e);
        }
    }
}

