/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.ironspellbooks;

import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.data.DataType;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.events.ClientEvent;
import io.sedu.mc.parties.network.InfoPacketHelper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ISSEventHandler {
    @SubscribeEvent
    public static void onPartyOnline(PartyEvent.Online event) {
        event.forTrackersAndSelf((sendTo, propOf) -> PlayerAPI.getServerPlayer(propOf, p -> {
            int max = (int)p.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get());
            InfoPacketHelper.sendManaUpdateI(sendTo, propOf, max);
            InfoPacketHelper.sendMaxManaUpdateI(sendTo, propOf, max);
        }));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void manaUpdate(ChangeManaEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player p = event.getEntity();
        if (p == null) {
            return;
        }
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
        if (trackers != null) {
            UUID player = p.m_20148_();
            ServerPlayerData pd = ServerPlayerData.playerList.get(player);
            pd.setData((int)event.getNewMana(), DataType.MANAI, mana -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendManaUpdateI(id, player, mana)));
            pd.setData((int)p.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get()), DataType.MANAMAXI, max -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendMaxManaUpdateI(id, player, max)));
        }
    }

    @SubscribeEvent
    public static void ticker(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            if (ClientEvent.tick % 10 == 0 && !ClientPlayerData.playerList.isEmpty()) {
                ClientPlayerData.getSelf(ClientPlayerData::updateManaISS);
            }
        }
    }

    public static void onClientSpellCast(String spellId, int castDuration) {
        ClientPlayerData.getSelf(clientPlayerData -> clientPlayerData.initSpell(spellId, castDuration));
    }

    public static void onClientSpellFinish(UUID playerUUID) {
        PlayerAPI.getClientPlayer(playerUUID, ClientPlayerData::finishSpell);
    }

    public static void onServerSpellCast(@NotNull UUID serverPlayer, String spellId, int castDuration) {
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(serverPlayer);
        if (trackers != null) {
            trackers.forEach((sendTo, serverTracked) -> {
                if (!serverTracked.booleanValue() || ((Boolean)CommonConfigData.allowGlobalUpdates.get()).booleanValue()) {
                    InfoPacketHelper.sendCastUpdate(sendTo, serverPlayer, spellId, castDuration);
                }
            });
        }
    }

    public static void onServerCastFinished(@NotNull UUID serverPlayer) {
        HashMap<UUID, Boolean> trackers;
        if (((Boolean)CommonConfigData.allowGlobalUpdates.get()).booleanValue() && (trackers = ServerPlayerData.playerTrackers.get(serverPlayer)) != null) {
            trackers.forEach((sendTo, serverTracked) -> {
                if (serverTracked.booleanValue()) {
                    InfoPacketHelper.sendCastUpdate(sendTo, serverPlayer);
                }
            });
        }
    }
}

