/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.homeostatic;

import homeostatic.common.capabilities.Water;
import homeostatic.common.temperature.Environment;
import homeostatic.common.temperature.TemperatureThreshold;
import homeostatic.config.ConfigHandler;
import homeostatic.platform.Services;
import homeostatic.util.TempHelper;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.mod.homeostatic.IHHandler;
import io.sedu.mc.parties.util.TriConsumer;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;

public class HHandler
implements IHHandler {
    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public int getWaterLevel(Player player) {
        Water water = Services.PLATFORM.getWaterCapabilty(player).orElse(null);
        if (water != null) {
            return water.getWaterLevel();
        }
        return 20;
    }

    @Override
    public void getClientTemperature(Player clientPlayer, TriConsumer<Integer, Integer, Integer> action) {
        Services.PLATFORM.getTemperatureData(clientPlayer).ifPresent(temp -> action.accept(this.convertTemp(temp.getLocalTemperature()), this.convertTemp(temp.getSkinTemperature()), this.getSeverity(temp.getSkinTemperature(), temp.getLocalTemperature())));
    }

    @Override
    public int getBodyTempSev(float data, int severity) {
        int tempTex = severity >> 16 & 0xFFFF;
        int sev = 0;
        if (data < TemperatureThreshold.LOW.temperature) {
            sev = 1;
        }
        if (data > TemperatureThreshold.HIGH.temperature) {
            sev = 1;
        }
        return sev | tempTex << 16;
    }

    @Override
    public int getWorldTempSev(float data, int severity) {
        int severe = severity & 0xF;
        int temp = data < Environment.EXTREME_COLD ? 0 : (data < Environment.PARITY_LOW ? 1 : (data < Environment.PARITY_HIGH ? 2 : (data < Environment.HOT ? 3 : 4)));
        return severe | temp << 16;
    }

    @Override
    public int convertTemp(float data) {
        return (int)Math.round(TempHelper.convertMcTemp((float)data, (boolean)ConfigHandler.Client.useFahrenheit()));
    }

    @Override
    public void getTemperature(Player player, BiConsumer<Float, Float> action) {
        Services.PLATFORM.getTemperatureData(player).ifPresent(temp -> action.accept(Float.valueOf(temp.getLocalTemperature()), Float.valueOf(temp.getSkinTemperature())));
    }

    private int getSeverity(float coreTemp, float localTemp) {
        int sev = 0;
        if (coreTemp < TemperatureThreshold.LOW.temperature) {
            sev = 1;
        }
        if (coreTemp > TemperatureThreshold.HIGH.temperature) {
            sev = 1;
        }
        int temp = localTemp < Environment.EXTREME_COLD ? 0 : (localTemp < Environment.PARITY_LOW ? 1 : (localTemp < Environment.PARITY_HIGH ? 2 : (localTemp < Environment.HOT ? 3 : 4)));
        return sev | temp << 16;
    }

    static {
        Parties.info("Initializing Compatibility with Homeostatic.");
    }
}

