/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.homeostatic;

import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.mod.homeostatic.HCompatManager;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.data.DataType;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.events.ClientEvent;
import io.sedu.mc.parties.network.InfoPacketHelper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class HEventHandler {
    @SubscribeEvent
    public static void ticker(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            if (ClientEvent.tick % 10 == 3) {
                ClientPlayerData.getSelf(ClientPlayerData::updateTemperaturesH);
                ClientPlayerData.getSelf(ClientPlayerData::updateThirstH);
            }
        }
    }

    @SubscribeEvent
    public static void onPartyJoin(PartyEvent.Online event) {
        event.forTrackersAndSelf((sendTo, propOf) -> {
            ServerPlayerData p = ServerPlayerData.playerList.get(propOf);
            InfoPacketHelper.sendWorldTempUpdate(sendTo, propOf, p.getWorldTemp());
            InfoPacketHelper.sendBodyTempUpdate(sendTo, propOf, p.getBodyTemp());
            InfoPacketHelper.sendThirstUpdate(sendTo, propOf, p.getThirst());
        });
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent e) {
        HashMap<UUID, Boolean> trackers;
        if (e.side == LogicalSide.SERVER && e.phase == TickEvent.Phase.END && e.player.f_19797_ % (Integer)CommonConfigData.playerSlowUpdateInterval.get() == 9 && (trackers = ServerPlayerData.playerTrackers.get(e.player.m_20148_())) != null) {
            HCompatManager.getHandler().getTemperature(e.player, (localTemp, skinTemp) -> {
                UUID player = e.player.m_20148_();
                ServerPlayerData d = ServerPlayerData.playerList.get(player);
                d.setData(skinTemp, DataType.BODYTEMP, temp -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendBodyTempUpdate(id, player, temp.floatValue())));
                d.setData(localTemp, DataType.WORLDTEMP, temp -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendWorldTempUpdate(id, player, temp.floatValue())));
            });
            ServerPlayerData.playerList.get(e.player.m_20148_()).setData(HCompatManager.getHandler().getWaterLevel(e.player), DataType.THIRST, thirst -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendThirstUpdate(id, e.player.m_20148_(), thirst)));
        }
    }
}

