/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.ftbteams;

import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.PartyData;
import io.sedu.mc.parties.data.PartyHelper;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import java.util.UUID;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FTEventHandler {
    public static void init() {
        TeamEvent.PLAYER_JOINED_PARTY.register(event -> {
            if (!((Boolean)CommonConfigData.useFTBTeams.get()).booleanValue()) {
                return;
            }
            if (event.getTeam().getMembers().size() > 1 && PartyHelper.invitePlayerForced(event.getTeam().getOwner(), event.getPlayer().m_20148_(), true)) {
                Parties.LOGGER.warn("An error occured trying to add a player to the party.");
            }
        });
        TeamEvent.PLAYER_LEFT_PARTY.register(event -> {
            if (!((Boolean)CommonConfigData.useFTBTeams.get()).booleanValue()) {
                return;
            }
            ServerPlayerData p = PlayerAPI.getNormalPlayer(event.getPlayerId());
            if (p != null && p.hasParty()) {
                PartyHelper.removePlayerFromParty(event.getPlayerId(), false);
            } else {
                Parties.LOGGER.warn("Attempted to remove members from a non-existent party.");
            }
        });
        TeamEvent.OWNERSHIP_TRANSFERRED.register(event -> {
            if (!((Boolean)CommonConfigData.useFTBTeams.get()).booleanValue()) {
                return;
            }
            ServerPlayerData p = PlayerAPI.getNormalPlayer(event.getTeam().getOwner());
            if (p != null && p.hasParty()) {
                PartyHelper.giveLeader(event.getTeam().getOwner());
            } else {
                Parties.LOGGER.warn("An error occured trying to transfer party ownership.");
            }
        });
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!((Boolean)CommonConfigData.useFTBTeams.get()).booleanValue()) {
            return;
        }
        TeamManagerImpl.INSTANCE.getTeams().forEach(team -> {
            if (team.getMembers().size() > 1) {
                UUID partyId = team.getId();
                PartyData pData = new PartyData(partyId, team.getOwner(), false);
                team.getMembers().forEach(member -> {
                    new ServerPlayerData((UUID)member, partyId, TeamManagerImpl.INSTANCE.getPlayerName(member).getString());
                    pData.addMemberSilently((UUID)member);
                });
                PartyData.partyList.put(partyId, pData);
            }
        });
    }
}

