/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.feathers;

import com.elenai.feathers.api.FeathersHelper;
import com.elenai.feathers.capability.PlayerFeathers;
import com.elenai.feathers.capability.PlayerFeathersProvider;
import com.elenai.feathers.client.ClientFeathersData;
import com.elenai.feathers.config.FeathersCommonConfig;
import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.mod.feathers.FCompatManager;
import io.sedu.mc.parties.api.mod.feathers.IFHandler;
import io.sedu.mc.parties.util.TriConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.Capability;

public class FHandler
implements IFHandler {
    private static final Capability<PlayerFeathers> FEATHERS = PlayerFeathersProvider.PLAYER_FEATHERS;

    public static boolean exists() {
        return FEATHERS != null;
    }

    @Override
    public void getClientFeathers(TriConsumer<Integer, Integer, Integer> action) {
        if (((Boolean)FeathersCommonConfig.ENABLE_ARMOR_WEIGHTS.get()).booleanValue()) {
            int weight = ClientFeathersData.getWeight();
            action.accept(Math.max(0, ClientFeathersData.getFeathers() - weight), Math.max(0, 20 - weight), ClientFeathersData.getEnduranceFeathers());
        } else {
            action.accept(ClientFeathersData.getFeathers(), 20, ClientFeathersData.getEnduranceFeathers());
        }
    }

    @Override
    public void getServerFeathers(ServerPlayer player, TriConsumer<Integer, Integer, Integer> action) {
        int weight = FeathersHelper.getPlayerWeight((ServerPlayer)player);
        action.accept(Math.max(0, FeathersHelper.getFeathers((ServerPlayer)player) - weight), Math.max(0, 20 - weight), FeathersHelper.getEndurance((ServerPlayer)player));
    }

    @Override
    public void setFeathersRender(Boolean aBoolean) {
        FCompatManager.enableOverlay = aBoolean;
    }

    static {
        Parties.LOGGER.debug("[Parties] Initializing Compatibility with Feathers Mod.");
        if (FEATHERS == null) {
            Parties.LOGGER.error("[Parties] Failed to load Feathers compatibility...");
        }
    }
}

