/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.feathers;

import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.api.mod.feathers.FCompatManager;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.data.DataType;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.events.ClientEvent;
import io.sedu.mc.parties.network.InfoPacketHelper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class FEventHandler {
    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent e) {
        if (e.side == LogicalSide.SERVER && e.phase == TickEvent.Phase.END && e.player.f_19797_ % (Integer)CommonConfigData.playerUpdateInterval.get() == 2) {
            FCompatManager.getHandler().getServerFeathers((ServerPlayer)e.player, (cur, max, abs) -> {
                HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(e.player.m_20148_());
                if (trackers != null) {
                    UUID player = e.player.m_20148_();
                    ServerPlayerData pd = ServerPlayerData.playerList.get(player);
                    pd.setData(Math.min(cur, max), DataType.STAM, c -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendStaminaUpdate(id, player, c.intValue())));
                    pd.setData(max, DataType.MAXSTAM, m -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendMaxStaminaUpdate(id, player, m)));
                    pd.setData(abs, DataType.EXTRASTAM, a -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendExtraStamUpdate(id, player, a)));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPartyJoin(PartyEvent.Online event) {
        event.forTrackersAndSelf((sendTo, propOf) -> PlayerAPI.getPlayer(propOf, p -> {
            ServerPlayerData pD = ServerPlayerData.playerList.get(propOf);
            InfoPacketHelper.sendStaminaUpdate(sendTo, propOf, pD.getStamina());
            InfoPacketHelper.sendMaxStaminaUpdate(sendTo, propOf, pD.getMaxStamina());
            InfoPacketHelper.sendExtraStamUpdate(sendTo, propOf, pD.getExtraStamina());
        }));
    }

    @SubscribeEvent
    public static void ticker(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientEvent.tick % 10 == 2) {
            ClientPlayerData.getSelf(ClientPlayerData::checkStamF);
        }
    }
}

