/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.mod.arsnoveau;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import io.sedu.mc.parties.api.events.PartyEvent;
import io.sedu.mc.parties.api.mod.arsnoveau.ANCompatManager;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.data.DataType;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.data.config.CommonConfigData;
import io.sedu.mc.parties.events.ClientEvent;
import io.sedu.mc.parties.network.InfoPacketHelper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ANEventHandler {
    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent e) {
        HashMap<UUID, Boolean> trackers;
        if (e.side == LogicalSide.SERVER && e.phase == TickEvent.Phase.END && e.player.f_19797_ % (Integer)CommonConfigData.playerSlowUpdateInterval.get() == 0 && (trackers = ServerPlayerData.playerTrackers.get(e.player.m_20148_())) != null) {
            UUID player = e.player.m_20148_();
            ServerPlayerData pD = ServerPlayerData.playerList.get(player);
            pD.setData(Float.valueOf(ANCompatManager.getHandler().getCurrentMana(e.player)), DataType.MANA, mana -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendManaUpdate(id, player, mana.floatValue())));
            pD.setData(ANCompatManager.getHandler().getMaxMana(e.player), DataType.MAXMANA, max -> trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendMaxManaUpdate(id, player, max)));
        }
    }

    @SubscribeEvent
    public static void onPartyJoin(PartyEvent.Online event) {
        event.forTrackersAndSelf((sendTo, propOf) -> {
            ServerPlayerData p = ServerPlayerData.playerList.get(propOf);
            InfoPacketHelper.sendManaUpdate(sendTo, propOf, p.getCurrentMana());
            InfoPacketHelper.sendMaxManaUpdate(sendTo, propOf, p.getMaxMana());
        });
    }

    @SubscribeEvent
    public static void castEvent(SpellCastEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(p.m_20148_());
            UUID player = p.m_20148_();
            ServerPlayerData.playerList.get(player).setData(Float.valueOf(Math.max(0.0f, ANCompatManager.getHandler().getCurrentMana(p) - (float)event.spell.getCost())), DataType.MANA, mana -> {
                InfoPacketHelper.sendManaUpdate(player, player, mana.floatValue());
                if (trackers != null) {
                    trackers.forEach((id, serverTracked) -> InfoPacketHelper.sendManaUpdate(id, player, mana.floatValue()));
                }
            });
        }
        if (event.getWorld().f_46443_ && !ClientPlayerData.playerList.isEmpty()) {
            ClientPlayerData.getSelf(ClientPlayerData::updateMana);
        }
    }

    @SubscribeEvent
    public static void ticker(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (Minecraft.m_91087_().m_91104_()) {
                return;
            }
            if (ClientEvent.tick % 20 == 2 && !ClientPlayerData.playerList.isEmpty()) {
                ClientPlayerData.getSelf(ClientPlayerData::updateMana);
            }
        }
    }
}

