/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.helper;

import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.data.ServerPlayerData;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class PlayerAPI {
    public static void getServerPlayer(UUID id, Consumer<ServerPlayer> action) {
        PlayerAPI.getPlayer(id, playerData -> {
            if (playerData.getPlayer() != null) {
                action.accept(playerData.getPlayer());
            }
        });
    }

    @Nullable
    public static ServerPlayer getNormalServerPlayer(UUID id) {
        ServerPlayerData p = PlayerAPI.getNormalPlayer(id);
        return p != null ? p.getPlayer() : null;
    }

    public static void getPlayer(UUID id, Consumer<ServerPlayerData> action) {
        ServerPlayerData.playerList.computeIfPresent(id, (uuid, playerData) -> {
            action.accept((ServerPlayerData)playerData);
            return playerData;
        });
    }

    @Nullable
    public static ServerPlayerData getNormalPlayer(UUID id) {
        return ServerPlayerData.playerList.get(id);
    }

    @Nullable
    public static ServerPlayerData getPlayerFromId(int id) {
        for (ServerPlayerData serverPlayerData : ServerPlayerData.playerList.values()) {
            if (serverPlayerData.getPlayer() == null || serverPlayerData.getPlayer().m_19879_() != id) continue;
            return serverPlayerData;
        }
        return null;
    }

    public static String getName(UUID id) {
        ServerPlayerData p = PlayerAPI.getNormalPlayer(id);
        return p != null ? p.getName() : "";
    }

    public static boolean isOnline(UUID id) {
        return PlayerAPI.getNormalServerPlayer(id) != null;
    }

    public static void getClientPlayer(UUID playerId, Consumer<ClientPlayerData> action) {
        ClientPlayerData p = ClientPlayerData.playerList.get(playerId);
        if (p != null) {
            action.accept(p);
        }
    }

    public static Integer getToughnessValue(Player player) {
        return Mth.m_14107_((double)player.m_21133_(Attributes.f_22285_));
    }
}

