/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.helper;

import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.client.overlay.ClientPlayerData;
import io.sedu.mc.parties.data.PartyData;
import io.sedu.mc.parties.data.ServerPlayerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;

public class PartyAPI {
    @Nullable
    public static PartyData getPartyFromMember(UUID playerId) {
        PartyData p;
        UUID party;
        ServerPlayerData pl = ServerPlayerData.playerList.get(playerId);
        if (pl != null && (party = pl.getPartyId()) != null && (p = PartyAPI.getPartyFromId(party)) != null) {
            return p;
        }
        return null;
    }

    public static PartyData getPartyFromMember(LivingEntity entity) {
        OwnableEntity ownedEntity;
        LivingEntity livingEntity;
        if (entity instanceof Player) {
            Player p = (Player)entity;
            return PartyAPI.getPartyFromMember(p.m_20148_());
        }
        if (entity instanceof OwnableEntity && (livingEntity = (ownedEntity = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            Player p = (Player)livingEntity;
            return PartyAPI.getPartyFromMember(p.m_20148_());
        }
        return null;
    }

    public static List<Player> getOnlineMembersWithoutSelf(UUID memberId) {
        ArrayList<Player> players = new ArrayList<Player>();
        PartyData p = PartyAPI.getPartyFromMember(memberId);
        if (p != null) {
            for (UUID member : p.getMembers()) {
                if (member.equals(memberId)) continue;
                PlayerAPI.getServerPlayer(member, players::add);
            }
        }
        return players;
    }

    public static ArrayList<Player> getNearMembersWithoutSelf(UUID memberId) {
        ArrayList<Player> players = new ArrayList<Player>();
        PartyData p = PartyAPI.getPartyFromMember(memberId);
        if (p != null) {
            for (UUID member : p.getMembers()) {
                if (member.equals(memberId) || !PartyAPI.isClientTracked(memberId, member)) continue;
                PlayerAPI.getServerPlayer(member, players::add);
            }
        }
        return players;
    }

    public static boolean inSameParty(UUID member1, UUID member2) {
        PartyData p2;
        PartyData p1 = PartyAPI.getPartyFromMember(member1);
        if (p1 == null || (p2 = PartyAPI.getPartyFromMember(member2)) == null) {
            return false;
        }
        return p1.equals(p2);
    }

    public static boolean inSameParty(LivingEntity member1, LivingEntity member2) {
        PartyData p2;
        OwnableEntity own1;
        Object p1;
        if (member1 instanceof Player) {
            p1 = (Player)member1;
            if (member2 instanceof OwnableEntity) {
                own1 = (OwnableEntity)member2;
                if (p1.m_20148_().equals(own1.m_21805_())) {
                    return true;
                }
            }
        }
        if (member2 instanceof Player) {
            p1 = (Player)member2;
            if (member1 instanceof OwnableEntity) {
                own1 = (OwnableEntity)member1;
                if (p1.m_20148_().equals(own1.m_21805_())) {
                    return true;
                }
            }
        }
        if ((p1 = PartyAPI.getPartyFromMember(member1)) == null || (p2 = PartyAPI.getPartyFromMember(member2)) == null) {
            return false;
        }
        return ((PartyData)p1).equals(p2);
    }

    public static PartyData getPartyFromId(UUID partyId) {
        return PartyData.partyList.get(partyId);
    }

    public static boolean isLeader(UUID playerId) {
        PartyData p = PartyAPI.getPartyFromMember(playerId);
        if (p != null) {
            return p.isLeader(playerId);
        }
        return false;
    }

    public static boolean hasParty(UUID playerId) {
        return PartyAPI.getPartyFromMember(playerId) != null;
    }

    private static boolean isClientTracked(UUID tracker, UUID toTrack) {
        Boolean serverTracked;
        HashMap<UUID, Boolean> trackers = ServerPlayerData.playerTrackers.get(toTrack);
        if (trackers != null && (serverTracked = trackers.get(tracker)) != null) {
            return serverTracked == false;
        }
        return false;
    }

    public static int getPartyCount() {
        return PartyData.partyList.size();
    }

    public static boolean inSamePartyClient(UUID member) {
        return ClientPlayerData.playerList.containsKey(member);
    }
}

