/*
 * Decompiled with CFR 0.152.
 */
package io.sedu.mc.parties.api.events;

import io.sedu.mc.parties.Parties;
import io.sedu.mc.parties.api.helper.PlayerAPI;
import io.sedu.mc.parties.data.ServerPlayerData;
import io.sedu.mc.parties.util.TriConsumer;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public abstract class PartyEvent
extends Event {
    protected final UUID playerId;
    protected final UUID partyId;

    protected PartyEvent(UUID partyId, UUID playerId) {
        this.playerId = playerId;
        this.partyId = partyId;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public UUID getPartyId() {
        return this.partyId;
    }

    public static class Online
    extends PartyEvent {
        private final HashMap<UUID, Boolean> trackers;

        public Online(UUID partyId, UUID onlinePlayerId) {
            super(partyId, onlinePlayerId);
            Parties.debug("New join event for {}", PlayerAPI.getName(this.playerId));
            this.trackers = ServerPlayerData.playerTrackers.get(this.playerId);
        }

        public void forTrackersAndSelf(TriConsumer<UUID, UUID, Player> action) {
            if (this.trackers != null) {
                this.trackers.forEach((id, serverTracked) -> {
                    PlayerAPI.getServerPlayer(id, serverPlayer -> action.accept(this.playerId, (UUID)id, (Player)serverPlayer));
                    PlayerAPI.getServerPlayer(this.playerId, serverPlayer -> action.accept((UUID)id, this.playerId, (Player)serverPlayer));
                });
            }
        }

        public void forTrackersAndSelf(BiConsumer<UUID, UUID> action) {
            if (this.trackers != null) {
                this.trackers.forEach((id, serverTracked) -> {
                    action.accept(this.playerId, (UUID)id);
                    action.accept((UUID)id, this.playerId);
                });
            }
        }
    }

    public static class Join
    extends PartyEvent {
        public Join(UUID partyId, UUID playerId) {
            super(partyId, playerId);
        }
    }

    public static class Leave
    extends PartyEvent {
        public Leave(UUID partyId, UUID playerId) {
            super(partyId, playerId);
            Parties.debug("Player {} is being removed from party {}.", playerId, partyId);
        }
    }

    public static class Disband
    extends PartyEvent {
        public Disband(UUID party, UUID player) {
            super(party, player);
        }
    }

    public static class Create
    extends PartyEvent {
        public Create(UUID party, UUID player) {
            super(party, player);
        }
    }
}

