/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.other;

import com.teamabnormals.autumnity.common.entity.projectile.ThrownTurkeyEgg;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.blueprint.core.util.DataUtil;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;

public class AutumnityCompat {
    public static void registerCompat() {
        AutumnityCompat.registerAnimalFoods();
        AutumnityCompat.registerCompostables();
        AutumnityCompat.registerFlammables();
        AutumnityCompat.registerDispenserBehaviors();
    }

    private static void registerAnimalFoods() {
        DataUtil.addParrotFood((Item[])new Item[]{(Item)AutumnityItems.FOUL_BERRY_PIPS.get()});
    }

    private static void registerCompostables() {
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityItems.FOUL_BERRIES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityItems.FOUL_BERRY_PIPS.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityItems.PUMPKIN_BREAD.get()), (float)0.85f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.AUTUMN_CROCUS.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.PANCAKE.get()), (float)0.85f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.LARGE_PUMPKIN_SLICE.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.CARVED_LARGE_PUMPKIN_SLICE.get()), (float)0.65f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.RED_MAPLE_LEAVES.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.YELLOW_MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.ORANGE_MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.RED_MAPLE_SAPLING.get()), (float)0.3f);
        DataUtil.registerCompostable((ItemLike)((ItemLike)AutumnityBlocks.FOUL_BERRY_BASKET.get()), (float)1.0f);
    }

    private static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.FOUL_BERRY_BUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.AUTUMN_CROCUS.get()), (int)60, (int)100);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.STRIPPED_MAPLE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.STRIPPED_MAPLE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.SAPPY_MAPLE_LOG.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.SAPPY_MAPLE_WOOD.get()), (int)5, (int)5);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_PLANKS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_STAIRS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_SLAB.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_FENCE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_FENCE_GATE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.YELLOW_MAPLE_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.ORANGE_MAPLE_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.RED_MAPLE_LEAF_PILE.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_BEEHIVE.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_BOARDS.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.MAPLE_BOOKSHELF.get()), (int)30, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.FOUL_BERRY_BASKET.get()), (int)5, (int)20);
        DataUtil.registerFlammable((Block)((Block)AutumnityBlocks.TURKEY_EGG_CRATE.get()), (int)5, (int)20);
    }

    private static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AutumnityItems.TURKEY_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
                return (Projectile)Util.m_137469_((Object)((Object)new ThrownTurkeyEgg(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_())), egg -> egg.m_37446_(stackIn));
            }
        });
    }
}

