/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.common.block;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.autumnity.common.block.LargeRedstoneJackOlanternSliceBlock;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public abstract class AbstractLargePumpkinSliceBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public AbstractLargePumpkinSliceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState bottomblock = level.m_8055_(blockpos.m_7495_());
        BlockState topblock = level.m_8055_(blockpos.m_7494_());
        if (bottomblock.m_60734_() instanceof AbstractLargePumpkinSliceBlock && bottomblock.m_61143_(HALF) == Half.BOTTOM) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)bottomblock.m_61143_((Property)FACING)))).m_61124_(HALF, (Comparable)Half.TOP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(blockpos)));
        }
        if (topblock.m_60734_() instanceof AbstractLargePumpkinSliceBlock && topblock.m_61143_(HALF) == Half.TOP) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)topblock.m_61143_((Property)FACING)))).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(blockpos)));
        }
        Half half = Mth.m_14031_((float)(context.m_43723_().m_5686_(1.0f) * ((float)Math.PI / 180))) > 0.0f ? Half.BOTTOM : Half.TOP;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)AbstractLargePumpkinSliceBlock.getFacing(context))).m_61124_(HALF, (Comparable)half)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(blockpos)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        List<BlockPos> slices = AbstractLargePumpkinSliceBlock.getOtherSlices(level, pos, state);
        slices.add(pos);
        boolean pumpkinpowered = slices.stream().anyMatch(blockpos -> (Boolean)level.m_8055_(blockpos).m_61143_((Property)POWERED));
        for (BlockPos blockpos2 : slices) {
            BlockState blockstate = level.m_8055_(blockpos2);
            if (!(blockstate.m_60734_() instanceof LargeRedstoneJackOlanternSliceBlock) || (Boolean)blockstate.m_61143_((Property)LargeRedstoneJackOlanternSliceBlock.LIT) == pumpkinpowered) continue;
            level.m_7731_(blockpos2, (BlockState)blockstate.m_61124_((Property)LargeRedstoneJackOlanternSliceBlock.LIT, (Comparable)Boolean.valueOf(pumpkinpowered)), 2);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (newState.m_60734_() instanceof AbstractLargePumpkinSliceBlock) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Half half = (Half)state.m_61143_(HALF);
        for (int i = 0; i < 3; ++i) {
            Direction offsetfacing;
            Direction offsetdirection;
            Direction direction = i == 0 ? facing.m_122427_() : (i == 1 ? facing.m_122424_() : (offsetdirection = half == Half.BOTTOM ? Direction.UP : Direction.DOWN));
            Direction direction2 = i == 0 ? facing.m_122427_() : (offsetfacing = i == 1 ? facing.m_122428_() : facing);
            Half offsethalf = i < 2 ? half : (half == Half.BOTTOM ? Half.TOP : Half.BOTTOM);
            BlockPos offsetpos = pos.m_121945_(offsetdirection);
            BlockState offsetstate = level.m_8055_(offsetpos);
            if (!(offsetstate.m_60734_() instanceof AbstractLargePumpkinSliceBlock) || offsetstate.m_61143_((Property)FACING) != offsetfacing || offsetstate.m_61143_(HALF) != offsethalf) continue;
            List<BlockPos> slices = AbstractLargePumpkinSliceBlock.getOtherSlices(level, offsetpos, offsetstate);
            slices.add(offsetpos);
            boolean pumpkinpowered = slices.stream().anyMatch(blockpos1 -> (Boolean)level.m_8055_(blockpos1).m_61143_((Property)POWERED));
            for (BlockPos blockpos12 : slices) {
                BlockState blockstate1 = level.m_8055_(blockpos12);
                if (!(blockstate1.m_60734_() instanceof LargeRedstoneJackOlanternSliceBlock) || (Boolean)blockstate1.m_61143_((Property)LargeRedstoneJackOlanternSliceBlock.LIT) == pumpkinpowered) continue;
                level.m_7731_(blockpos12, (BlockState)blockstate1.m_61124_((Property)LargeRedstoneJackOlanternSliceBlock.LIT, (Comparable)Boolean.valueOf(pumpkinpowered)), 2);
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        if (!level.f_46443_ && ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() != level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        if (mirror != Mirror.NONE) {
            if (mirror == Mirror.FRONT_BACK && axis == Direction.Axis.X || mirror == Mirror.LEFT_RIGHT && axis == Direction.Axis.Z) {
                return state.m_60717_(Rotation.COUNTERCLOCKWISE_90);
            }
            return state.m_60717_(Rotation.CLOCKWISE_90);
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF, POWERED});
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    protected static boolean canCarve(Direction hitFace, Direction facing) {
        return hitFace == facing || hitFace == facing.m_122428_();
    }

    protected static Direction getFacing(BlockPlaceContext context) {
        float f = Mth.m_14177_((float)context.m_7074_()) / 45.0f;
        if (f > -2.0f && f <= 0.0f) {
            return Direction.NORTH;
        }
        if (f > 0.0f && f <= 2.0f) {
            return Direction.EAST;
        }
        if (f > 2.0f) {
            return Direction.SOUTH;
        }
        return Direction.WEST;
    }

    protected static boolean isAnotherSlicePowered(Level level, BlockState state, BlockPos pos) {
        return AbstractLargePumpkinSliceBlock.getOtherSlices(level, pos, state).stream().anyMatch(blockpos -> (Boolean)level.m_8055_(blockpos).m_61143_((Property)POWERED));
    }

    protected static List<BlockPos> getOtherSlices(Level level, BlockPos pos, BlockState state) {
        ArrayList<BlockPos> slices = new ArrayList<BlockPos>();
        ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
        LinkedList<Pair> list = new LinkedList<Pair>();
        list.add(Pair.of((Object)pos, (Object)state));
        while (!list.isEmpty()) {
            Pair pair = (Pair)list.remove(0);
            BlockPos blockpos = (BlockPos)pair.getFirst();
            BlockState blockstate = (BlockState)pair.getSecond();
            visited.add(blockpos);
            Direction facing = (Direction)blockstate.m_61143_((Property)FACING);
            Half half = (Half)blockstate.m_61143_(HALF);
            for (int i = 0; i < 3; ++i) {
                Direction offsetfacing;
                Direction offsetdirection;
                Direction direction = i == 0 ? facing.m_122427_() : (i == 1 ? facing.m_122424_() : (offsetdirection = half == Half.BOTTOM ? Direction.UP : Direction.DOWN));
                Direction direction2 = i == 0 ? facing.m_122427_() : (offsetfacing = i == 1 ? facing.m_122428_() : facing);
                Half offsethalf = i < 2 ? half : (half == Half.BOTTOM ? Half.TOP : Half.BOTTOM);
                BlockPos offsetpos = blockpos.m_121945_(offsetdirection);
                BlockState offseststate = level.m_8055_(offsetpos);
                if (visited.contains(offsetpos) || !(offseststate.m_60734_() instanceof AbstractLargePumpkinSliceBlock) || offseststate.m_61143_((Property)FACING) != offsetfacing || offseststate.m_61143_(HALF) != offsethalf) continue;
                slices.add(offsetpos);
                list.add(Pair.of((Object)offsetpos, (Object)offseststate));
            }
        }
        return slices;
    }
}

