/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.mixin;

import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.ars_technica.common.items.threads.PressurePerk;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BacktankUtil.class})
public abstract class BacktankUtilMixin {
    @Inject(method={"getAllWithAir"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void getAllWithAirFromThread(LivingEntity entity, CallbackInfoReturnable<List<ItemStack>> cir) {
        ItemStack armorWithAir = BacktankUtilMixin.getItemForPerk((IPerk)PressurePerk.INSTANCE, entity);
        if (armorWithAir != null) {
            cir.setReturnValue(List.of(armorWithAir));
        }
    }

    @Nullable
    private static ItemStack getItemForPerk(IPerk perk, LivingEntity entity) {
        ItemStack highestHolderItem = null;
        int maxCount = 0;
        for (ItemStack stack : entity.m_6168_()) {
            IPerkHolder holder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (holder == null) continue;
            for (PerkInstance instance : holder.getPerkInstances()) {
                if (instance.getPerk() != perk) continue;
                maxCount = Math.max(maxCount, instance.getSlot().value);
                highestHolderItem = stack;
            }
        }
        return highestHolderItem;
    }
}

