/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.helpers;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ProjectileHelper {
    public static HitResult getHitResult(Entity projectile, Predicate<Entity> entityFilter, Predicate<BlockEntity> blockEntityFilter) {
        Vec3 end;
        Vec3 start;
        BlockHitResult blockHit;
        BlockPos blockPos;
        Level world = projectile.m_9236_();
        BlockState blockState = world.m_8055_(blockPos = (blockHit = world.m_45547_(new ClipContext(start = projectile.m_20299_(1.0f), end = start.m_82549_(projectile.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, projectile))).m_82425_());
        if (blockState.m_60795_()) {
            blockHit = null;
        } else {
            BlockEntity be = world.m_7702_(blockPos);
            if (be != null && !blockEntityFilter.test(be)) {
                blockHit = null;
            }
        }
        if (blockHit != null) {
            return blockHit;
        }
        return ProjectileHelper.getEntityHitResult(world, projectile, start, end, projectile.m_20191_().m_82369_(projectile.m_20184_()).m_82400_(0.5), entityFilter);
    }

    private static EntityHitResult getEntityHitResult(Level world, Entity projectile, Vec3 start, Vec3 end, AABB boundingBox, Predicate<Entity> entityFilter) {
        EntityHitResult closestEntityHit = null;
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : world.m_6249_(projectile, boundingBox, entityFilter)) {
            double distance;
            AABB entityBoundingBox = entity.m_20191_().m_82400_(0.5);
            Optional intersection = entityBoundingBox.m_82371_(start, end);
            if (!intersection.isPresent() || !((distance = start.m_82554_((Vec3)intersection.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntityHit = new EntityHitResult(entity, (Vec3)intersection.get());
        }
        return closestEntityHit;
    }
}

