/*
 * Decompiled with CFR 0.152.
 */
package com.httpedro.attributesetter.compat;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;

public class CuriosCompat {
    static final Map<ResourceLocation, Map<String, Map<Attribute, AttributeModifier>>> ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Attribute, AttributeModifier>>>();
    static final Map<ResourceLocation, Map<String, Map<Attribute, AttributeModifier>>> TAG_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Attribute, AttributeModifier>>>();
    static final Map<ResourceLocation, Map<String, Map<Attribute, Double>>> BASE_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Attribute, Double>>>();
    static final Map<ResourceLocation, Map<String, Map<Attribute, Double>>> BASE_TAG_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Attribute, Double>>>();

    public static boolean shouldCurioHandle(String idStr, JsonObject json) {
        String slot;
        boolean isTag = idStr.startsWith("#");
        ResourceLocation id = isTag ? new ResourceLocation(idStr.substring(1)) : new ResourceLocation(idStr);
        if (json.has("slot")) {
            slot = json.get("slot").getAsString();
            if (!slot.startsWith("curio:")) {
                return false;
            }
        } else {
            return false;
        }
        slot = slot.substring(slot.indexOf(58) + 1);
        double value = json.get("value").getAsDouble();
        Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(json.get("attribute").getAsString()));
        if (attr == null) {
            System.out.println("Failed to find attribute " + json.get("attribute").getAsString());
            return true;
        }
        String opStr = json.has("operation") ? json.get("operation").getAsString() : "ADDITION";
        if (opStr.equalsIgnoreCase("base")) {
            if (isTag) {
                CuriosCompat.registerTagItemBaseAttribute(id, attr, value, slot);
            } else {
                CuriosCompat.registerItemBaseAttribute(id, attr, value, slot);
            }
        } else {
            AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)opStr.toUpperCase());
            AttributeModifier mod = json.has("uuid") ? new AttributeModifier(UUID.fromString(json.get("uuid").getAsString()), "ASMod", value, op) : new AttributeModifier(UUID.randomUUID(), "ASMod", value, op);
            if (isTag) {
                CuriosCompat.registerTagItemAttributeModifier(id, attr, mod, slot);
            } else {
                CuriosCompat.registerItemAttributeModifier(id, attr, mod, slot);
            }
        }
        return true;
    }

    @SubscribeEvent
    public void curioAttributeModifier(CurioAttributeModifierEvent e) {
        Map map;
        AttributeModifier clone;
        Double val;
        ItemStack stack = e.getItemStack();
        String slot = e.getSlotContext().identifier();
        Item item = stack.m_41720_();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        for (Map.Entry<ResourceLocation, Map<String, Map<Attribute, Double>>> entry : BASE_TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry.getKey())) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Attribute, Double> entry2 : entry.getValue().get(slot).entrySet()) {
                e.removeAttribute(entry2.getKey());
                val = entry2.getValue();
                e.addModifier(entry2.getKey(), new AttributeModifier(e.getUuid(), "ASMod", val.doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        }
        for (Map.Entry<ResourceLocation, Map<String, Map<Attribute, Double>>> entry : BASE_ITEM_MODIFIERS.entrySet()) {
            if (!entry.getKey().equals((Object)id) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Object, Double> entry3 : entry.getValue().get(slot).entrySet()) {
                e.removeAttribute((Attribute)entry3.getKey());
                val = entry3.getValue();
                e.addModifier((Attribute)entry3.getKey(), new AttributeModifier(e.getUuid(), "ASMod", val.doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        }
        for (Map.Entry<ResourceLocation, Map<String, Map<Attribute, Double>>> entry : TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry.getKey())) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Object, Double> entry4 : entry.getValue().get(slot).entrySet()) {
                val = (AttributeModifier)entry4.getValue();
                clone = new AttributeModifier(e.getUuid(), val.m_22214_(), val.m_22218_(), val.m_22217_());
                e.addModifier((Attribute)entry4.getKey(), clone);
            }
        }
        Map modifiers = ITEM_MODIFIERS.getOrDefault(id, null);
        if (modifiers != null && (map = (Map)modifiers.getOrDefault(slot, null)) != null) {
            for (Map.Entry<Object, Double> entry : map.entrySet()) {
                val = (AttributeModifier)entry.getValue();
                clone = new AttributeModifier(e.getUuid(), val.m_22214_(), val.m_22218_(), val.m_22217_());
                e.addModifier((Attribute)entry.getKey(), clone);
            }
        }
    }

    public static void registerItemAttributeModifier(ResourceLocation item, Attribute attr, AttributeModifier modifier, String slot) {
        if (!ITEM_MODIFIERS.containsKey(item)) {
            ITEM_MODIFIERS.put(item, new HashMap());
        }
        if (!ITEM_MODIFIERS.get(item).containsKey(slot)) {
            ITEM_MODIFIERS.get(item).put(slot, new HashMap());
        }
        ITEM_MODIFIERS.get(item).get(slot).put(attr, modifier);
    }

    public static void registerTagItemAttributeModifier(ResourceLocation tag, Attribute attr, AttributeModifier modifier, String slot) {
        if (!TAG_ITEM_MODIFIERS.containsKey(tag)) {
            TAG_ITEM_MODIFIERS.put(tag, new HashMap());
        }
        if (!TAG_ITEM_MODIFIERS.get(tag).containsKey(slot)) {
            TAG_ITEM_MODIFIERS.get(tag).put(slot, new HashMap());
        }
        TAG_ITEM_MODIFIERS.get(tag).get(slot).put(attr, modifier);
    }

    public static void registerItemBaseAttribute(ResourceLocation item, Attribute attr, double baseValue, String slot) {
        if (!BASE_ITEM_MODIFIERS.containsKey(item)) {
            BASE_ITEM_MODIFIERS.put(item, new HashMap());
        }
        if (!BASE_ITEM_MODIFIERS.get(item).containsKey(slot)) {
            BASE_ITEM_MODIFIERS.get(item).put(slot, new HashMap());
        }
        BASE_ITEM_MODIFIERS.get(item).get(slot).put(attr, baseValue);
    }

    public static void registerTagItemBaseAttribute(ResourceLocation tag, Attribute attr, double baseValue, String slot) {
        if (!BASE_TAG_ITEM_MODIFIERS.containsKey(tag)) {
            BASE_TAG_ITEM_MODIFIERS.put(tag, new HashMap());
        }
        if (!BASE_TAG_ITEM_MODIFIERS.get(tag).containsKey(slot)) {
            BASE_TAG_ITEM_MODIFIERS.get(tag).put(slot, new HashMap());
        }
        BASE_TAG_ITEM_MODIFIERS.get(tag).get(slot).put(attr, baseValue);
    }
}

