/*
 * Decompiled with CFR 0.152.
 */
package com.httpedro.attributesetter;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.httpedro.attributesetter.ASLivingEntity;
import com.httpedro.attributesetter.AttributeSetterAPI;
import com.httpedro.attributesetter.DataReloader;
import com.httpedro.attributesetter.compat.CuriosCompat;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@Mod(value="attributesetter")
public class Attributesetter {
    public static final UUID DEFAULT_UUID = UUID.fromString("21ef99f1-c77a-42cf-ba8f-a59cf69ce7a6");
    public static final UUID BASE_UUID = UUID.fromString("b697bf19-6a3a-4baf-89ce-5d4a3422a3a4");
    private static final DataReloader dr = new DataReloader();
    public static final String MODID = "attributesetter";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("attributesetter", "main"), () -> "1.0", s -> true, s -> true);

    public Attributesetter() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (ModList.get().isLoaded("curios")) {
            MinecraftForge.EVENT_BUS.register((Object)new CuriosCompat());
        }
    }

    public void commonSetup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> CHANNEL.registerMessage(0, HashMap.class, (map, buf) -> {
            HashMap entries = map;
            buf.m_236831_((Map)entries, FriendlyByteBuf::m_130085_, (buf1, el) -> buf1.m_130070_(el.toString()));
        }, buf -> {
            HashMap entries = new HashMap();
            buf.m_236841_(i -> entries, FriendlyByteBuf::m_130281_, res -> JsonParser.parseString((String)res.m_130277_()));
            return entries;
        }, (map, contextSupplier) -> {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                dr.addEntry((ResourceLocation)entry.getKey(), (JsonElement)entry.getValue());
            }
        }));
    }

    @SubscribeEvent
    public void datapackReload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)dr);
    }

    @SubscribeEvent
    public void syncData(OnDatapackSyncEvent e) {
        for (ServerPlayer p : e.getPlayers()) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), Attributesetter.dr.entries);
        }
    }

    @SubscribeEvent
    public void onItemAttribute(ItemAttributeModifierEvent e) {
        Map map;
        ItemStack stack = e.getItemStack();
        EquipmentSlot slot = e.getSlotType();
        Item item = stack.m_41720_();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        for (Map.Entry<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>> entry : AttributeSetterAPI.BASE_TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry.getKey())) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Attribute, Pair<Double, UUID>> entry2 : entry.getValue().get(slot).entrySet()) {
                e.removeAttribute(entry2.getKey());
                e.addModifier(entry2.getKey(), new AttributeModifier((UUID)entry2.getValue().getB(), "ASMod", ((Double)entry2.getValue().getA()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        }
        for (Map.Entry<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>> entry : AttributeSetterAPI.BASE_ITEM_MODIFIERS.entrySet()) {
            if (!entry.getKey().equals((Object)id) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Object, Object> entry3 : entry.getValue().get(slot).entrySet()) {
                e.removeAttribute((Attribute)entry3.getKey());
                e.addModifier((Attribute)entry3.getKey(), new AttributeModifier((UUID)((Pair)entry3.getValue()).getB(), "ASMod", ((Double)((Pair)entry3.getValue()).getA()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        }
        for (Map.Entry<ResourceLocation, Map<EquipmentSlot, Map<Attribute, Pair<Double, UUID>>>> entry : AttributeSetterAPI.TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry.getKey())) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Object, Object> entry4 : entry.getValue().get(slot).entrySet()) {
                e.addModifier((Attribute)entry4.getKey(), (AttributeModifier)entry4.getValue());
            }
        }
        Map modifiers = AttributeSetterAPI.ITEM_MODIFIERS.getOrDefault(id, null);
        if (modifiers != null && (map = (Map)modifiers.getOrDefault(slot, null)) != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                e.addModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
            }
        }
    }

    private void processEntity(LivingEntity le) {
        if (((ASLivingEntity)le).as$isLoaded()) {
            return;
        }
        ((ASLivingEntity)le).as$setLoaded();
        ResourceLocation entityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)le.m_6095_());
        ResourceLocation id = new ResourceLocation(entityType.m_135827_(), entityType.m_135815_());
        for (Map.Entry<ResourceLocation, Map<Attribute, Double>> entry : AttributeSetterAPI.BASE_TAG_MODIFIERS.entrySet()) {
            if (!le.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)entry.getKey()))) continue;
            for (Map.Entry<Attribute, Double> modEntry : entry.getValue().entrySet()) {
                AttributeInstance attributeInstance = le.m_21051_(modEntry.getKey());
                if (attributeInstance == null) continue;
                attributeInstance.m_22100_(modEntry.getValue().doubleValue());
            }
        }
        Map baseMods = AttributeSetterAPI.BASE_MODIFIERS.getOrDefault(id, null);
        if (baseMods != null) {
            for (Map.Entry entry : baseMods.entrySet()) {
                AttributeInstance attrInstance2 = le.m_21051_((Attribute)entry.getKey());
                if (attrInstance2 == null) continue;
                attrInstance2.m_22100_(((Double)entry.getValue()).doubleValue());
            }
        }
        for (Map.Entry<ResourceLocation, Map<Attribute, AttributeModifier>> entry : AttributeSetterAPI.TAG_MODIFIERS.entrySet()) {
            if (!le.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)entry.getKey()))) continue;
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                AttributeInstance attrInstance3 = le.m_21051_((Attribute)entry2.getKey());
                if (attrInstance3 == null) continue;
                attrInstance3.m_22125_((AttributeModifier)entry2.getValue());
            }
        }
        Map map = AttributeSetterAPI.ENTITY_MODIFIERS.getOrDefault(id, null);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeInstance attributeInstance = le.m_21051_((Attribute)entry.getKey());
                if (attributeInstance == null) continue;
                attributeInstance.m_22125_((AttributeModifier)entry.getValue());
            }
        }
        le.m_21153_(le.m_21233_());
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent e) {
        Level world = e.getLevel();
        Entity entity = e.getEntity();
        if (world.f_46443_) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        this.processEntity(le);
    }

    @SubscribeEvent
    public void onEntitySpawn(MobSpawnEvent.FinalizeSpawn e) {
        ServerLevelAccessor world = e.getLevel();
        Mob entity = e.getEntity();
        if (world.m_5776_()) {
            return;
        }
        this.processEntity((LivingEntity)entity);
    }

    @Mod.EventBusSubscriber(modid="attributesetter", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void tooltipEvent(ItemTooltipEvent e) {
            List lines = e.getToolTip();
            HashMap<String, Double> greenAttributes = new HashMap<String, Double>();
            String currentSlot = null;
            int mainhandSlotIndex = -1;
            int i = 0;
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                block9: {
                    Component line;
                    block7: {
                        double value;
                        String attrName;
                        String spdAttrName;
                        block14: {
                            String dmgAttrName;
                            block13: {
                                TranslatableContents ttc;
                                block10: {
                                    block12: {
                                        block11: {
                                            block8: {
                                                line = (Component)it.next();
                                                ComponentContents content = line.m_214077_();
                                                if (!(content instanceof TranslatableContents)) break block7;
                                                ttc = (TranslatableContents)content;
                                                dmgAttrName = "attribute.name.generic.attack_damage";
                                                spdAttrName = "attribute.name.generic.attack_speed";
                                                if (!ttc.m_237508_().startsWith("item.modifiers")) break block8;
                                                currentSlot = ttc.m_237508_().substring(ttc.m_237508_().lastIndexOf(46) + 1);
                                                if (currentSlot.equals("mainhand")) {
                                                    mainhandSlotIndex = i;
                                                }
                                                break block9;
                                            }
                                            if (!ttc.m_237508_().startsWith("attribute.modifier.plus.0") || currentSlot == null) break block10;
                                            if (!NumberUtils.isCreatable((String)ttc.m_237509_(0).getString())) {
                                                ++i;
                                                continue;
                                            }
                                            attrName = ((TranslatableContents)((MutableComponent)ttc.m_237509_(1)).m_214077_()).m_237508_();
                                            value = Double.parseDouble(ttc.m_237509_(0).getString());
                                            if (!greenAttributes.containsKey(attrName)) break block11;
                                            greenAttributes.put(attrName, (Double)greenAttributes.get(attrName) + value);
                                            it.remove();
                                            break block9;
                                        }
                                        if (!attrName.equals(dmgAttrName) || !currentSlot.equals("mainhand")) break block12;
                                        greenAttributes.put(attrName, value + 1.0);
                                        it.remove();
                                        break block9;
                                    }
                                    if (!attrName.equals(spdAttrName) || !currentSlot.equals("mainhand")) break block9;
                                    greenAttributes.put(attrName, 4.0 + value);
                                    it.remove();
                                    break block9;
                                }
                                if (!ttc.m_237508_().startsWith("attribute.modifier.take.0") || currentSlot == null) break block9;
                                if (!NumberUtils.isCreatable((String)ttc.m_237509_(0).getString())) {
                                    ++i;
                                    continue;
                                }
                                attrName = ((TranslatableContents)((MutableComponent)ttc.m_237509_(1)).m_214077_()).m_237508_();
                                value = Double.parseDouble(ttc.m_237509_(0).getString());
                                if (!greenAttributes.containsKey(attrName)) break block13;
                                greenAttributes.put(attrName, (Double)greenAttributes.get(attrName) - value);
                                it.remove();
                                break block9;
                            }
                            if (!attrName.equals(dmgAttrName) || !currentSlot.equals("mainhand")) break block14;
                            greenAttributes.put(attrName, -value + 1.0);
                            it.remove();
                            break block9;
                        }
                        if (!attrName.equals(spdAttrName) || !currentSlot.equals("mainhand")) break block9;
                        greenAttributes.put(attrName, 4.0 - value);
                        it.remove();
                        break block9;
                    }
                    for (Component part : line.m_7360_()) {
                        TranslatableContents ttc;
                        ComponentContents value = part.m_214077_();
                        if (!(value instanceof TranslatableContents) || !(ttc = (TranslatableContents)value).m_237508_().startsWith("attribute.modifier.equals.0")) continue;
                        if (!NumberUtils.isCreatable((String)ttc.m_237509_(0).getString())) {
                            ++i;
                            continue;
                        }
                        String attrName = ((TranslatableContents)((MutableComponent)ttc.m_237509_(1)).m_214077_()).m_237508_();
                        greenAttributes.put(attrName, Double.parseDouble(ttc.m_237509_(0).getString()));
                        it.remove();
                    }
                }
                ++i;
            }
            i = 0;
            for (Map.Entry entry : greenAttributes.entrySet()) {
                String attrName = (String)entry.getKey();
                Double value = (Double)entry.getValue();
                MutableComponent line = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"attribute.modifier.equals.0", (Object[])new Object[]{Component.m_237113_((String)ItemStack.f_41584_.format(value)).m_130940_(ChatFormatting.DARK_GREEN), Component.m_237115_((String)attrName).m_130940_(ChatFormatting.DARK_GREEN)}));
                lines.add(mainhandSlotIndex + i + 1, line);
                ++i;
            }
        }
    }
}

