/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.commandstructures.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.telepathicgrunt.commandstructures.CommandStructuresMain;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SpawnPiecesCommand {
    private static MinecraftServer currentMinecraftServer = null;
    private static Set<ResourceLocation> cachedSuggestion = new HashSet<ResourceLocation>();

    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        String commandString = "spawnpieces";
        String rlArg = "resourcelocationpath";
        String locationArg = "location";
        String savepieceArg = "savepieces";
        String floorblockArg = "floorblock";
        String fillerblockArg = "fillerblock";
        String rowlengthArg = "rowlength";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(permission -> permission.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)rlArg, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82926_(SpawnPiecesCommand.templatePathsSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(cs -> {
            WorldCoordinates worldCoordinates = new WorldCoordinates(new WorldCoordinate(false, ((CommandSourceStack)cs.getSource()).m_81371_().m_7096_()), new WorldCoordinate(false, ((CommandSourceStack)cs.getSource()).m_81371_().m_7098_()), new WorldCoordinate(false, ((CommandSourceStack)cs.getSource()).m_81371_().m_7094_()));
            SpawnPiecesCommand.spawnPieces((ResourceLocation)cs.getArgument(rlArg, ResourceLocation.class), (Coordinates)worldCoordinates, false, Blocks.f_50375_.m_49966_(), Blocks.f_50016_.m_49966_(), 13, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)locationArg, (ArgumentType)Vec3Argument.m_120841_()).executes(cs -> {
            SpawnPiecesCommand.spawnPieces((ResourceLocation)cs.getArgument(rlArg, ResourceLocation.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), false, Blocks.f_50375_.m_49966_(), Blocks.f_50016_.m_49966_(), 13, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)savepieceArg, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            SpawnPiecesCommand.spawnPieces((ResourceLocation)cs.getArgument(rlArg, ResourceLocation.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (Boolean)cs.getArgument(savepieceArg, Boolean.TYPE), Blocks.f_50375_.m_49966_(), Blocks.f_50016_.m_49966_(), 13, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)floorblockArg, (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext)).executes(cs -> {
            SpawnPiecesCommand.spawnPieces((ResourceLocation)cs.getArgument(rlArg, ResourceLocation.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (Boolean)cs.getArgument(savepieceArg, Boolean.TYPE), BlockStateArgument.m_116123_((CommandContext)cs, (String)floorblockArg).m_114669_(), Blocks.f_50016_.m_49966_(), 13, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)fillerblockArg, (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext)).executes(cs -> {
            SpawnPiecesCommand.spawnPieces((ResourceLocation)cs.getArgument(rlArg, ResourceLocation.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (Boolean)cs.getArgument(savepieceArg, Boolean.TYPE), BlockStateArgument.m_116123_((CommandContext)cs, (String)floorblockArg).m_114669_(), BlockStateArgument.m_116123_((CommandContext)cs, (String)fillerblockArg).m_114669_(), 13, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(Commands.m_82129_((String)rowlengthArg, (ArgumentType)IntegerArgumentType.integer()).executes(cs -> {
            SpawnPiecesCommand.spawnPieces((ResourceLocation)cs.getArgument(rlArg, ResourceLocation.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (Boolean)cs.getArgument(savepieceArg, Boolean.TYPE), BlockStateArgument.m_116123_((CommandContext)cs, (String)floorblockArg).m_114669_(), BlockStateArgument.m_116123_((CommandContext)cs, (String)fillerblockArg).m_114669_(), (Integer)cs.getArgument(rowlengthArg, Integer.class), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).redirect((CommandNode)source));
    }

    private static Set<ResourceLocation> templatePathsSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).m_81377_()) {
            return cachedSuggestion;
        }
        ResourceManager resourceManager = ((CommandSourceStack)cs.getSource()).m_81372_().m_7654_().m_177941_();
        HashSet modidStrings = new HashSet();
        Set<ResourceLocation> rlSet = resourceManager.m_214159_("structures", filename -> filename.toString().endsWith(".nbt")).keySet().stream().map(resourceLocation -> {
            String namespace = resourceLocation.m_135827_();
            modidStrings.add(namespace);
            Object path = resourceLocation.m_135815_().replaceAll("structures/", "").replaceAll(".nbt", "");
            int i = ((String)path).lastIndexOf(47);
            if (i > 0) {
                path = ((String)path).substring(0, i) + "/";
            }
            return new ResourceLocation(namespace, (String)path);
        }).collect(Collectors.toSet());
        rlSet.addAll(modidStrings.stream().map(modid -> new ResourceLocation(modid, "")).collect(Collectors.toSet()));
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).m_81377_();
        cachedSuggestion = rlSet;
        return rlSet;
    }

    public static void spawnPieces(ResourceLocation path, Coordinates coordinates, boolean savePieces, BlockState floorBlockState, BlockState fillBlockState, int rowlength, CommandContext<CommandSourceStack> cs) {
        Player player1;
        ServerLevel level = ((CommandSourceStack)cs.getSource()).m_81372_();
        Entity entity = ((CommandSourceStack)cs.getSource()).m_81373_();
        Player player = entity instanceof Player ? (player1 = (Player)entity) : null;
        BlockPos pos = coordinates.m_119568_((CommandSourceStack)cs.getSource());
        List<ResourceLocation> nbtRLs = SpawnPiecesCommand.getResourceLocations(level, path.m_135827_(), path.m_135815_());
        if (nbtRLs.isEmpty()) {
            String errorMsg = path + " path has no nbt pieces in it. No pieces will be placed.";
            CommandStructuresMain.LOGGER.error(errorMsg);
            throw new CommandRuntimeException((Component)Component.m_237115_((String)errorMsg));
        }
        int columnCount = rowlength;
        int rowCount = (int)Math.max(Math.ceil((float)nbtRLs.size() / (float)columnCount), 1.0);
        if (rowCount == 1) {
            columnCount = nbtRLs.size();
        }
        int spacing = 48;
        BlockPos bounds = new BlockPos(spacing * rowCount + 16, spacing, spacing * columnCount);
        SpawnPiecesCommand.clearAreaNew(level, pos, player, bounds, fillBlockState, floorBlockState);
        SpawnPiecesCommand.generateStructurePieces(level, pos, player, nbtRLs, columnCount, spacing, savePieces);
    }

    private static void clearAreaNew(ServerLevel world, BlockPos pos, Player player, BlockPos bounds, BlockState fillBlock, BlockState floorBlock) {
        BlockPos.MutableBlockPos mutableChunk = new BlockPos.MutableBlockPos().m_122178_(pos.m_123341_() >> 4, pos.m_123342_(), pos.m_123343_() >> 4);
        mutableChunk.m_122184_(1, 0, 0);
        int endChunkX = pos.m_123341_() + bounds.m_123341_() >> 4;
        int endChunkZ = pos.m_123343_() + bounds.m_123343_() >> 4;
        int maxChunks = (endChunkX - mutableChunk.m_123341_()) * (endChunkZ - mutableChunk.m_123343_());
        int currentSection = 0;
        while (mutableChunk.m_123341_() < endChunkX) {
            while (mutableChunk.m_123343_() < endChunkZ) {
                LevelChunk chunk = world.m_6325_(mutableChunk.m_123341_(), mutableChunk.m_123343_());
                BlockPos.MutableBlockPos mutable = new BlockPos(mutableChunk.m_123341_() << 4, pos.m_123342_(), mutableChunk.m_123343_() << 4).m_122032_();
                mutable.m_122184_(-1, 0, 0);
                for (int x = 0; x < 16; ++x) {
                    mutable.m_142443_(mutableChunk.m_123343_() << 4);
                    mutable.m_122184_(1, 0, -1);
                    for (int z = 0; z < 16; ++z) {
                        mutable.m_122184_(0, 0, 1);
                        mutable.m_142448_(pos.m_123342_());
                        BlockState oldState = chunk.m_6978_((BlockPos)mutable, floorBlock, false);
                        if (oldState != null) {
                            world.m_7726_().m_8450_((BlockPos)mutable);
                            world.m_7726_().m_7827_().m_7174_((BlockPos)mutable);
                        }
                        for (int y = pos.m_123342_() + 1; y < pos.m_123342_() + 64; ++y) {
                            mutable.m_142448_(y);
                            oldState = chunk.m_6978_((BlockPos)mutable, fillBlock, false);
                            if (oldState == null) continue;
                            world.m_7726_().m_8450_((BlockPos)mutable);
                            world.m_7726_().m_7827_().m_7174_((BlockPos)mutable);
                        }
                    }
                }
                ++currentSection;
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)("Working: %" + Math.round((float)currentSection / (float)maxChunks * 100.0f))), true);
                }
                mutableChunk.m_122184_(0, 0, 1);
            }
            mutableChunk.m_122178_(mutableChunk.m_123341_(), mutableChunk.m_123342_(), pos.m_123343_() >> 4);
            mutableChunk.m_122184_(1, 0, 0);
        }
    }

    private static List<ResourceLocation> getResourceLocations(ServerLevel world, String modId, String filter) {
        ResourceManager resourceManager = world.m_7654_().m_177941_();
        return resourceManager.m_214159_("structures", filename -> filename.toString().endsWith(".nbt")).keySet().stream().filter(resourceLocation -> resourceLocation.m_135827_().equals(modId)).filter(resourceLocation -> resourceLocation.m_135815_().startsWith("structures/" + filter)).map(resourceLocation -> new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().replaceAll("^structures/", "").replaceAll(".nbt$", ""))).toList();
    }

    private static void generateStructurePieces(ServerLevel world, BlockPos pos, Player player, List<ResourceLocation> nbtRLs, int columnCount, int spacing, boolean savePieces) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_((pos.m_123341_() >> 4) + 1 << 4, pos.m_123342_(), pos.m_123343_() >> 4 << 4);
        for (int pieceIndex = 1; pieceIndex <= nbtRLs.size(); ++pieceIndex) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)("Working making structure: " + nbtRLs.get(pieceIndex - 1))), true);
            }
            world.m_7731_((BlockPos)mutable, (BlockState)Blocks.f_50677_.m_49966_().m_61124_((Property)StructureBlock.f_57110_, (Comparable)StructureMode.LOAD), 3);
            BlockEntity be = world.m_7702_((BlockPos)mutable);
            if (be instanceof StructureBlockEntity) {
                StructureBlockEntity structureBlockTileEntity = (StructureBlockEntity)be;
                structureBlockTileEntity.m_59874_(nbtRLs.get(pieceIndex - 1));
                structureBlockTileEntity.m_59860_(StructureMode.LOAD);
                structureBlockTileEntity.m_59876_(false);
                SpawnPiecesCommand.fillStructureVoidSpace(world, nbtRLs.get(pieceIndex - 1), (BlockPos)mutable);
                structureBlockTileEntity.m_59844_(world, false);
                structureBlockTileEntity.m_59860_(StructureMode.SAVE);
                if (savePieces) {
                    structureBlockTileEntity.m_59889_(true);
                }
                structureBlockTileEntity.m_59876_(false);
            }
            mutable.m_122184_(0, 0, spacing);
            if (pieceIndex % columnCount != 0) continue;
            mutable.m_122184_(spacing, 0, -spacing * columnCount);
        }
    }

    private static void fillStructureVoidSpace(ServerLevel world, ResourceLocation resourceLocation, BlockPos startSpot) {
        StructureTemplateManager structuremanager = world.m_215082_();
        Optional optional = structuremanager.m_230407_(resourceLocation);
        optional.ifPresent(template -> {
            BlockPos.MutableBlockPos mutable = startSpot.m_122032_();
            ChunkAccess chunk = world.m_46865_((BlockPos)mutable);
            for (int x = 0; x < template.m_163801_().m_123341_(); ++x) {
                for (int z = 0; z < template.m_163801_().m_123343_(); ++z) {
                    for (int y = 0; y < template.m_163801_().m_123342_(); ++y) {
                        BlockState oldState;
                        mutable.m_122190_((Vec3i)startSpot).m_122184_(x, y + 1, z);
                        if (chunk.m_7697_().f_45578_ != mutable.m_123341_() >> 4 || chunk.m_7697_().f_45579_ != mutable.m_123343_() >> 4) {
                            chunk = world.m_46865_((BlockPos)mutable);
                        }
                        if ((oldState = chunk.m_6978_((BlockPos)mutable, Blocks.f_50454_.m_49966_(), false)) == null) continue;
                        world.m_7726_().m_8450_((BlockPos)mutable);
                        world.m_7726_().m_7827_().m_7174_((BlockPos)mutable);
                    }
                }
            }
        });
    }
}

