/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.commandstructures.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class SpawnMobsCommand {
    private static MinecraftServer currentMinecraftServer = null;
    private static Set<String> cachedSuggestion = new HashSet<String>();

    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        String commandString = "spawnmobs";
        String rlArg = "resourcelocationpath";
        String locationArg = "location";
        String rowlengthArg = "rowlength";
        String livingentitiesArg = "livingentities";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(permission -> permission.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)rlArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.m_82970_(SpawnMobsCommand.namespaceSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).executes(cs -> {
            WorldCoordinates worldCoordinates = new WorldCoordinates(new WorldCoordinate(false, ((CommandSourceStack)cs.getSource()).m_81371_().m_7096_()), new WorldCoordinate(false, ((CommandSourceStack)cs.getSource()).m_81371_().m_7098_()), new WorldCoordinate(false, ((CommandSourceStack)cs.getSource()).m_81371_().m_7094_()));
            SpawnMobsCommand.spawnMobs((String)cs.getArgument(rlArg, String.class), (Coordinates)worldCoordinates, 13, false, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)locationArg, (ArgumentType)Vec3Argument.m_120841_()).executes(cs -> {
            SpawnMobsCommand.spawnMobs((String)cs.getArgument(rlArg, String.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), 13, false, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)rowlengthArg, (ArgumentType)IntegerArgumentType.integer()).executes(cs -> {
            SpawnMobsCommand.spawnMobs((String)cs.getArgument(rlArg, String.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (Integer)cs.getArgument(rowlengthArg, Integer.class), false, (CommandContext<CommandSourceStack>)cs);
            return 1;
        })).then(Commands.m_82129_((String)livingentitiesArg, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            SpawnMobsCommand.spawnMobs((String)cs.getArgument(rlArg, String.class), Vec3Argument.m_120849_((CommandContext)cs, (String)locationArg), (Integer)cs.getArgument(rowlengthArg, Integer.class), (Boolean)cs.getArgument(livingentitiesArg, Boolean.class), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).redirect((CommandNode)source));
    }

    private static Set<String> namespaceSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).m_81377_()) {
            return cachedSuggestion;
        }
        HashSet<String> modidStrings = new HashSet<String>();
        BuiltInRegistries.f_256780_.m_6579_().forEach(entry -> {
            if (((EntityType)entry.getValue()).m_20654_()) {
                modidStrings.add(((ResourceKey)entry.getKey()).m_135782_().m_135827_());
            }
        });
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).m_81377_();
        cachedSuggestion = modidStrings;
        return modidStrings;
    }

    public static void spawnMobs(String namespace, Coordinates coordinates, int rowlength, boolean livingEntitiesOnly, CommandContext<CommandSourceStack> cs) {
        Player player1;
        ServerLevel level = ((CommandSourceStack)cs.getSource()).m_81372_();
        Entity entity = ((CommandSourceStack)cs.getSource()).m_81373_();
        Player player = entity instanceof Player ? (player1 = (Player)entity) : null;
        BlockPos pos = coordinates.m_119568_((CommandSourceStack)cs.getSource());
        List<EntityType> types = BuiltInRegistries.f_256780_.m_6579_().stream().filter(e -> namespace.equals("all") || ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals(namespace)).map(Map.Entry::getValue).toList();
        List<Entity> entities = types.stream().map(e -> e.m_20615_((Level)level)).collect(Collectors.toList());
        if (livingEntitiesOnly) {
            entities = entities.stream().filter(e -> e instanceof LivingEntity).collect(Collectors.toList());
        }
        int columnCount = rowlength;
        int rowCount = (int)Math.max(Math.ceil((float)types.size() / (float)columnCount), 1.0);
        if (rowCount == 1) {
            columnCount = types.size();
        }
        int spacing = 12;
        BlockPos bounds = new BlockPos(spacing * rowCount + 16, spacing, spacing * columnCount);
        SpawnMobsCommand.clearAreaNew(level, pos, player, bounds, Blocks.f_50016_.m_49966_(), Blocks.f_50375_.m_49966_());
        SpawnMobsCommand.spawnMobs(level, pos, player, entities, columnCount, spacing);
    }

    private static void clearAreaNew(ServerLevel world, BlockPos pos, Player player, BlockPos bounds, BlockState fillBlock, BlockState floorBlock) {
        BlockPos.MutableBlockPos mutableChunk = new BlockPos.MutableBlockPos().m_122178_(pos.m_123341_() >> 4, pos.m_123342_(), pos.m_123343_() >> 4);
        mutableChunk.m_122184_(1, 0, 0);
        int endChunkX = pos.m_123341_() + bounds.m_123341_() >> 4;
        int endChunkZ = pos.m_123343_() + bounds.m_123343_() >> 4;
        int maxChunks = (endChunkX - mutableChunk.m_123341_()) * (endChunkZ - mutableChunk.m_123343_());
        int currentSection = 0;
        while (mutableChunk.m_123341_() <= endChunkX) {
            while (mutableChunk.m_123343_() <= endChunkZ) {
                LevelChunk chunk = world.m_6325_(mutableChunk.m_123341_(), mutableChunk.m_123343_());
                BlockPos.MutableBlockPos mutable = new BlockPos(mutableChunk.m_123341_() << 4, pos.m_123342_(), mutableChunk.m_123343_() << 4).m_122032_();
                mutable.m_122184_(-1, 0, 0);
                for (int x = 0; x < 16; ++x) {
                    mutable.m_142443_(mutableChunk.m_123343_() << 4);
                    mutable.m_122184_(1, 0, -1);
                    for (int z = 0; z < 16; ++z) {
                        mutable.m_122184_(0, 0, 1);
                        mutable.m_142448_(pos.m_123342_());
                        BlockState oldState = chunk.m_6978_((BlockPos)mutable, floorBlock, false);
                        if (oldState != null) {
                            world.m_7726_().m_8450_((BlockPos)mutable);
                            world.m_7726_().m_7827_().m_7174_((BlockPos)mutable);
                        }
                        for (int y = pos.m_123342_() + 1; y < pos.m_123342_() + 64; ++y) {
                            mutable.m_142448_(y);
                            oldState = chunk.m_6978_((BlockPos)mutable, fillBlock, false);
                            if (oldState == null) continue;
                            world.m_7726_().m_8450_((BlockPos)mutable);
                            world.m_7726_().m_7827_().m_7174_((BlockPos)mutable);
                        }
                    }
                }
                ++currentSection;
                if (player != null) {
                    player.m_5661_((Component)Component.m_237115_((String)("Working: %" + Math.round((float)currentSection / (float)maxChunks * 100.0f))), true);
                }
                mutableChunk.m_122184_(0, 0, 1);
            }
            mutableChunk.m_122178_(mutableChunk.m_123341_(), mutableChunk.m_123342_(), pos.m_123343_() >> 4);
            mutableChunk.m_122184_(1, 0, 0);
        }
    }

    private static void spawnMobs(ServerLevel world, BlockPos pos, Player player, List<Entity> entities, int columnCount, int spacing) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_((pos.m_123341_() >> 4) + 1 << 4, pos.m_123342_(), pos.m_123343_() >> 4 << 4);
        mutable.m_122184_(7, 1, 7);
        for (int mobIndex = 1; mobIndex <= entities.size(); ++mobIndex) {
            Entity entity;
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)"Spawning mobs"), true);
            }
            if ((entity = entities.get(mobIndex - 1)) != null) {
                entity.m_146884_(Vec3.m_82512_((Vec3i)mutable.m_7494_()));
                entity.m_20242_(true);
                entity.m_20331_(true);
                entity.f_19794_ = true;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21530_();
                    mob.m_21557_(true);
                    mob.m_7910_(0.0f);
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 99999999, 255, true, false, false));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 99999999, 255, true, false, false));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 99999999, 255, true, false, false));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 99999999, 255, true, false, false));
                }
                world.m_7967_(entity);
            }
            mutable.m_122184_(0, 0, spacing);
            if (mobIndex % columnCount != 0) continue;
            mutable.m_122184_(spacing, 0, -spacing * columnCount);
        }
    }
}

