/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.platform;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.platform.RegistryEntry;
import com.github.eterdelta.crittersandcompanions.platform.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegistryHelper<T>
implements RegistryHelper<T> {
    protected final DeferredRegister<T> deferred;

    public ForgeRegistryHelper(ResourceKey<Registry<T>> key, String modid) {
        this.deferred = DeferredRegister.create(key, (String)modid);
        FMLJavaModLoadingContext modContext = FMLJavaModLoadingContext.get();
        if (modContext == null) {
            throw new IllegalStateException("created registry helper too late: %s for %s".formatted(key, modid));
        }
        this.deferred.register(modContext.getModEventBus());
    }

    @Override
    public <R extends T> RegistryEntry<R> register(String id, Supplier<? extends R> creator) {
        final RegistryObject value = this.deferred.register(id, creator);
        return new RegistryEntry<R>(){

            @Override
            public R get() {
                return value.get();
            }

            @Override
            public ResourceKey<R> getKey() {
                return value.getKey();
            }
        };
    }

    public static class ItemHelper
    extends ForgeRegistryHelper<Item> {
        public ItemHelper(String modid) {
            super(Registries.f_256913_, modid);
            IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
            modBus.addListener(event -> {
                if (event.getTab() != CrittersAndCompanions.CREATIVE_TAB.get()) {
                    return;
                }
                this.deferred.getEntries().forEach(it -> event.m_246342_(new ItemStack((ItemLike)it.get())));
            });
        }
    }
}

