/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity.brain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OtterNavigation
extends AmphibiousPathNavigation {
    private static final float EPSILON = 1.0E-8f;
    private static final double PROGRESS_MIN2 = 0.12249999999999998;
    private static final int PROGRESS_TICKS = 18;
    private final Cache<BlockPos, Boolean> cache = CacheBuilder.newBuilder().maximumSize(12000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();
    private Vec3 lastCheckPos = Vec3.f_82478_;
    private int lastCheckTick = 0;
    private int stuckReplans = 0;
    private int jumpCooldown = 0;

    public OtterNavigation(Mob mob, Level level) {
        super(mob, level);
        this.m_7008_(true);
    }

    protected PathFinder m_5532_(int nodes) {
        AmphibiousNodeEvaluator evaluator = new AmphibiousNodeEvaluator(true);
        evaluator.m_77351_(false);
        this.f_26508_ = evaluator;
        return new PathFinder(this.f_26508_, nodes);
    }

    protected boolean m_7632_() {
        return true;
    }

    public boolean m_6342_(BlockPos pos) {
        if (!this.f_26495_.m_8055_(pos).m_60795_()) {
            return super.m_6342_(pos);
        }
        BlockState below = this.f_26495_.m_8055_(pos.m_7495_());
        if (below.m_60795_() && !below.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        return this.f_26495_.m_8055_(pos).m_60795_() && this.f_26495_.m_8055_(pos.m_7494_()).m_60795_();
    }

    protected void m_7636_() {
        if (this.f_26496_ == null || this.f_26496_.m_77392_()) {
            return;
        }
        Vec3 entityPos = this.m_7475_();
        int nextIdx = this.f_26496_.m_77399_();
        double yFloor = Math.floor(entityPos.f_82480_);
        for (int lastIdx = nextIdx; lastIdx < this.f_26496_.m_77398_() && (double)this.f_26496_.m_77375_((int)lastIdx).f_77272_ == yFloor; ++lastIdx) {
        }
        for (int i = lastIdx - 1; i > nextIdx; --i) {
            if (!this.catchF(entityPos, this.f_26496_.m_77382_((Entity)this.f_26494_, i))) continue;
            this.f_26496_.m_77393_(i);
            break;
        }
        if (this.hasReached(this.f_26496_, 0.8f) || this.isAtElevationChange(this.f_26496_) && this.hasReached(this.f_26496_, 1.0f)) {
            this.f_26496_.m_77374_();
        }
        if (this.f_26496_.m_77392_()) {
            return;
        }
        Vec3 target = this.f_26496_.m_77380_((Entity)this.f_26494_);
        this.f_26494_.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, this.f_26497_);
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (!this.f_26494_.m_20069_() && this.f_26494_.m_20096_() && this.f_26494_.f_19862_ && this.jumpCooldown == 0) {
            Vec3 dir = new Vec3(target.f_82479_ - this.f_26494_.m_20185_(), 0.0, target.f_82481_ - this.f_26494_.m_20189_());
            if (dir.m_82556_() > 1.0E-4) {
                dir = dir.m_82541_();
            }
            double reach = (double)this.f_26494_.m_20205_() * 0.5 + 0.6;
            BlockPos front = BlockPos.m_274561_((double)(this.f_26494_.m_20185_() + dir.f_82479_ * reach), (double)Math.floor(this.f_26494_.m_20186_()), (double)(this.f_26494_.m_20189_() + dir.f_82481_ * reach));
            VoxelShape shape = this.f_26495_.m_8055_(front).m_60812_((BlockGetter)this.f_26495_, front);
            double h = shape.m_83281_() ? 0.0 : shape.m_83297_(Direction.Axis.Y);
            BlockPos head = front.m_7494_();
            boolean headClear = this.f_26495_.m_8055_(head).m_60812_((BlockGetter)this.f_26495_, head).m_83281_();
            boolean head2Clear = this.f_26495_.m_8055_(head.m_7494_()).m_60812_((BlockGetter)this.f_26495_, head.m_7494_()).m_83281_();
            if (h > 0.01 && h <= 1.2 && headClear && head2Clear) {
                this.f_26494_.m_21569_().m_24901_();
                this.jumpCooldown = 6;
            } else {
                this.perpendicularSideS(dir);
            }
        }
        if (this.f_26494_.m_20069_()) {
            if (this.f_26494_.f_19862_ && this.damp()) {
                return;
            }
            if (this.f_26495_.m_6425_(BlockPos.m_274446_((Position)this.f_26494_.m_146892_())).m_205070_(FluidTags.f_13131_) && target.f_82480_ > entityPos.f_82480_) {
                this.f_26494_.m_20256_(this.f_26494_.m_20184_().m_82520_(0.0, 0.03, 0.0));
            }
            if (this.f_26494_.m_20096_() && this.f_26494_.f_19862_ && this.jumpCooldown == 0) {
                double shadeHeight;
                BlockPos nose = this.f_26494_.m_20183_().m_121945_(this.f_26494_.m_6350_());
                VoxelShape shape = this.f_26495_.m_8055_(nose).m_60812_((BlockGetter)this.f_26495_, nose);
                double d = shadeHeight = shape.m_83281_() ? 0.0 : shape.m_83297_(Direction.Axis.Y);
                if (shadeHeight > 0.01 && shadeHeight <= 1.2 && this.f_26495_.m_8055_(nose.m_7494_()).m_60812_((BlockGetter)this.f_26495_, nose.m_7494_()).m_83281_() && this.f_26495_.m_8055_(nose.m_6630_(2)).m_60812_((BlockGetter)this.f_26495_, nose.m_6630_(2)).m_83281_()) {
                    this.f_26494_.m_21569_().m_24901_();
                    this.jumpCooldown = 6;
                }
            }
        }
        if (this.f_26494_.f_19797_ - this.lastCheckTick >= 18) {
            Vec3 curr = this.f_26494_.m_20182_();
            if (curr.m_82557_(this.lastCheckPos) < 0.12249999999999998) {
                BlockPos targetPos = this.m_26567_();
                if (targetPos != null) {
                    this.m_26569_();
                }
                if (++this.stuckReplans >= 3 && this.f_26496_ != null && !this.f_26496_.m_77392_()) {
                    Vec3 dir = new Vec3(target.f_82479_ - curr.f_82479_, 0.0, target.f_82481_ - curr.f_82481_);
                    if (dir.m_82556_() > 1.0E-4) {
                        dir = dir.m_82541_();
                    }
                    this.perpendicularSideS(dir);
                    this.stuckReplans = 0;
                }
            } else {
                this.stuckReplans = 0;
            }
            this.lastCheckPos = curr;
            this.lastCheckTick = this.f_26494_.f_19797_;
        }
    }

    private boolean hasReached(Path path, float threshold) {
        Vec3 pos = path.m_77380_((Entity)this.f_26494_);
        if (Math.abs(this.f_26494_.m_20185_() - pos.f_82479_) >= (double)threshold) {
            return false;
        }
        if (Math.abs(this.f_26494_.m_20189_() - pos.f_82481_) >= (double)threshold) {
            return false;
        }
        return Math.abs(this.f_26494_.m_20186_() - pos.f_82480_) <= 1.001;
    }

    private boolean isAtElevationChange(Path path) {
        int idx = path.m_77399_();
        int end = Math.min(path.m_77398_(), idx + Mth.m_14167_((float)(this.f_26494_.m_20205_() * 0.5f)) + 1);
        int y = path.m_77375_((int)idx).f_77272_;
        for (int i = idx + 1; i < end; ++i) {
            if (path.m_77375_((int)i).f_77272_ == y) continue;
            return true;
        }
        return false;
    }

    private boolean catchF(Vec3 from, Vec3 to) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        Vec3 vec = to.m_82546_(from);
        float maxT = (float)vec.m_82553_();
        if (maxT < 1.0E-6f) {
            return true;
        }
        float dx = (float)(vec.f_82479_ / (double)maxT);
        float dy = (float)(vec.f_82480_ / (double)maxT);
        float dz = (float)(vec.f_82481_ / (double)maxT);
        int currentX = Mth.m_14107_((double)from.f_82479_);
        int currentY = Mth.m_14107_((double)from.f_82480_);
        int currentZ = Mth.m_14107_((double)from.f_82481_);
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(Mth.m_14107_((double)from.f_82479_) + 1) : (float)Mth.m_14107_((double)from.f_82479_);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - from.f_82479_) / (double)dx);
        }
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(Mth.m_14107_((double)from.f_82480_) + 1) : (float)Mth.m_14107_((double)from.f_82480_);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - from.f_82480_) / (double)dy);
        }
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(Mth.m_14107_((double)from.f_82481_) + 1) : (float)Mth.m_14107_((double)from.f_82481_);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - from.f_82481_) / (double)dz);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.m_122178_(currentX, currentY, currentZ);
            BlockPos immutablePos = pos.m_7949_();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                BlockState blockState = this.f_26495_.m_8055_((BlockPos)pos);
                isPathfindable = blockState.m_60647_((BlockGetter)this.f_26495_, (BlockPos)pos, PathComputationType.LAND);
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            BlockPathTypes pathType = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, currentX, currentY, currentZ, this.f_26494_);
            float malus = this.f_26494_.m_21439_(pathType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathType != BlockPathTypes.DAMAGE_FIRE && pathType != BlockPathTypes.DANGER_FIRE && pathType != BlockPathTypes.DAMAGE_OTHER) continue;
            return false;
        }
        return true;
    }

    private void perpendicularSideS(Vec3 dirNorm) {
        double px = -dirNorm.f_82481_;
        double pz = dirNorm.f_82479_;
        double side = this.f_26494_.m_217043_().m_188499_() ? 1.0 : -1.0;
        Vec3 curr = this.f_26494_.m_20182_();
        BlockPos step = BlockPos.m_274561_((double)(curr.f_82479_ + px * side * 1.5), (double)curr.f_82480_, (double)(curr.f_82481_ + pz * side * 1.5));
        if (this.m_6342_(step)) {
            this.m_26519_((double)step.m_123341_() + 0.5, step.m_123342_(), (double)step.m_123343_() + 0.5, 1.1);
        }
    }

    private boolean damp() {
        BlockPos currentPos = this.f_26494_.m_20183_();
        if (!this.f_26495_.m_6425_(currentPos).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            for (int i = 1; i <= 2; ++i) {
                BlockPos land;
                BlockPos edge = currentPos.m_5484_(dir, i);
                if (!this.f_26495_.m_6425_(edge).m_205070_(FluidTags.f_13131_) || !this.f_26495_.m_8055_(edge.m_7494_()).m_60795_() || !this.f_26495_.m_8055_(edge.m_6630_(2)).m_60795_() || !this.f_26495_.m_8055_(land = edge.m_121945_(dir)).m_60795_() || !this.f_26495_.m_8055_(land.m_7495_()).m_280296_() || !this.m_6342_(land)) continue;
                this.m_26519_((double)land.m_123341_() + 0.5, land.m_123342_(), (double)land.m_123343_() + 0.5, Math.max(1.0, this.f_26497_));
                return true;
            }
        }
        return false;
    }
}

