/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.owl.ClientOwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.tileentity.OwlCourierDepotTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.UpdateOwlCourierDepotNamePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class OwlCourierDepotNameScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final OwlCourierDepotTile depot;
    private String name;
    private static final Vector3f TEXT_SCALE = new Vector3f(0.9765628f, 0.9765628f, 0.9765628f);
    private int frame;
    @Nullable
    private TextFieldHelper messageField;
    private final List<String> nameList = List.of("Feathered Express", "Hoot Hollow", "Wise Wing Depot", "Moonbeam Mail", "Starfall Station", "Enchanted Aerie", "Twilight Nest", "Whispering Grove", "Owlpost Oasis", "Nocturnal Nexus", "Mystic Messenger", "Aurora Aviary", "Celestial Couriers", "Eclipse Enclave", "Kappa Kiosk", "MonkaMail", "Wingwhisper Wayhouse", "Hootsuite Hub", "Feathered Flux Depot", "Owlsome Outpost", "Cosmic Courier", "Mystical Mailroom", "Nebula Nook", "Celestial Cache", "Starwhisper Station", "Quill and Quirk", "Arcane Aviary", "Quillcraft Quarters", "Hoooooooo Hoooo", "Owl Be Back");

    public OwlCourierDepotNameScreen(OwlCourierDepotTile depot, Component titleIn) {
        super(titleIn);
        this.f_96541_ = Minecraft.m_91087_();
        List<String> filtered = this.nameList.stream().filter(string -> {
            for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : ClientOwlCourierDepotData.getDepots().entrySet()) {
                if (!entry.getValue().name.equals(string)) continue;
                return false;
            }
            return true;
        }).toList();
        this.name = filtered.size() > 0 ? filtered.get(new Random().nextInt(filtered.size())) : "";
        this.frame = 0;
        this.depot = depot;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone()).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ / 4 + 144, 100, 20).m_253136_());
        this.messageField = new TextFieldHelper(() -> this.name, this::setName, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), string -> this.f_96541_.f_91062_.m_92895_(string) <= this.getMaxTextLineWidth());
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 265) {
            this.messageField.m_169097_();
            return true;
        }
        if (pKeyCode != 264 && pKeyCode != 257 && pKeyCode != 335) {
            return this.messageField.m_95145_(pKeyCode) ? true : super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        this.messageField.m_95193_();
        return true;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        this.messageField.m_95143_(pCodePoint);
        return true;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Lighting.m_84930_();
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        this.renderSign(pGuiGraphics);
        Lighting.m_84931_();
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void offsetSign(GuiGraphics pGuiGraphics) {
        pGuiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, 55.0f, 50.0f);
    }

    private void renderSign(GuiGraphics pGuiGraphics) {
        pGuiGraphics.m_280168_().m_85836_();
        this.offsetSign(pGuiGraphics);
        this.renderMessageText(pGuiGraphics);
        pGuiGraphics.m_280168_().m_85849_();
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }

    public Component m_96636_() {
        return super.m_96636_();
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 140;
    }

    private void onDone() {
        if (!this.name.isEmpty() && this.depot.m_58904_() != null) {
            HexereiPacketHandler.sendToServer(new UpdateOwlCourierDepotNamePacket(GlobalPos.m_122643_((ResourceKey)this.depot.m_58904_().m_46472_(), (BlockPos)this.depot.m_58899_()), this.name));
        }
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderMessageText(GuiGraphics pGuiGraphics) {
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 4.0f);
        pGuiGraphics.m_280168_().m_85841_(TEXT_SCALE.x(), TEXT_SCALE.y(), TEXT_SCALE.z());
        boolean flag = this.frame / 6 % 2 == 0;
        int j = this.messageField.m_95194_();
        int k = this.messageField.m_95197_();
        int l = this.getTextLineHeight() / 2;
        int i1 = this.getTextLineHeight() - l;
        String s = this.name;
        if (s != null) {
            if (this.f_96547_.m_92718_()) {
                s = this.f_96547_.m_92801_(s);
            }
            int k1 = -this.f_96547_.m_92895_(s) / 2;
            pGuiGraphics.m_280056_(this.f_96547_, s, k1, this.getTextLineHeight() - l, 0xAAAAAA, false);
            if (j >= 0 && flag) {
                int l1 = this.f_96547_.m_92895_(s.substring(0, Math.max(Math.min(j, s.length()), 0)));
                int i2 = l1 - this.f_96547_.m_92895_(s) / 2;
                if (j >= s.length()) {
                    pGuiGraphics.m_280056_(this.f_96547_, "_", i2, i1, 0xAAAAAA, false);
                }
            }
        }
        if (s != null && j >= 0) {
            int l3 = this.f_96547_.m_92895_(s.substring(0, Math.max(Math.min(j, s.length()), 0)));
            int i4 = l3 - this.f_96547_.m_92895_(s) / 2;
            if (flag && j < s.length()) {
                pGuiGraphics.m_280509_(i4, i1 - 1, i4 + 1, i1 + this.getTextLineHeight(), -5592406);
            }
            if (k != j) {
                int j4 = Math.min(j, k);
                int j2 = Math.max(j, k);
                int k2 = this.f_96547_.m_92895_(s.substring(0, j4)) - this.f_96547_.m_92895_(s) / 2;
                int l2 = this.f_96547_.m_92895_(s.substring(0, j2)) - this.f_96547_.m_92895_(s) / 2;
                int i3 = Math.min(k2, l2);
                int j3 = Math.max(k2, l2);
                pGuiGraphics.m_285944_(RenderType.m_285783_(), i3, i1, j3, i1 + this.getTextLineHeight(), -16776961);
            }
        }
    }

    public void m_86600_() {
        ++this.frame;
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && this.depot != null && this.depot.m_58899_().m_203193_((Position)this.f_96541_.f_91074_.m_20182_()) < 64.0;
    }

    private void setName(String str) {
        this.name = str;
    }
}

