/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoonBroomParticle
extends TextureSheetParticle {
    protected float scale;
    protected float rotationDir;
    protected float fallingSpeed;

    public MoonBroomParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.f_107204_ = this.f_107231_ = new Random().nextFloat() * (float)Math.PI;
        this.rotationDir = new Random().nextFloat() - 0.5f;
        this.fallingSpeed = new Random().nextFloat();
        this.setScale(0.2f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.m_107250_(scale * 0.5f, scale * 0.5f);
    }

    public void m_5989_() {
        this.f_107204_ = this.f_107231_;
        if (Math.abs(this.f_107216_) > 0.0 && this.f_107213_ != this.f_107210_) {
            this.f_107231_ += 0.3f * this.rotationDir;
        }
        this.f_107216_ -= (double)(0.005f * this.fallingSpeed);
        super.m_5989_();
    }

    public int m_6355_(float pPartialTick) {
        float time = this.f_107208_.m_46942_(0.0f);
        if (time > 0.25f && time < 0.75f && this.f_107208_.m_46941_() == 0 && !this.f_107208_.m_6042_().m_63967_()) {
            return 0xF000F0;
        }
        return super.m_6355_(pPartialTick);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Random rand = new Random();
            float colorOffset = rand.nextFloat() * 0.4f;
            MoonBroomParticle broomParticle = new MoonBroomParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            broomParticle.m_108335_(this.spriteSet);
            broomParticle.m_107253_(0.6f + colorOffset, 0.6f + colorOffset, 0.6f + colorOffset);
            if (this.spriteSet.m_5819_(0, 1).m_247685_().m_135815_().matches("particle/moon_brush_2") || this.spriteSet.m_5819_(0, 1).m_247685_().m_135815_().matches("particle/moon_brush_3") || this.spriteSet.m_5819_(0, 1).m_247685_().m_135815_().matches("particle/moon_brush_4")) {
                broomParticle.f_107225_ += broomParticle.f_107225_ * 3 + 30;
            }
            return broomParticle;
        }
    }
}

