/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CandleItemRenderer;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CandleItem
extends BlockItem
implements DyeableLeatherItem {
    public CandleItem(Block block, Item.Properties properties) {
        super(block, properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)Candle.DISPENSE_ITEM_BEHAVIOR);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        final CustomItemRenderer renderer = this.createItemRenderer();
        if (renderer != null) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return renderer.getRenderer();
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public CustomItemRenderer createItemRenderer() {
        return new CandleItemRenderer();
    }

    public void m_41115_(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("dyeColor", color);
    }

    public static void setColorStatic(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("dyeColor", color);
    }

    public static void setHeight(ItemStack stack, int height) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("height", height);
    }

    public static int getHeight(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compoundtag = stack.m_41784_();
            return compoundtag.m_128425_("height", 99) ? compoundtag.m_128451_("height") : 7;
        }
        return 7;
    }

    public static void setCooldown(ItemStack p_41116_, int p_41117_) {
        p_41116_.m_41784_().m_128405_("cooldown", p_41117_);
    }

    public static int getCooldown(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag compoundtag = stack.m_41783_();
            return compoundtag != null && compoundtag.m_128425_("cooldown", 99) ? compoundtag.m_128451_("cooldown") : 0;
        }
        return 0;
    }

    public static void setLayer(ItemStack stack, String layer, String target) {
        CompoundTag tag = stack.m_41698_(target);
        if (layer != null) {
            tag.m_128359_("layer", layer);
        }
    }

    public static void setLayerFromBlock(ItemStack stack, String layer, String target) {
        CompoundTag tag = stack.m_41698_(target);
        if (layer != null) {
            tag.m_128359_("layer", layer);
            tag.m_128379_("layerFromBlockLocation", true);
        }
    }

    public static void setEffectLocation(ItemStack stack, String effect) {
        CompoundTag tag = stack.m_41784_();
        if (effect != null) {
            tag.m_128359_("effect", effect);
        } else {
            tag.m_128473_("effect");
        }
    }

    public static void setEffectParticle(ItemStack stack, List<String> effectParticle) {
        CompoundTag tag = stack.m_41698_("effectParticle");
        for (int i = 0; i < effectParticle.size(); ++i) {
            if (effectParticle.get(i) != null) {
                tag.m_128359_("particle" + i, effectParticle.get(i));
                continue;
            }
            tag.m_128473_("particle");
        }
    }

    public static String getHerbLayer(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("herb");
        if (tag == null) {
            return null;
        }
        return tag.m_128441_("layer") ? tag.m_128461_("layer") : null;
    }

    public static boolean getLayerFromBlock(ItemStack stack, String target) {
        return CandleItem.getLayerFromBlock(stack.m_41737_(target));
    }

    public static boolean getLayerFromBlock(CompoundTag tag) {
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("layerFromBlockLocation") && tag.m_128471_("layerFromBlockLocation");
    }

    public static String getBaseLayer(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("base");
        return CandleItem.getLayerLoc(tag);
    }

    public static String getGlowLayer(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("glow");
        return CandleItem.getLayerLoc(tag);
    }

    public static String getSwirlLayer(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("swirl");
        return CandleItem.getLayerLoc(tag);
    }

    private static String getLayerLoc(CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        return tag.m_128441_("layer") ? tag.m_128461_("layer") : null;
    }

    public static String getEffectLocation(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41784_().m_128461_("effect");
        }
        return null;
    }

    public static List<String> getEffectParticle(ItemStack stack) {
        if (stack.m_41782_()) {
            ArrayList<String> list = new ArrayList<String>();
            CompoundTag tag = stack.m_41698_("effectParticle");
            for (int i = 0; i < tag.m_128440_(); ++i) {
                list.add(tag.m_128461_("particle" + i));
            }
            return list;
        }
        return null;
    }

    public static int getColorValue(DyeColor color, ItemStack stack) {
        int dyeCol = CandleItem.getColorStatic(stack);
        if (color == null && dyeCol != -1) {
            return dyeCol;
        }
        float[] colors = color.m_41068_();
        int r = (int)(colors[0] * 255.0f);
        int g = (int)(colors[1] * 255.0f);
        int b = (int)(colors[2] * 255.0f);
        return r << 16 | g << 8 | b;
    }

    public static int getColorStatic(ItemStack p_41122_) {
        CompoundTag compoundtag = p_41122_.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 13419416;
    }

    public static int getDyeColorNamed(String name) {
        if (HexereiUtil.getDyeColorNamed(name) != null) {
            float f3 = Hexerei.getClientTicks() / 10.0f * 4.0f % 16.0f / 16.0f;
            DyeColor col1 = HexereiUtil.getDyeColorNamed(name, 0);
            DyeColor col2 = HexereiUtil.getDyeColorNamed(name, 1);
            float[] afloat1 = Sheep.m_29829_((DyeColor)col1);
            float[] afloat2 = Sheep.m_29829_((DyeColor)col2);
            float f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            float f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            float f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            return HexereiUtil.getColorValue(f, f1, f2);
        }
        return 0;
    }

    public static DyeColor getDyeColorNamed(ItemStack stack) {
        return HexereiUtil.getDyeColorNamed(stack.m_41786_().getString());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        return super.m_40576_(context);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hexerei", bus=Mod.EventBusSubscriber.Bus.MOD)
    static class ColorRegisterHandler {
        ColorRegisterHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerCandleColors(RegisterColorHandlersEvent.Item event) {
            ItemHandlerConsumer items = (arg_0, arg_1) -> ((ItemColors)event.getItemColors()).m_92689_(arg_0, arg_1);
            items.register((s, t) -> t == 1 ? CandleItem.getColorValue(CandleItem.getDyeColorNamed(s), s) : -1, (ItemLike)ModItems.CANDLE.get());
        }
    }

    public static interface ItemHandlerConsumer {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

