/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BookBlocks {
    public float x;
    public float y;
    public BlockState blockState;
    public String type;
    public String tag;
    public boolean show_slot;
    public boolean refreshTag = false;
    public TagKey<Block> key;
    List<Component> extra_tooltips;
    List<BookTooltipExtra> extra_tooltips_raw;

    BookBlocks(float x, float y, BlockState blockState, boolean show_slot) {
        this.x = x;
        this.y = y;
        this.tag = "null";
        this.type = "block";
        this.key = null;
        this.blockState = blockState;
        this.show_slot = show_slot;
        this.extra_tooltips = new ArrayList<Component>();
        this.extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
    }

    BookBlocks(float x, float y, BlockState blockState, boolean show_slot, List<Component> extra_tooltips, List<BookTooltipExtra> extra_tooltips_raw) {
        this.x = x;
        this.y = y;
        this.tag = "null";
        this.type = "block";
        this.key = null;
        this.blockState = blockState;
        this.show_slot = show_slot;
        this.extra_tooltips = extra_tooltips;
        this.extra_tooltips_raw = extra_tooltips_raw;
    }

    BookBlocks(float x, float y, String tag, boolean show_slot) {
        this.x = x;
        this.y = y;
        this.tag = tag;
        this.type = "tag";
        this.blockState = Blocks.f_50016_.m_49966_();
        this.show_slot = show_slot;
        this.key = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tag));
        if (ForgeRegistries.BLOCKS.tags() != null) {
            Optional optional = ForgeRegistries.BLOCKS.tags().getTag(this.key).getRandomElement(RandomSource.m_216327_());
            this.blockState = optional.orElse(Blocks.f_50016_).m_49966_();
        }
        this.extra_tooltips = new ArrayList<Component>();
        this.extra_tooltips_raw = new ArrayList<BookTooltipExtra>();
    }

    BookBlocks(float x, float y, String tag, boolean show_slot, List<Component> extra_tooltips, List<BookTooltipExtra> extra_tooltips_raw) {
        this.x = x;
        this.y = y;
        this.tag = tag;
        this.type = "tag";
        this.show_slot = show_slot;
        this.blockState = Blocks.f_50016_.m_49966_();
        this.key = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tag));
        if (ForgeRegistries.BLOCKS.tags() != null) {
            Optional optional = ForgeRegistries.BLOCKS.tags().getTag(this.key).getRandomElement(RandomSource.m_216327_());
            this.blockState = optional.orElse(Blocks.f_50016_).m_49966_();
        }
        this.extra_tooltips = extra_tooltips;
        this.extra_tooltips_raw = extra_tooltips_raw;
    }

    public static BookBlocks deserialize(JsonObject object) throws CommandSyntaxException {
        float x = GsonHelper.m_13820_((JsonObject)object, (String)"x", (float)0.0f);
        float y = GsonHelper.m_13820_((JsonObject)object, (String)"y", (float)0.0f);
        String type = GsonHelper.m_13851_((JsonObject)object, (String)"type", (String)"block");
        boolean show_slot = GsonHelper.m_13855_((JsonObject)object, (String)"show_slot", (boolean)false);
        switch (type) {
            case "block": {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"name")));
                block = block != null ? block : Blocks.f_50016_;
                BlockState state = block.m_49966_();
                JsonArray yourJson = GsonHelper.m_13832_((JsonObject)object, (String)"extra_tooltips", (JsonArray)new JsonArray());
                ArrayList<Component> textComponentsList = new ArrayList<Component>();
                MutableComponent component = Component.m_237115_((String)"");
                ArrayList<BookTooltipExtra> bookTooltipExtraList = new ArrayList<BookTooltipExtra>();
                for (int i = 0; i < yourJson.size(); ++i) {
                    JsonObject extraItemObject = yourJson.get(i).getAsJsonObject();
                    int color = GsonHelper.m_13824_((JsonObject)extraItemObject, (String)"color", (int)0xFFFFFF);
                    String string = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"text", (String)"empty");
                    String string_type = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"type", (String)"append");
                    String hex_color = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"color_hex", (String)"");
                    if (!hex_color.equals("")) {
                        color = (int)Long.parseLong(hex_color, 16);
                    }
                    if (string_type.equals("trail")) {
                        textComponentsList.add((Component)component);
                        component = Component.m_237115_((String)string).m_130948_(Style.f_131099_.m_178520_(color));
                    } else if (string_type.equals("append")) {
                        component.m_7360_().add(Component.m_237115_((String)string).m_130948_(Style.f_131099_.m_178520_(color)));
                    }
                    if (i + 1 >= yourJson.size() && !component.getString().equals("")) {
                        textComponentsList.add((Component)component);
                    }
                    bookTooltipExtraList.add(new BookTooltipExtra(color, hex_color, string, string_type));
                }
                return new BookBlocks(x, y, state, show_slot, textComponentsList, bookTooltipExtraList);
            }
            case "tag": {
                JsonArray yourJson = GsonHelper.m_13832_((JsonObject)object, (String)"extra_tooltips", (JsonArray)new JsonArray());
                ArrayList<Component> textComponentsList = new ArrayList<Component>();
                ArrayList<BookTooltipExtra> bookTooltipExtraList = new ArrayList<BookTooltipExtra>();
                MutableComponent component = Component.m_237115_((String)"");
                for (int i = 0; i < yourJson.size(); ++i) {
                    JsonObject extraItemObject = yourJson.get(i).getAsJsonObject();
                    int color = GsonHelper.m_13824_((JsonObject)extraItemObject, (String)"color", (int)0xFFFFFF);
                    String string = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"text", (String)"empty");
                    String string_type = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"type", (String)"append");
                    String hex_color = GsonHelper.m_13851_((JsonObject)extraItemObject, (String)"color_hex", (String)"");
                    if (!hex_color.equals("")) {
                        color = (int)Long.parseLong(hex_color, 16);
                    }
                    if (string_type.equals("trail")) {
                        textComponentsList.add((Component)component);
                        component = Component.m_237115_((String)string).m_130948_(Style.f_131099_.m_178520_(color));
                    } else if (string_type.equals("append")) {
                        component.m_7360_().add(Component.m_237115_((String)string).m_130948_(Style.f_131099_.m_178520_(color)));
                    }
                    if (i + 1 >= yourJson.size() && !component.getString().equals("")) {
                        textComponentsList.add((Component)component);
                    }
                    bookTooltipExtraList.add(new BookTooltipExtra(color, hex_color, string, string_type));
                }
                return new BookBlocks(x, y, GsonHelper.m_13851_((JsonObject)object, (String)"name", (String)"null"), show_slot, textComponentsList, bookTooltipExtraList);
            }
        }
        return new BookBlocks(x, y, Blocks.f_50016_.m_49966_(), show_slot);
    }
}

