/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityIngredient
implements Predicate<EntityType<?>> {
    public static final EntityIngredient EMPTY = new EntityTypeIngredient();
    public List<EntityType<?>> entities;
    protected int damage = 1;
    private List<EntityInput> display;

    public static EntityIngredient fromTag(TagKey<EntityType<?>> tag, int damage) {
        EntityTagIngredient ingredient = new EntityTagIngredient();
        ingredient.tag = tag;
        ingredient.damage = damage;
        return ingredient;
    }

    public static EntityIngredient fromType(EntityType<?> type, int damage) {
        EntityTypeIngredient ingredient = new EntityTypeIngredient();
        ingredient.entityType = type;
        ingredient.damage = damage;
        return ingredient;
    }

    public static EntityIngredient fromEntity(Entity entity, int damage) {
        EntityTypeIngredient ingredient = new EntityTypeIngredient();
        ingredient.entityType = entity.m_6095_();
        ingredient.damage = damage;
        return ingredient;
    }

    protected abstract boolean testInternal(EntityType<?> var1);

    protected abstract void readInternal(FriendlyByteBuf var1);

    protected abstract void writeInternal(FriendlyByteBuf var1);

    protected abstract void readInternal(JsonObject var1);

    protected abstract void writeInternal(JsonObject var1);

    protected abstract List<EntityType<?>> determineEntities();

    public int getDamage() {
        return this.damage;
    }

    public List<EntityType<?>> getEntities() {
        if (this.entities != null) {
            return this.entities;
        }
        this.entities = this.determineEntities();
        return this.entities;
    }

    @Override
    public boolean test(EntityType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Entity Type cannot be null!");
        }
        return this.testInternal(type);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this instanceof EntityTagIngredient);
        buffer.m_130130_(this.damage);
        this.writeInternal(buffer);
    }

    public static EntityIngredient read(FriendlyByteBuf buffer) {
        boolean isTagIngredient = buffer.readBoolean();
        EntityIngredient ingredient = isTagIngredient ? new EntityTagIngredient() : new EntityTypeIngredient();
        ingredient.damage = buffer.m_130242_();
        ingredient.readInternal(buffer);
        return ingredient;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        this.writeInternal(json);
        json.addProperty("damage", (Number)this.damage);
        return json;
    }

    public static boolean isEntityIngredient(@Nullable JsonElement je) {
        if (je == null || je.isJsonNull()) {
            return false;
        }
        if (!je.isJsonObject()) {
            return false;
        }
        JsonObject json = je.getAsJsonObject();
        if (json.has("tag")) {
            return true;
        }
        return json.has("type");
    }

    public static EntityIngredient deserialize(@Nullable JsonElement je) {
        if (!EntityIngredient.isEntityIngredient(je)) {
            throw new JsonSyntaxException("Invalid entity ingredient: " + String.valueOf(je));
        }
        JsonObject json = je.getAsJsonObject();
        EntityIngredient ingredient = json.has("tag") ? new EntityTagIngredient() : new EntityTypeIngredient();
        ingredient.readInternal(json);
        if (!json.has("damage")) {
            throw new JsonSyntaxException("Entity ingredient has to define a damage");
        }
        ingredient.damage = GsonHelper.m_13927_((JsonObject)json, (String)"damage");
        return ingredient;
    }

    public List<EntityInput> getDisplay() {
        if (this.display == null) {
            this.display = EntityInput.wrap(this.getEntities());
        }
        return this.display;
    }

    public static class EntityTagIngredient
    extends EntityIngredient {
        protected TagKey<EntityType<?>> tag;

        @Override
        public boolean testInternal(EntityType<?> entityType) {
            if (this.tag != null && entityType != null) {
                return entityType.m_204039_(this.tag);
            }
            return false;
        }

        @Override
        protected void readInternal(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            this.entities = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.entities.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(buffer.m_130281_()));
            }
        }

        @Override
        protected void writeInternal(FriendlyByteBuf buffer) {
            List<EntityType<?>> matchingEntities = this.getEntities();
            buffer.m_130130_(matchingEntities.size());
            matchingEntities.forEach(type -> buffer.m_130085_(EntityType.m_20613_((EntityType)type)));
        }

        @Override
        protected void readInternal(JsonObject json) {
            ResourceLocation name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)name);
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("tag", this.tag.f_203868_().toString());
        }

        @Override
        protected List<EntityType<?>> determineEntities() {
            return ForgeRegistries.ENTITY_TYPES.tags().getTag(this.tag).stream().collect(Collectors.toList());
        }
    }

    public static class EntityTypeIngredient
    extends EntityIngredient {
        protected EntityType<?> entityType;

        @Override
        public boolean testInternal(EntityType<?> entityType) {
            return this.entityType.equals(entityType);
        }

        @Override
        protected void readInternal(FriendlyByteBuf buffer) {
            this.entityType = (EntityType)buffer.readRegistryId();
        }

        @Override
        protected void writeInternal(FriendlyByteBuf buffer) {
            buffer.writeRegistryId(ForgeRegistries.ENTITY_TYPES, this.entityType);
        }

        @Override
        protected void readInternal(JsonObject json) {
            this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.get("type").getAsString()));
        }

        @Override
        protected void writeInternal(JsonObject json) {
            json.addProperty("type", EntityType.m_20613_(this.entityType).toString());
        }

        @Override
        protected List<EntityType<?>> determineEntities() {
            return List.of(this.entityType);
        }
    }

    public record EntityInput(EntityType<?> type) {
        public static List<EntityInput> wrap(List<EntityType<?>> types) {
            return types.stream().map(EntityInput::new).toList();
        }
    }
}

