/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.MeltingInventory;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.MeltingSlot;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.FoundryRecipe;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FoundryTank
implements IFluidHandler {
    public List<FluidStack> fluids;
    public int capacity;
    private final CrucibleBlockEntity be;
    protected Consumer<FluidStack> updateCallback;
    private ProcessingRecipe<?> currentRecipe;
    public int processingTime;
    private static final Object BulkAlloyingCacheKey = new Object();

    public FoundryTank(CrucibleBlockEntity be, int capacity, Consumer<FluidStack> updateCallback) {
        this.be = be;
        this.fluids = new ArrayList<FluidStack>();
        this.capacity = capacity;
        this.updateCallback = updateCallback;
        this.processingTime = 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public float getFillState() {
        return (float)this.getFillAmount() / (float)this.capacity;
    }

    public int getFillAmount() {
        int filled = 0;
        for (FluidStack fluid : this.fluids) {
            filled += fluid.getAmount();
        }
        return filled;
    }

    public boolean isFluidValid(@NotNull FluidStack stack) {
        return true;
    }

    public int getTanks() {
        return this.fluids.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(tank);
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        int filled = Math.min(resource.getAmount(), this.capacity - this.getFillAmount());
        if (action.simulate()) {
            return filled;
        }
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(resource)) continue;
            fluid.grow(filled);
            this.updateCallback.accept(fluid);
            return filled;
        }
        resource = resource.copy();
        resource.setAmount(filled);
        this.fluids.add(resource);
        this.updateCallback.accept(resource);
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(resource)) continue;
            return this.drain(fluid, resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.drain(this.fluids.get(0), maxDrain, action);
    }

    public FluidStack drain(FluidStack resource, int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (resource.getAmount() < drained) {
            drained = resource.getAmount();
        }
        FluidStack stack = new FluidStack(resource, drained);
        if (action.execute() && drained > 0) {
            resource.shrink(drained);
            if (resource.isEmpty()) {
                this.fluids.remove(resource);
            }
            this.updateCallback.accept(resource);
        }
        return stack;
    }

    public boolean isEmpty() {
        for (FluidStack fluid : this.fluids) {
            if (fluid.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        ProcessingRecipe<?> recipe = this.getMatchingRecipe();
        if (recipe != null) {
            this.currentRecipe = recipe;
            if (FoundryRecipe.isEnoughHeated(this.be, this.currentRecipe)) {
                for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
                    for (int i = 0; i < this.fluids.size(); ++i) {
                        FluidStack fluid = this.fluids.get(i);
                        if (!fluidIngredient.test(fluid)) continue;
                        fluid.shrink(fluidIngredient.getRequiredAmount());
                        if (!fluid.isEmpty()) continue;
                        this.fluids.remove(fluid);
                    }
                }
                MeltingInventory inv = this.be.foundry.getInventory();
                block2: for (Ingredient ingredient : recipe.m_7527_()) {
                    for (int i = 0; i < inv.getSlots(); ++i) {
                        MeltingSlot slot = inv.getSlot(i);
                        if (!ingredient.test(slot.getStack())) continue;
                        slot.setStack(ItemStack.f_41583_);
                        continue block2;
                    }
                }
                for (FluidStack output : recipe.getFluidResults()) {
                    if (this.fill(output.copy(), IFluidHandler.FluidAction.SIMULATE) < output.getAmount()) continue;
                    this.fill(output.copy(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
            this.currentRecipe = null;
        }
    }

    private ProcessingRecipe<?> getMatchingRecipe() {
        Level level = this.be.m_58904_();
        if (level == null) {
            return null;
        }
        Predicate type = RecipeConditions.isOfType((RecipeType[])new RecipeType[]{CMRecipeTypes.ALLOYING.getType()});
        List<Recipe> recipes = RecipeFinder.get((Object)BulkAlloyingCacheKey, (Level)level, (Predicate)type).stream().filter(r -> FoundryRecipe.bulkMatch(this.be, r)).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).toList();
        if (!recipes.isEmpty()) {
            return (ProcessingRecipe)recipes.get(0);
        }
        return null;
    }

    public CompoundTag serializeNBT(CompoundTag nbt) {
        ListTag tags = new ListTag();
        for (FluidStack fluid : this.fluids) {
            tags.add((Object)fluid.writeToNBT(new CompoundTag()));
        }
        nbt.m_128365_("Tanks", (Tag)tags);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("Tanks", 10);
        this.fluids.clear();
        for (int i = 0; i < list.size(); ++i) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)list.m_128728_(i));
            if (this.fluids.size() <= i) {
                this.fluids.add(fluid);
                continue;
            }
            this.fluids.set(i, fluid);
        }
    }
}

