/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin;

import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinInventory;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinBlock;
import fr.lucreeper74.createmetallurgy.utils.CMLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class FoundryBasinBlockEntity
extends BasinBlockEntity {
    List<IntAttached<FluidStack>> visualizedOutputFluids;

    public FoundryBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory = (BasinInventory)new BasinInventory(3, (BasinBlockEntity)this).withMaxStackSize(9);
        this.outputInventory = new BasinInventory(4, (BasinBlockEntity)this).forbidInsertion().withMaxStackSize(9);
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 4, 1000, true);
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 4, 1000, true).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null)});
        });
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.with((int)10, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)c))));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        compound.m_128365_("VisualizedFluids", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new CompoundTag())));
        this.visualizedOutputFluids.clear();
    }

    public void lazyTick() {
        if (!this.f_58857_.f_46443_) {
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_6630_(2));
        if (!(blockEntity instanceof MechanicalMixerBlockEntity)) {
            this.setAreFluidsMoving(false);
            return;
        }
        MechanicalMixerBlockEntity mixer = (MechanicalMixerBlockEntity)blockEntity;
        this.setAreFluidsMoving(mixer.running && mixer.runningTicks <= 20);
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && !this.outputTank.isEmpty() && this.m_58900_().m_61143_((Property)FoundryBasinBlock.FACING) != Direction.DOWN) {
            this.tryEmptyingWithSpoutput();
        }
        super.tick();
    }

    public void onWrenched(Direction clickedFace) {
        if (clickedFace.m_122434_().m_122478_()) {
            return;
        }
        BlockState blockState = this.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)FoundryBasinBlock.FACING);
        if (facing == clickedFace) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)FoundryBasinBlock.FACING, (Comparable)Direction.DOWN));
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12201_, SoundSource.BLOCKS, 0.5f, 0.5f + Create.RANDOM.nextFloat());
        } else {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)FoundryBasinBlock.FACING, (Comparable)clickedFace));
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12199_, SoundSource.BLOCKS, 0.5f, 0.5f + Create.RANDOM.nextFloat());
        }
    }

    public void tryEmptyingWithSpoutput() {
        IFluidHandler targetTank;
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof FoundryBasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)FoundryBasinBlock.FACING);
        BlockPos output = this.f_58858_.m_7495_().m_121945_(direction);
        BlockEntity be = this.f_58857_.m_7702_(output);
        DirectBeltInputBehaviour directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)output, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour == null || !directBeltInputBehaviour.canInsertFromSide(direction)) {
            return;
        }
        IFluidHandler iFluidHandler = targetTank = be == null ? null : (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse(null);
        if (targetTank == null) {
            return;
        }
        FluidStack fluidInTank = this.outputTank.getPrimaryHandler().getFluid();
        for (boolean simulate : Iterate.trueAndFalse) {
            int fill;
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int n = fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidInTank.copy(), action) : targetTank.fill(fluidInTank.copy(), action);
            if (fill <= 0) break;
            if (simulate) continue;
            this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.withZero((Object)fluidInTank.copy()));
            fluidInTank.shrink(fill);
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public SmartFluidTankBehaviour getOutputTank() {
        return this.outputTank;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CMLang.translate("gui.goggles.foundrybasin_contents", new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            CMLang.text("").add(Component.m_237115_((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(CMLang.text(" x" + stackInSlot.m_41613_()).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CMLang.text("").add(CMLang.fluidName(fluidStack).add(CMLang.text(" ")).style(ChatFormatting.GRAY).add(CMLang.number(fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }
}

