/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.simplyswordsoverhaul.mixin;

import java.util.List;
import net.jrdemiurge.simplyswordsoverhaul.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.api.SimplySwordsAPI;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.custom.RendSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RendSwordItem.class})
public abstract class MixinRendSword
extends UniqueSwordItem {
    public MixinRendSword(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Inject(method={"hurtEnemy"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyHurtEnemyMethod(ItemStack stack, LivingEntity target, LivingEntity attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.enableSoulrenderChanges) {
            return;
        }
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int choose_sound = (int)(Math.random() * 30.0);
            if (choose_sound <= 10) {
                world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_01.get(), target.m_5720_(), 0.4f, 1.5f);
            } else if (choose_sound <= 20) {
                world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_02.get(), target.m_5720_(), 0.4f, 1.5f);
            } else if (choose_sound <= 30) {
                world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_03.get(), target.m_5720_(), 0.4f, 1.5f);
            }
            this.applyDebuff(target);
        }
        cir.setReturnValue((Object)super.m_7579_(stack, target, attacker));
    }

    private void applyDebuff(LivingEntity target) {
        MobEffectInstance unlucky;
        int currentLevel;
        int SlownessMaxLevel = Config.soulrenderMaxSlownessLevel;
        int WeaknessMaxLevel = Config.soulrenderMaxWeaknessLevel;
        int UnluckMaxLevel = Config.soulrenderMaxUnluckLevel;
        if (target.m_21023_(MobEffects.f_19597_)) {
            MobEffectInstance slowness = target.m_21124_(MobEffects.f_19597_);
            currentLevel = slowness.m_19564_();
            if (currentLevel < SlownessMaxLevel - 1) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 500, currentLevel + 1));
                return;
            }
            if (!target.m_21023_(MobEffects.f_19613_)) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 500, 0));
                return;
            }
        } else {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 500, 0));
            return;
        }
        if (target.m_21023_(MobEffects.f_19613_)) {
            MobEffectInstance weakness = target.m_21124_(MobEffects.f_19613_);
            currentLevel = weakness.m_19564_();
            if (currentLevel < WeaknessMaxLevel - 1) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 500, currentLevel + 1));
                return;
            }
            if (!target.m_21023_(MobEffects.f_19590_)) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 500, 0));
                return;
            }
        }
        if (target.m_21023_(MobEffects.f_19590_) && (currentLevel = (unlucky = target.m_21124_(MobEffects.f_19590_)).m_19564_()) < UnluckMaxLevel - 1) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 500, currentLevel + 1));
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyUseMethod(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!Config.enableSoulrenderChanges) {
            return;
        }
        if (!user.m_9236_().m_5776_()) {
            boolean isOffHandItemNotOnCooldown;
            ItemStack offHandItem = user.m_21120_(InteractionHand.OFF_HAND);
            boolean isMainHandUse = hand == InteractionHand.MAIN_HAND;
            boolean bl = isOffHandItemNotOnCooldown = !user.m_36335_().m_41519_(offHandItem.m_41720_());
            if (isMainHandUse && isOffHandItemNotOnCooldown) {
                user.m_36335_().m_41524_(offHandItem.m_41720_(), 4);
            }
            int baseDamage = Config.soulrenderBaseDamage;
            int stackPerStage = Config.soulrenderStacksPerStage;
            double maxHealPercent = Config.soulrenderMaxHealPercent;
            float healMultiplier = (float)Config.soulrenderHealMultiplier;
            int hradius = Config.soulrenderEffectRadius;
            int vradius = hradius / 2;
            int totalEffectLevel = 0;
            boolean hasDebuffedTarget = false;
            double x = user.m_20185_();
            double y = user.m_20186_();
            double z = user.m_20189_();
            ServerLevel sworld = (ServerLevel)world;
            AABB box = new AABB(x - (double)hradius, y - (double)vradius, z - (double)hradius, x + (double)hradius, y + (double)vradius, z + (double)hradius);
            List targets = sworld.m_6443_(LivingEntity.class, box, EntitySelector.f_20403_);
            for (LivingEntity target : targets) {
                if (!HelperMethods.checkFriendlyFire((LivingEntity)target, (LivingEntity)user)) continue;
                int debuffSum = 0;
                if (target.m_21023_(MobEffects.f_19597_)) {
                    debuffSum += target.m_21124_(MobEffects.f_19597_).m_19564_() + 1;
                    target.m_21195_(MobEffects.f_19597_);
                }
                if (target.m_21023_(MobEffects.f_19613_)) {
                    debuffSum += target.m_21124_(MobEffects.f_19613_).m_19564_() + 1;
                    target.m_21195_(MobEffects.f_19613_);
                }
                if (target.m_21023_(MobEffects.f_19590_)) {
                    debuffSum += target.m_21124_(MobEffects.f_19590_).m_19564_() + 1;
                    target.m_21195_(MobEffects.f_19590_);
                }
                if (debuffSum <= 0) continue;
                hasDebuffedTarget = true;
                totalEffectLevel += debuffSum;
                int damage = 0;
                int remainingLevels = debuffSum;
                int stage = baseDamage;
                while (remainingLevels > 0) {
                    int levelsInStage = Math.min(stackPerStage, remainingLevels);
                    damage += levelsInStage * stage;
                    remainingLevels -= levelsInStage;
                    ++stage;
                }
                target.f_19802_ = 0;
                target.m_6469_(user.m_269291_().m_269104_((Entity)user, (Entity)user), (float)damage);
                world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_SPELL.get(), target.m_5720_(), 0.5f, 2.0f);
            }
            if (hasDebuffedTarget) {
                int healAmount = (int)((float)totalEffectLevel * healMultiplier);
                float maxHeal = user.m_21233_() * (float)maxHealPercent;
                user.m_5634_(Math.min((float)healAmount, maxHeal));
            }
        }
        cir.setReturnValue((Object)super.m_7203_(world, user, hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyTooltip(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext, CallbackInfo ci) {
        if (!Config.enableSoulrenderChanges) {
            return;
        }
        ci.cancel();
        int baseDamage = Config.soulrenderBaseDamage;
        int stackPerStage = Config.soulrenderStacksPerStage;
        double maxHealPercent = Config.soulrenderMaxHealPercent * 100.0;
        float healMultiplier = (float)Config.soulrenderHealMultiplier;
        if (Screen.m_96639_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.rendsworditem").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
        } else if (Screen.m_96638_()) {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.rendsworditem").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            translatedText = Component.m_237110_((String)"tooltip.simply_swords_overhaul.rendsworditem_shift", (Object[])new Object[]{baseDamage, stackPerStage, baseDamage + 1, stackPerStage, baseDamage + 2, Float.valueOf(healMultiplier), maxHealPercent}).getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            String translatedText = Component.m_237115_((String)"tooltip.simply_swords_overhaul.rendsworditem").getString();
            for (String line : translatedText.split("\n")) {
                tooltip.add((Component)Component.m_237113_((String)line));
            }
            SimplySwordsAPI.appendTooltipGemSocketLogic((ItemStack)itemStack, tooltip);
            if (!tooltip.get(tooltip.size() - 1).getString().equals(Component.m_237115_((String)"item.simplyswords.common.showtooltip").getString())) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.simply_swords_overhaul.shift"));
        }
    }
}

