/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.init;

import alexthw.not_enough_glyphs.common.spell.TrailingProjectile;
import alexthw.not_enough_glyphs.common.spellbinder.SpellBinder;
import alexthw.not_enough_glyphs.common.spellbinder.SpellBinderContainer;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import java.util.function.Function;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"not_enough_glyphs");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"not_enough_glyphs");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"not_enough_glyphs");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"not_enough_glyphs");
    public static final RegistryObject<EntityType<TrailingProjectile>> TRAILING_PROJECTILE;
    public static final RegistryObject<Attribute> MANA_DISCOUNT;
    public static final RegistryObject<MenuType<SpellBinderContainer>> SPELL_HOLDER;
    public static final RegistryObject<Item> SPELL_BINDER;

    static <T extends Entity> RegistryObject<EntityType<T>> addEntity(String name, float width, float height, boolean fire, boolean noSave, EntityType.EntityFactory<T> factory, MobCategory kind) {
        return ENTITIES.register(name, () -> {
            EntityType.Builder builder = EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)kind).setTrackingRange(32).m_20699_(width, height);
            if (noSave) {
                builder.m_20716_();
            }
            if (fire) {
                builder.m_20719_();
            }
            return builder.m_20712_("not_enough_glyphs:" + name);
        });
    }

    public static void init(IEventBus modbus) {
        ITEMS.register(modbus);
        ENTITIES.register(modbus);
        CONTAINERS.register(modbus);
        ATTRIBUTES.register(modbus);
        modbus.addListener(event -> {
            if (event.getTab() == CreativeTabRegistry.BLOCKS.get()) {
                for (RegistryObject item : ITEMS.getEntries()) {
                    event.m_246326_((ItemLike)item.get());
                }
            }
        });
        modbus.addListener(Registry::modifyEntityAttributes);
    }

    public static RegistryObject<Attribute> registerAttribute(String name, Function<String, Attribute> attribute) {
        return ATTRIBUTES.register(name, () -> (Attribute)attribute.apply(name));
    }

    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().stream().filter(e -> e == EntityType.f_20532_).forEach(e -> ATTRIBUTES.getEntries().forEach(v -> event.add(e, (Attribute)v.get())));
    }

    static {
        MANA_DISCOUNT = Registry.registerAttribute("not_enough_glyphs.perk.mana_discount", id -> new RangedAttribute(id, 0.0, 0.0, Double.MAX_VALUE).m_22084_(true));
        TRAILING_PROJECTILE = Registry.addEntity("trail", 0.5f, 0.5f, true, true, TrailingProjectile::new, MobCategory.MISC);
        SPELL_BINDER = ITEMS.register("spell_binder", () -> new SpellBinder(new Item.Properties().m_41487_(1)));
        SPELL_HOLDER = CONTAINERS.register("spell_holder", () -> IForgeMenuType.create((id, inv, extraData) -> {
            boolean mainHand = extraData.readBoolean();
            ItemStack stack = inv.f_35978_.m_21120_(mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            return new SpellBinderContainer(id, inv, stack);
        }));
    }
}

