/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.spellbinder;

import alexthw.not_enough_glyphs.api.ThreadwiseSpellResolver;
import alexthw.not_enough_glyphs.client.SpellBinderRenderer;
import alexthw.not_enough_glyphs.common.network.OpenSpellBinderPacket;
import alexthw.not_enough_glyphs.common.network.PacketSetBinderMode;
import alexthw.not_enough_glyphs.common.spell.BulldozeThread;
import alexthw.not_enough_glyphs.common.spell.RandomPerk;
import alexthw.not_enough_glyphs.common.spellbinder.SpellBinderContainer;
import alexthw.not_enough_glyphs.common.spellbinder.SpellItemInventory;
import alexthw.not_enough_glyphs.init.Networking;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.setup.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpellBinder
extends Item
implements ICasterTool,
IDyeable,
IRadialProvider,
ISpellModifierItem,
GeoItem {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellBinderRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    @Nullable
    public static IPerkHolder<ItemStack> getHolderForPerkHands(IPerk perk, @NotNull LivingEntity entity) {
        IPerkHolder highestHolder = null;
        int maxCount = 0;
        for (ItemStack stack : entity.m_6167_()) {
            IPerkHolder holder = PerkUtil.getPerkHolder((ItemStack)stack);
            if (holder == null) continue;
            for (PerkInstance instance : holder.getPerkInstances()) {
                if (instance.getPerk() != perk) continue;
                maxCount = Math.max(maxCount, instance.getSlot().value);
                highestHolder = holder;
            }
        }
        return highestHolder;
    }

    public ISpellCaster getSpellCaster() {
        return new SpellBook.BookCaster(new CompoundTag());
    }

    public boolean canQuickCast() {
        return true;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack pStack) {
        ISpellCaster caster = this.getSpellCaster(pStack);
        String name = caster.getSpellName(caster.getCurrentSlot());
        if (name.isEmpty()) {
            return super.m_7626_(pStack);
        }
        return Component.m_237113_((String)(super.m_7626_(pStack).getString() + "(" + name + ")"));
    }

    public ISpellCaster getSpellCaster(CompoundTag tag) {
        return new SpellBook.BookCaster(tag);
    }

    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new SpellBook.BookCaster(stack){

            public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
                return new ThreadwiseSpellResolver(context);
            }
        };
    }

    public SpellBinder(Item.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InventoryCapability(stack);
    }

    public void openContainer(Level level, Player player, ItemStack bag) {
        if (!level.f_46443_) {
            SimpleMenuProvider container = new SimpleMenuProvider((w, p, pl) -> new SpellBinderContainer(w, p, bag), bag.m_41786_());
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)container, b -> b.writeBoolean(SpellBinder.getBookHand(player) == InteractionHand.MAIN_HAND));
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        ISpellCaster caster = this.getSpellCaster(stack);
        return caster.castSpell(pLevel, (LivingEntity)pPlayer, pUsedHand, (Component)Component.m_237115_((String)"ars_nouveau.invalid_spell"));
    }

    public static SpellItemInventory getInventory(ItemStack stack) {
        return new SpellItemInventory(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onOpenBookMenuKeyPressed(ItemStack stack, Player player) {
        InteractionHand hand = SpellBinder.getBookHand(player);
        if (hand != null) {
            Networking.fxChannel.send(PacketDistributor.SERVER.noArg(), (Object)new OpenSpellBinderPacket(hand));
        }
    }

    @Nullable
    public static InteractionHand getBookHand(Player playerEntity) {
        ItemStack mainStack = playerEntity.m_21205_();
        ItemStack offStack = playerEntity.m_21206_();
        return mainStack.m_41720_() instanceof SpellBinder ? InteractionHand.MAIN_HAND : (offStack.m_41720_() instanceof SpellBinder ? InteractionHand.OFF_HAND : null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        Minecraft.m_91087_().m_91152_((Screen)new GuiRadialMenu(this.getRadialMenuProviderForSpellpart(stack)));
    }

    public RadialMenu<AbstractSpellPart> getRadialMenuProviderForSpellpart(ItemStack itemStack) {
        return new RadialMenu(slot -> {
            SpellBook.BookCaster caster = new SpellBook.BookCaster(itemStack);
            caster.setCurrentSlot(slot);
            Networking.fxChannel.sendToServer((Object)new PacketSetBinderMode(itemStack.m_41783_()));
        }, this.getRadialMenuSlotsForSpellpart(itemStack), RenderUtils::drawSpellPart, 0);
    }

    public List<RadialMenuSlot<AbstractSpellPart>> getRadialMenuSlotsForSpellpart(ItemStack itemStack) {
        SpellBook.BookCaster spellCaster = new SpellBook.BookCaster(itemStack);
        ArrayList<RadialMenuSlot<AbstractSpellPart>> radialMenuSlots = new ArrayList<RadialMenuSlot<AbstractSpellPart>>();
        for (int i = 0; i < spellCaster.getMaxSlots(); ++i) {
            Spell spell = spellCaster.getSpell(i);
            AbstractSpellPart primaryIcon = null;
            ArrayList<AbstractSpellPart> secondaryIcons = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart p : spell.recipe) {
                if (p instanceof AbstractCastMethod) {
                    secondaryIcons.add(p);
                }
                if (!(p instanceof AbstractEffect)) continue;
                primaryIcon = p;
                break;
            }
            radialMenuSlots.add((RadialMenuSlot<AbstractSpellPart>)new RadialMenuSlot(spellCaster.getSpellName(i), primaryIcon, secondaryIcons));
        }
        return radialMenuSlots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ISpellCaster caster = this.getSpellCaster(stack);
        if (!((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() || Screen.m_96638_() || caster.isSpellHidden() || caster.getSpell().isEmpty()) {
            this.getInformation(stack, world, tooltip, flag);
        }
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.spell_book.select", (Object[])new Object[]{KeyMapping.m_90842_((String)ModKeyBindings.OPEN_RADIAL_HUD.m_90860_()).get()}));
        tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.spell_binder.open", (Object[])new Object[]{KeyMapping.m_90842_((String)ModKeyBindings.OPEN_BOOK.m_90860_()).get()}));
        IPerkProvider perkProvider = PerkRegistry.getPerkProvider((Item)stack.m_41720_());
        if (perkProvider != null) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.book_slot").m_130940_(ChatFormatting.GOLD));
            perkProvider.getPerkHolder((Object)stack).appendPerkTooltip(tooltip, (Object)stack);
        }
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (shooter != null) {
            IPerkHolder<ItemStack> slowPerk = SpellBinder.getHolderForPerkHands((IPerk)BulldozeThread.INSTANCE, shooter);
            if (slowPerk != null) {
                builder.addAccelerationModifier(-1.5f * (float)(slowPerk.getTier() + 1));
            }
            if (SpellBinder.getHolderForPerkHands((IPerk)RandomPerk.INSTANCE, shooter) != null) {
                return RandomPerk.applyItemModifiers(builder, world);
            }
        }
        return builder;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        IPerkHolder perkHolder;
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.getAttributeModifiers(pEquipmentSlot, stack));
        if (pEquipmentSlot.m_20743_() == EquipmentSlot.Type.HAND && (perkHolder = PerkUtil.getPerkHolder((ItemStack)stack)) != null) {
            for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
                IPerk perk = perkInstance.getPerk();
                attributes.putAll(perk.getModifiers(pEquipmentSlot, stack, 2 * perkInstance.getSlot().value));
            }
        }
        return attributes.build();
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        ISpellCaster caster = this.getSpellCaster(pStack);
        if (((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.m_96638_() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }

    private static class InventoryCapability
    implements ICapabilityProvider {
        private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> new InvWrapper((Container)SpellBinder.getInventory(stack)));

        public InventoryCapability(ItemStack stack) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(capability, this.opt);
        }
    }
}

