/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.propagators;

import alexthw.not_enough_glyphs.api.IPropagator;
import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import alexthw.not_enough_glyphs.common.glyphs.EffectChaining;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class PropagatePlane
extends AbstractEffect
implements IPropagator {
    public static final PropagatePlane INSTANCE = new PropagatePlane();

    private PropagatePlane() {
        super(CompatRL.neg("propagate_plane"), "Propagate Plane");
    }

    protected void addDefaultInvalidCombos(Set<ResourceLocation> defaults) {
        defaults.addAll(Stream.of(new AbstractEffect[]{EffectWall.INSTANCE, EffectLinger.INSTANCE, EffectBurst.INSTANCE, EffectChaining.INSTANCE}).map(AbstractSpellPart::getRegistryName).toList());
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockHitResult blockHitResult = new BlockHitResult(rayTraceResult.m_82450_(), Direction.DOWN, rayTraceResult.m_82443_().m_20097_(), rayTraceResult.m_82443_() == shooter);
        this.copyResolver((HitResult)blockHitResult, world, shooter, spellStats, spellContext, resolver);
    }

    @Override
    public void propagate(Level world, HitResult hitResult, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        double width = 1.0 + stats.getAoeMultiplier();
        int height = stats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (this.isRealPlayer((Entity)shooter)) {
            blockHitResult = new BlockHitResult(blockHitResult.m_82450_(), blockHitResult.m_82434_().m_122424_(), blockHitResult.m_82425_(), blockHitResult.m_82436_());
        }
        BlockPos center = blockHitResult.m_82425_();
        if (stats.isSensitive()) {
            this.circle(world, resolver, shooter, blockHitResult, center, width, height, stats.hasBuff((AbstractAugment)AugmentDampen.INSTANCE));
        } else {
            PropagatePlane.cube(world, resolver, shooter, blockHitResult, center, width, height, stats.hasBuff((AbstractAugment)AugmentDampen.INSTANCE));
        }
    }

    private void circle(Level world, SpellResolver resolver, LivingEntity shooter, BlockHitResult blockHitResult, BlockPos center, double width, int height, boolean isHollow) {
        int anchor;
        int radius = (int)width;
        anchor = switch (blockHitResult.m_82434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST, Direction.WEST -> anchor = center.m_123341_();
            case Direction.NORTH, Direction.SOUTH -> anchor = center.m_123343_();
            case Direction.UP, Direction.DOWN -> anchor = center.m_123342_();
        };
        for (BlockPos pos : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)center, (BlockHitResult)blockHitResult, (double)(width * 2.0), (int)height)) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            double distance = BlockUtil.distanceFromCenter((BlockPos)center, (BlockPos)(switch (blockHitResult.m_82434_()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.EAST, Direction.WEST -> new BlockPos(center.m_123341_(), y, z);
                case Direction.UP, Direction.DOWN -> new BlockPos(x, center.m_123342_(), z);
                case Direction.NORTH, Direction.SOUTH -> new BlockPos(x, y, center.m_123343_());
            }));
            if (isHollow) {
                if (!(distance <= (double)radius + 0.5) || !(distance >= (double)radius - 0.5)) continue;
                resolver.onResolveEffect(world, (HitResult)new BlockHitResult(new Vec3((double)x, (double)y, (double)z), !blockHitResult.m_82436_() ? blockHitResult.m_82434_().m_122424_() : blockHitResult.m_82434_(), BlockPos.m_274561_((double)x, (double)y, (double)z), blockHitResult.m_82436_()));
                continue;
            }
            if (!(distance <= (double)radius)) continue;
            resolver.onResolveEffect(world, (HitResult)new BlockHitResult(new Vec3((double)x, (double)y, (double)z), !blockHitResult.m_82436_() ? blockHitResult.m_82434_().m_122424_() : blockHitResult.m_82434_(), BlockPos.m_274561_((double)x, (double)y, (double)z), blockHitResult.m_82436_()));
        }
    }

    private static void cube(Level world, SpellResolver resolver, LivingEntity shooter, BlockHitResult blockHitResult, BlockPos center, double width, int height, boolean isHollow) {
        Direction.Axis axis;
        int maxY;
        int minY;
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        if (isHollow) {
            width += width % 2.0;
        }
        switch (blockHitResult.m_82434_()) {
            case EAST: 
            case WEST: {
                minX = center.m_123341_();
                maxX = center.m_123341_() + height;
                minZ = (int)((double)center.m_123343_() - width / 2.0);
                maxZ = (int)((double)center.m_123343_() + width / 2.0);
                minY = (int)((double)center.m_123342_() - width / 2.0);
                maxY = (int)((double)center.m_123342_() + width / 2.0);
                axis = Direction.Axis.X;
                break;
            }
            case NORTH: 
            case SOUTH: {
                minX = (int)((double)center.m_123341_() - width / 2.0);
                maxX = (int)((double)center.m_123341_() + width / 2.0);
                minZ = center.m_123343_();
                maxZ = center.m_123343_() + height;
                minY = (int)((double)center.m_123342_() - width / 2.0);
                maxY = (int)((double)center.m_123342_() + width / 2.0);
                axis = Direction.Axis.Z;
                break;
            }
            case UP: 
            case DOWN: {
                minX = (int)((double)center.m_123341_() - width / 2.0);
                maxX = (int)((double)center.m_123341_() + width / 2.0);
                minZ = (int)((double)center.m_123343_() - width / 2.0);
                maxZ = (int)((double)center.m_123343_() + width / 2.0);
                minY = center.m_123342_();
                maxY = center.m_123342_() + height;
                axis = Direction.Axis.Y;
                break;
            }
            default: {
                return;
            }
        }
        block10: for (BlockPos p : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)center, (BlockHitResult)blockHitResult, (double)width, (int)height)) {
            if (isHollow) {
                switch (axis) {
                    case X: {
                        if (p.m_123343_() == minZ || p.m_123343_() == maxZ || p.m_123342_() == minY || p.m_123342_() == maxY) break;
                        continue block10;
                    }
                    case Y: {
                        if (p.m_123341_() == minX || p.m_123341_() == maxX || p.m_123343_() == minZ || p.m_123343_() == maxZ) break;
                        continue block10;
                    }
                    case Z: {
                        if (p.m_123341_() == minX || p.m_123341_() == maxX || p.m_123342_() == minY || p.m_123342_() == maxY) break;
                        continue block10;
                    }
                }
            }
            resolver.onResolveEffect(world, (HitResult)new BlockHitResult(p.m_252807_(), !blockHitResult.m_82436_() ? blockHitResult.m_82434_().m_122424_() : blockHitResult.m_82434_(), p, blockHitResult.m_82436_()));
        }
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, 1);
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public Integer getTypeIndex() {
        return 8;
    }

    protected int getDefaultManaCost() {
        return 200;
    }

    protected void addAugmentCostOverrides(Map<ResourceLocation, Integer> defaults) {
        super.addAugmentCostOverrides(defaults);
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 100);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentDampen.INSTANCE, AugmentSensitive.INSTANCE});
    }
}

