/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class EffectFlatten
extends AbstractEffect
implements IDamageEffect {
    public static final EffectFlatten INSTANCE = new EffectFlatten("flatten", "Flatten");

    private EffectFlatten(String tag, String description) {
        super(CompatRL.omega(tag), description);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        for (BlockPos p : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)rayTraceResult.m_82425_(), (BlockHitResult)rayTraceResult, (double)spellStats.getAoeMultiplier(), (int)spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE))) {
            this.doFlat(p, rayTraceResult, world, spellStats);
        }
    }

    private boolean dupeCheck(Level world, BlockPos pos) {
        BlockEntity be = world.m_7702_(pos);
        return be != null && (world.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || be instanceof Container);
    }

    public void doFlat(BlockPos p, BlockHitResult rayTraceResult, Level world, SpellStats spellStats) {
        ItemStack shovel = new ItemStack((ItemLike)Items.f_42389_);
        this.applyEnchantments(spellStats, shovel);
        ANFakePlayer entity = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world));
        entity.m_21008_(InteractionHand.MAIN_HAND, shovel);
        if (this.dupeCheck(world, p)) {
            return;
        }
        entity.m_6034_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_());
        world.m_8055_(p).m_60664_(world, (Player)entity, InteractionHand.MAIN_HAND, rayTraceResult);
        shovel.m_41661_(new UseOnContext((Player)entity, InteractionHand.MAIN_HAND, rayTraceResult));
    }

    public void onResolveEntity(@NotNull EntityHitResult rayTraceResult, @NotNull Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.m_82443_().m_20097_();
        BlockState block = world.m_8055_(pos);
        float tier = block.m_60800_((BlockGetter)world, pos);
        if (tier < 0.0f) {
            tier = 50.0f;
        }
        if ((tier = (float)Math.sqrt(tier) * 4.0f) > 10.0f) {
            tier = 10.0f + (tier - 10.0f) / 4.0f;
        }
        float damage = (float)((double)(0.165f * tier) * (spellStats.getAmpMultiplier() + 1.0) * 3.5);
        damage = Mth.m_14036_((float)damage, (float)0.5f, (float)500.0f);
        this.attemptDamage(world, shooter, spellStats, spellContext, resolver, rayTraceResult.m_82443_(), this.buildDamageSource(world, shooter), damage);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 3.0);
        this.addAmpConfig(builder, 1.0);
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentFortune.INSTANCE});
    }

    public String getBookDescription() {
        return "Flattens the target against the block below them, doing damage based on the hardness. If used on blocks it will simulate the use of a shovel on it.";
    }

    public int getDefaultManaCost() {
        return 30;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH});
    }
}

