/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.levelgen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Creepie;
import com.teamabnormals.savage_and_ravage.common.entity.monster.Griefer;
import com.teamabnormals.savage_and_ravage.core.registry.SRBlocks;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.fml.ModList;

public class EnclosureFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] horizontalDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
    private BlockPos originalStartPos;

    public EnclosureFeature(Codec<NoneFeatureConfiguration> featureConfigCodec) {
        super(featureConfigCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        int minY = origin.m_123342_() - (4 + random.m_188503_(2));
        this.originalStartPos = origin;
        if ((origin = this.findSuitablePosition(level, origin, minY, random)) != null) {
            Griefer griefer;
            ArrayList<BlockPos> holePositions = new ArrayList<BlockPos>();
            ArrayList<BlockPos> edgePositions = new ArrayList<BlockPos>();
            holePositions.add(origin);
            for (Direction dir : horizontalDirections) {
                edgePositions.add(origin.m_121945_(dir));
            }
            for (int i = 0; i <= 5 + random.m_188503_(5); ++i) {
                edgePositions = this.expandHole(edgePositions, holePositions, origin, level, random);
            }
            if (holePositions.size() <= 1) {
                return false;
            }
            this.generateEdges(edgePositions, level, random);
            ArrayList<BlockPos> outlinePositions = this.findOutlines(edgePositions, holePositions, level);
            this.generateHole(holePositions, minY, level, random);
            ArrayList<BlockPos> clearOutlinePositions = this.generateFences(outlinePositions, level, random);
            for (BlockPos outlinePos : outlinePositions) {
                this.fixFenceConnections(level, outlinePos);
            }
            if (!clearOutlinePositions.isEmpty() && (griefer = (Griefer)((EntityType)SREntityTypes.GRIEFER.get()).m_20615_((Level)level.m_6018_())) != null) {
                BlockPos.MutableBlockPos grieferPos = clearOutlinePositions.get(random.m_188503_(clearOutlinePositions.size())).m_122032_();
                griefer.m_7678_(grieferPos.m_123341_(), grieferPos.m_123342_(), grieferPos.m_123343_(), 0.0f, 0.0f);
                griefer.m_21530_();
                griefer.m_6518_((ServerLevelAccessor)level, level.m_6436_((BlockPos)grieferPos), MobSpawnType.CHUNK_GENERATION, null, null);
                level.m_7967_((Entity)griefer);
            }
            this.generateDecorations(this.getDecorationStarts(outlinePositions, edgePositions, holePositions, level), level, random);
            return true;
        }
        return false;
    }

    private BlockPos findSuitablePosition(WorldGenLevel reader, BlockPos centerPos, int minY, RandomSource rand) {
        BlockPos.MutableBlockPos pos = centerPos.m_122032_();
        ArrayList<BlockPos.MutableBlockPos> suitablePositions = new ArrayList<BlockPos.MutableBlockPos>();
        for (int bigX = centerPos.m_123341_() - 3; bigX < centerPos.m_123341_() + 3; ++bigX) {
            for (int bigZ = centerPos.m_123343_() - 3; bigZ < centerPos.m_123343_() + 3; ++bigZ) {
                boolean areaClear = true;
                for (int x = bigX - 4; x <= bigX + 4; ++x) {
                    for (int z = bigZ - 4; z <= bigZ + 4; ++z) {
                        for (int y = minY; y <= centerPos.m_123342_() + 1; ++y) {
                            pos.m_122178_(x, y, z);
                            if (y >= centerPos.m_123342_() != reader.m_8055_((BlockPos)pos).m_60804_((BlockGetter)reader, (BlockPos)pos) && Math.abs(this.originalStartPos.m_123341_() - pos.m_123341_()) <= 11 && Math.abs(this.originalStartPos.m_123343_() - pos.m_123343_()) <= 11) continue;
                            areaClear = false;
                        }
                    }
                }
                if (!areaClear) continue;
                pos.m_122178_(bigX, centerPos.m_123342_(), bigZ);
                suitablePositions.add(pos);
            }
        }
        return !suitablePositions.isEmpty() ? (BlockPos)suitablePositions.get(rand.m_188503_(suitablePositions.size())) : null;
    }

    private boolean isSurfacePositionClear(WorldGenLevel reader, BlockPos pos) {
        if (Math.abs(this.originalStartPos.m_123341_() - pos.m_123341_()) < 12 && Math.abs(this.originalStartPos.m_123343_() - pos.m_123343_()) < 12 && !reader.m_8055_(pos).m_60804_((BlockGetter)reader, pos)) {
            return reader.m_8055_(pos.m_121945_(Direction.DOWN)).m_60804_((BlockGetter)reader, pos.m_121945_(Direction.DOWN));
        }
        return false;
    }

    private ArrayList<BlockPos> expandHole(ArrayList<BlockPos> edgePositions, ArrayList<BlockPos> holePositions, BlockPos centerPos, WorldGenLevel reader, RandomSource rand) {
        ArrayList<BlockPos> newEdgePositions = new ArrayList<BlockPos>(edgePositions);
        for (BlockPos edgePos : edgePositions) {
            if (!((double)rand.m_188503_(49) > edgePos.m_123331_((Vec3i)centerPos))) continue;
            ArrayList<BlockPos> validPotentialPositions = new ArrayList<BlockPos>();
            boolean hasHoleNeighbor = false;
            boolean isNothingBlocking = true;
            for (Direction dir : horizontalDirections) {
                this.currentPos.m_122190_((Vec3i)edgePos.m_121945_(dir).m_122032_());
                if (!holePositions.contains(this.currentPos)) {
                    if (edgePositions.contains(this.currentPos)) continue;
                    if (this.isSurfacePositionClear(reader, (BlockPos)this.currentPos)) {
                        validPotentialPositions.add(this.currentPos.m_7949_());
                        continue;
                    }
                    isNothingBlocking = false;
                    break;
                }
                hasHoleNeighbor = true;
            }
            if (!isNothingBlocking) continue;
            if (hasHoleNeighbor) {
                if (validPotentialPositions.size() == 0) {
                    holePositions.add(edgePos);
                    newEdgePositions.remove(edgePos);
                    continue;
                }
                if (!(rand.m_188501_() < 1.0f / ((float)validPotentialPositions.size() + 1.0f))) continue;
                newEdgePositions.addAll(validPotentialPositions);
                newEdgePositions.remove(edgePos);
                holePositions.add(edgePos);
                continue;
            }
            newEdgePositions.remove(edgePos);
        }
        return newEdgePositions;
    }

    private void generateEdges(ArrayList<BlockPos> edgePositions, WorldGenLevel reader, RandomSource rand) {
        for (BlockPos edgePos : edgePositions) {
            if (!(rand.m_188501_() < 0.6f)) continue;
            reader.m_7731_(edgePos.m_121945_(Direction.DOWN), Blocks.f_50016_.m_49966_(), 3);
            reader.m_7731_(edgePos, Blocks.f_50016_.m_49966_(), 3);
            reader.m_7731_(edgePos.m_121945_(Direction.UP), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private ArrayList<BlockPos> findOutlines(ArrayList<BlockPos> edgePositions, ArrayList<BlockPos> holePositions, WorldGenLevel reader) {
        ArrayList<BlockPos> outlinePositions = new ArrayList<BlockPos>();
        for (BlockPos edgePos : edgePositions) {
            for (Direction dir : horizontalDirections) {
                this.currentPos.m_122190_((Vec3i)edgePos.m_121945_(dir));
                if (!(edgePositions.contains(this.currentPos) || holePositions.contains(this.currentPos) || reader.m_8055_((BlockPos)this.currentPos).m_60804_((BlockGetter)reader, (BlockPos)this.currentPos))) {
                    outlinePositions.add(this.currentPos.m_7949_());
                }
                this.currentPos.m_122190_((Vec3i)this.currentPos.m_121945_(dir.m_122427_()));
                if (edgePositions.contains(this.currentPos) || holePositions.contains(this.currentPos) || reader.m_8055_((BlockPos)this.currentPos).m_60804_((BlockGetter)reader, (BlockPos)this.currentPos)) continue;
                outlinePositions.add(this.currentPos.m_7949_());
            }
        }
        return outlinePositions;
    }

    private void generateHole(ArrayList<BlockPos> holePositions, int minY, WorldGenLevel reader, RandomSource rand) {
        for (BlockPos holePos : holePositions) {
            Mob entity;
            this.currentPos.m_122190_((Vec3i)holePos);
            for (int i = minY; i < holePos.m_123342_() + 2; ++i) {
                this.currentPos.m_142448_(i);
                if (i == minY) {
                    reader.m_7731_((BlockPos)this.currentPos, Blocks.f_50546_.m_49966_(), 3);
                    continue;
                }
                if (i == minY + 1) {
                    reader.m_7731_((BlockPos)this.currentPos, rand.m_188501_() < 0.4f ? (rand.m_188501_() > 0.3f ? Blocks.f_50034_.m_49966_() : Blocks.f_50036_.m_49966_()) : Blocks.f_50016_.m_49966_(), 3);
                    continue;
                }
                reader.m_7731_((BlockPos)this.currentPos, Blocks.f_50016_.m_49966_(), 3);
            }
            if (!(rand.m_188501_() < 0.3f) || (entity = rand.m_188501_() < 0.5f ? (Mob)EntityType.f_20558_.m_20615_((Level)reader.m_6018_()) : (Mob)((EntityType)SREntityTypes.CREEPIE.get()).m_20615_((Level)reader.m_6018_())) == null) continue;
            entity.m_7678_((double)this.currentPos.m_123341_() + 0.5, (double)(minY + 1), (double)this.currentPos.m_123343_() + 0.5, 0.0f, 0.0f);
            entity.m_21530_();
            if (entity instanceof Creepie) {
                ((Creepie)entity).attackPlayersOnly = true;
            }
            entity.m_6518_((ServerLevelAccessor)reader, reader.m_6436_((BlockPos)this.currentPos), MobSpawnType.CHUNK_GENERATION, null, null);
            reader.m_7967_((Entity)entity);
        }
    }

    private ArrayList<BlockPos> generateFences(ArrayList<BlockPos> outlinePositions, WorldGenLevel reader, RandomSource rand) {
        BlockPos.MutableBlockPos secondFencePos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> nonFenceOutlines = new ArrayList<BlockPos>(outlinePositions);
        if (!nonFenceOutlines.isEmpty()) {
            block0: for (BlockPos firstFencePos : outlinePositions) {
                if (!(rand.m_188501_() < 0.25f)) continue;
                for (Direction dir : horizontalDirections) {
                    secondFencePos.m_122190_((Vec3i)firstFencePos.m_121945_(dir));
                    if (!nonFenceOutlines.contains(secondFencePos) || !reader.m_8055_(secondFencePos.m_121945_(Direction.DOWN)).m_60804_((BlockGetter)reader, secondFencePos.m_121945_(Direction.DOWN))) continue;
                    reader.m_7731_(firstFencePos, Blocks.f_50483_.m_49966_(), 3);
                    reader.m_7731_((BlockPos)secondFencePos, Blocks.f_50483_.m_49966_(), 3);
                    nonFenceOutlines.remove(firstFencePos);
                    nonFenceOutlines.remove(secondFencePos);
                    continue block0;
                }
            }
        }
        return nonFenceOutlines;
    }

    private void fixFenceConnections(WorldGenLevel reader, BlockPos pos) {
        BlockState originalState = reader.m_8055_(pos);
        if (originalState.m_60734_() instanceof FenceBlock) {
            BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
            for (Direction dir : horizontalDirections) {
                neighborPos.m_122190_((Vec3i)pos.m_121945_(dir));
                BlockState neighborState = reader.m_8055_((BlockPos)neighborPos);
                if (!(neighborState.m_60734_() instanceof FenceBlock)) continue;
                originalState = (BlockState)originalState.m_61124_((Property)PipeBlock.f_55154_.get(dir), (Comparable)Boolean.valueOf(true));
                neighborState = (BlockState)neighborState.m_61124_((Property)PipeBlock.f_55154_.get(dir.m_122424_()), (Comparable)Boolean.valueOf(true));
                reader.m_7731_(pos, originalState, 3);
                reader.m_7731_(neighborPos.m_7949_(), neighborState, 3);
            }
        }
    }

    private ArrayList<Pair<Direction, BlockPos>> getDecorationStarts(ArrayList<BlockPos> outlinePositions, ArrayList<BlockPos> edgePositions, ArrayList<BlockPos> holePositions, WorldGenLevel reader) {
        ArrayList<Pair<Direction, BlockPos>> decorationStarts = new ArrayList<Pair<Direction, BlockPos>>();
        for (BlockPos outlinePos : outlinePositions) {
            block1: for (Direction dir : horizontalDirections) {
                this.currentPos.m_122190_((Vec3i)outlinePos.m_121945_(dir));
                if (outlinePositions.contains(this.currentPos) || edgePositions.contains(this.currentPos)) continue;
                for (int attempts = 0; attempts < 4; ++attempts) {
                    this.currentPos.m_122190_((Vec3i)this.currentPos.m_121945_(dir));
                    if (outlinePositions.contains(this.currentPos) || edgePositions.contains(this.currentPos) || !this.isSurfacePositionClear(reader, (BlockPos)this.currentPos)) continue;
                    boolean shouldTryAgain = false;
                    BlockPos start = this.currentPos.m_7949_();
                    boolean isClear = true;
                    this.currentPos.m_122190_((Vec3i)start.m_5484_(dir.m_122428_(), 2));
                    BlockPos.MutableBlockPos mainForwardPos = this.currentPos.m_122032_();
                    for (int i = 0; i < 5 && isClear; ++i) {
                        for (int j = 0; j < 5 && isClear; ++j) {
                            if (!this.isSurfacePositionClear(reader, (BlockPos)this.currentPos)) {
                                isClear = false;
                            } else if (outlinePositions.contains(this.currentPos) || edgePositions.contains(this.currentPos) || holePositions.contains(this.currentPos)) {
                                isClear = false;
                                shouldTryAgain = true;
                            } else {
                                BlockPos.MutableBlockPos checkingPos = new BlockPos.MutableBlockPos();
                                for (Direction subDir : horizontalDirections) {
                                    checkingPos.m_122190_((Vec3i)this.currentPos.m_121945_(subDir));
                                    if (reader.m_8055_((BlockPos)checkingPos).m_60804_((BlockGetter)reader, (BlockPos)checkingPos)) {
                                        isClear = false;
                                        break;
                                    }
                                    if (!outlinePositions.contains(checkingPos) && !edgePositions.contains(checkingPos) && !holePositions.contains(checkingPos)) continue;
                                    isClear = false;
                                    shouldTryAgain = true;
                                    break;
                                }
                            }
                            this.currentPos.m_122190_((Vec3i)this.currentPos.m_121945_(dir.m_122427_()));
                        }
                        mainForwardPos.m_122190_((Vec3i)mainForwardPos.m_121945_(dir));
                        this.currentPos.m_122190_((Vec3i)mainForwardPos);
                    }
                    if (isClear) {
                        decorationStarts.add((Pair<Direction, BlockPos>)new Pair((Object)dir, (Object)start));
                    }
                    if (!shouldTryAgain) continue block1;
                }
            }
        }
        return decorationStarts;
    }

    private void generateDecorations(ArrayList<Pair<Direction, BlockPos>> potentialStarts, WorldGenLevel reader, RandomSource rand) {
        int decorationIndex = 0;
        BlockPos[] decorationCenters = new BlockPos[3];
        while (decorationIndex < 3 && !potentialStarts.isEmpty()) {
            BlockPos[][] decorationPositions;
            block35: {
                int j;
                int i;
                Direction dir;
                block34: {
                    Pair<Direction, BlockPos> positionInfo = potentialStarts.get(rand.m_188503_(potentialStarts.size()));
                    this.currentPos.m_122190_((Vec3i)positionInfo.getSecond());
                    dir = (Direction)positionInfo.getFirst();
                    decorationPositions = new BlockPos[5][5];
                    this.currentPos.m_122190_((Vec3i)this.currentPos.m_5484_(dir.m_122428_(), 2));
                    BlockPos.MutableBlockPos mainForwardPos = this.currentPos.m_122032_();
                    for (int i2 = 0; i2 < 5; ++i2) {
                        for (int j2 = 0; j2 < 5; ++j2) {
                            if (j2 == 2 && i2 == 2) {
                                decorationCenters[decorationIndex] = this.currentPos.m_7949_();
                            }
                            decorationPositions[j2][i2] = this.currentPos.m_7949_();
                            this.currentPos.m_122190_((Vec3i)this.currentPos.m_121945_(dir.m_122427_()));
                        }
                        mainForwardPos.m_122190_((Vec3i)mainForwardPos.m_121945_(dir));
                        this.currentPos.m_122190_((Vec3i)mainForwardPos);
                    }
                    boolean doesNotIntersect = true;
                    if (decorationIndex > 0) {
                        this.currentPos.m_122190_((Vec3i)decorationCenters[decorationIndex]);
                        for (i = 0; i < decorationIndex; ++i) {
                            if (Math.abs(this.currentPos.m_123341_() - decorationCenters[i].m_123341_()) > 5 || Math.abs(this.currentPos.m_123343_() - decorationCenters[i].m_123343_()) > 5) continue;
                            doesNotIntersect = false;
                            break;
                        }
                    }
                    potentialStarts.remove(positionInfo);
                    if (!doesNotIntersect) continue;
                    if (decorationIndex != 0) break block34;
                    switch (rand.m_188503_(ModList.get().isLoaded("quark") ? 3 : 2)) {
                        case 0: {
                            for (i = 0; i <= 1; ++i) {
                                for (j = 1; j <= 2; ++j) {
                                    this.currentPos.m_122190_((Vec3i)decorationPositions[j][i]);
                                    reader.m_7731_((BlockPos)this.currentPos, Blocks.f_50091_.m_49966_(), 3);
                                    this.currentPos.m_122190_((Vec3i)this.currentPos.m_121945_(Direction.UP));
                                    if (i == 1 && j == 2) {
                                        reader.m_7731_((BlockPos)this.currentPos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir), 3);
                                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)reader, (RandomSource)rand, (BlockPos)this.currentPos, (ResourceLocation)new ResourceLocation("savage_and_ravage", "chests/enclosure"));
                                        continue;
                                    }
                                    reader.m_7731_((BlockPos)this.currentPos, Blocks.f_50091_.m_49966_(), 3);
                                }
                            }
                            break block35;
                        }
                        case 1: {
                            for (i = 0; i < 3; ++i) {
                                BlockState stairsState;
                                if (i == 0) {
                                    stairsState = (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir);
                                    reader.m_7731_(decorationPositions[1][i], stairsState, 3);
                                    reader.m_7731_(decorationPositions[2][i], stairsState, 3);
                                    reader.m_7731_(decorationPositions[3][i], stairsState, 3);
                                    continue;
                                }
                                if (i == 1) {
                                    reader.m_7731_(decorationPositions[1][i], (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir.m_122427_()), 3);
                                    reader.m_7731_(decorationPositions[2][i], ((Block)SRBlocks.BLAST_PROOF_PLATES.get()).m_49966_(), 3);
                                    reader.m_7731_(decorationPositions[2][i].m_121945_(Direction.UP), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir), 3);
                                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)reader, (RandomSource)rand, (BlockPos)decorationPositions[2][i].m_121945_(Direction.UP), (ResourceLocation)new ResourceLocation("savage_and_ravage", "chests/enclosure"));
                                    reader.m_7731_(decorationPositions[3][i], (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir.m_122428_()), 3);
                                    continue;
                                }
                                stairsState = (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir.m_122424_());
                                reader.m_7731_(decorationPositions[1][i], stairsState, 3);
                                reader.m_7731_(decorationPositions[2][i], stairsState, 3);
                                reader.m_7731_(decorationPositions[3][i], stairsState, 3);
                            }
                            break block35;
                        }
                        case 2: {
                            reader.m_7731_(decorationPositions[2][0], ((Block)SRBlocks.CREEPER_SPORE_SACK.get()).m_49966_(), 3);
                            reader.m_7731_(decorationPositions[3][0], (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir), 3);
                            RandomizableContainerBlockEntity.m_222766_((BlockGetter)reader, (RandomSource)rand, (BlockPos)decorationPositions[3][0], (ResourceLocation)new ResourceLocation("savage_and_ravage", "chests/enclosure"));
                        }
                    }
                    break block35;
                }
                switch (rand.m_188503_(3)) {
                    case 0: {
                        for (i = 0; i < 6; ++i) {
                            if (i == 0 || i == 4) {
                                for (j = 0; j < 5; ++j) {
                                    reader.m_7731_(decorationPositions[j][i], Blocks.f_50483_.m_49966_(), 3);
                                    reader.m_7731_(decorationPositions[j][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                                    if (i != 4) continue;
                                    reader.m_7731_(decorationPositions[2][i], Blocks.f_50745_.m_49966_(), 3);
                                }
                                continue;
                            }
                            if (i == 5) {
                                reader.m_7731_(decorationPositions[2][4].m_121945_(dir), (BlockState)Blocks.f_50309_.m_49966_().m_61124_((Property)FaceAttachedHorizontalDirectionalBlock.f_54117_, (Comparable)dir), 3);
                                continue;
                            }
                            reader.m_7731_(decorationPositions[0][i], Blocks.f_50483_.m_49966_(), 3);
                            reader.m_7731_(decorationPositions[0][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                            reader.m_7731_(decorationPositions[4][i], Blocks.f_50483_.m_49966_(), 3);
                            reader.m_7731_(decorationPositions[4][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                            if (i != 3) continue;
                            reader.m_7731_(decorationPositions[2][i], ((Block)SRBlocks.SPORE_BOMB.get()).m_49966_(), 3);
                        }
                        break;
                    }
                    case 1: {
                        for (i = 0; i < 4; ++i) {
                            if (i > 0 && i < 3) {
                                reader.m_7731_(decorationPositions[1][i], Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[1][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[4][i], Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[4][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                                Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_((Level)reader.m_6018_());
                                if (creeper == null) continue;
                                this.currentPos.m_122190_((Vec3i)decorationPositions[2 + rand.m_188503_(2)][i]);
                                creeper.m_7678_((double)this.currentPos.m_123341_(), (double)this.currentPos.m_123342_(), (double)this.currentPos.m_123343_(), 0.0f, 0.0f);
                                creeper.m_21530_();
                                creeper.m_6518_((ServerLevelAccessor)reader, reader.m_6436_((BlockPos)this.currentPos), MobSpawnType.CHUNK_GENERATION, null, null);
                                reader.m_7967_((Entity)creeper);
                                continue;
                            }
                            for (int j3 = 1; j3 < 5; ++j3) {
                                reader.m_7731_(decorationPositions[j3][i], Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[j3][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (i = 0; i < 3; ++i) {
                            if (i == 1) {
                                reader.m_7731_(decorationPositions[1][i], Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[1][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[3][i], Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[3][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                                Creeper creeper = (Creeper)EntityType.f_20558_.m_20615_((Level)reader.m_6018_());
                                if (creeper == null) continue;
                                this.currentPos.m_122190_((Vec3i)decorationPositions[2][i]);
                                creeper.m_7678_((double)this.currentPos.m_123341_(), (double)this.currentPos.m_123342_(), (double)this.currentPos.m_123343_(), 0.0f, 0.0f);
                                creeper.m_21530_();
                                creeper.m_6518_((ServerLevelAccessor)reader, reader.m_6436_((BlockPos)this.currentPos), MobSpawnType.CHUNK_GENERATION, null, null);
                                reader.m_7967_((Entity)creeper);
                                continue;
                            }
                            for (int j4 = 1; j4 < 4; ++j4) {
                                reader.m_7731_(decorationPositions[j4][i], Blocks.f_50483_.m_49966_(), 3);
                                reader.m_7731_(decorationPositions[j4][i].m_121945_(Direction.UP), Blocks.f_50483_.m_49966_(), 3);
                            }
                        }
                        break;
                    }
                }
            }
            BlockPos[][] blockPosArray = decorationPositions;
            int n = blockPosArray.length;
            for (int i = 0; i < n; ++i) {
                BlockPos[] positions;
                for (BlockPos position : positions = blockPosArray[i]) {
                    reader.m_8055_(position).m_60701_((LevelAccessor)reader, position, 3);
                    reader.m_8055_(position.m_121945_(Direction.UP)).m_60701_((LevelAccessor)reader, position.m_121945_(Direction.UP), 3);
                }
            }
            ++decorationIndex;
        }
    }
}

