/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.InputConstants;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.utils.TranslationUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandheldCompactorItem
extends Item {
    public static final Supplier<BiMap<Item, Item>> NUGGET_COMPACTING = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Items.f_42749_, (Object)Items.f_42416_).put((Object)Items.f_42587_, (Object)Items.f_42417_).put((Object)ModItems.COPPER_NUGGET.get(), (Object)Items.f_151052_).put((Object)ModItems.RAW_IRON_NUGGET.get(), (Object)Items.f_151050_).put((Object)ModItems.RAW_GOLD_NUGGET.get(), (Object)Items.f_151053_).put((Object)ModItems.RAW_COPPER_NUGGET.get(), (Object)Items.f_151051_).put((Object)ModItems.RAW_MAGNETITE_NUGGET.get(), (Object)ModItems.RAW_MAGNETITE.get()).put((Object)ModItems.CINNABAR_SHARD.get(), (Object)ModItems.CINNABAR.get()).put((Object)ModItems.LAPIS_LAZULI_SHARD.get(), (Object)Items.f_42534_).put((Object)ModItems.EMERALD_SHARD.get(), (Object)Items.f_42616_).put((Object)ModItems.DIAMOND_SHARD.get(), (Object)Items.f_42415_).put((Object)ModItems.ROUGH_CINNABAR_SHARD.get(), (Object)ModItems.ROUGH_CINNABAR.get()).put((Object)ModItems.ROUGH_LAZURITE_SHARD.get(), (Object)ModItems.ROUGH_LAZURITE.get()).put((Object)ModItems.ROUGH_EMERALD_SHARD.get(), (Object)ModItems.ROUGH_EMERALD.get()).put((Object)ModItems.ROUGH_DIAMOND_SHARD.get(), (Object)ModItems.ROUGH_DIAMOND.get());
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "spelunkery:rough_jade_shard", "sullysmod:rough_jade");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "spelunkery:raw_silver_nugget", "oreganized:raw_silver");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "spelunkery:raw_lead_nugget", "oreganized:raw_lead");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "spelunkery:raw_zinc_nugget", "create:raw_zinc");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "spelunkery:jade_shard", "sullysmod:jade");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "oreganized:silver_nugget", "oreganized:silver_ingot");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "oreganized:lead_nugget", "oreganized:lead_ingot");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "create:zinc_nugget", "create:zinc_ingot");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "create:brass_nugget", "create:brass_ingot");
        return builder.build();
    });
    public static final Supplier<BiMap<Item, Item>> INGOT_COMPACTING = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Items.f_42416_, (Object)Items.f_41913_).put((Object)Items.f_42417_, (Object)Items.f_41912_).put((Object)Items.f_151052_, (Object)Items.f_151000_).put((Object)Items.f_151050_, (Object)Items.f_150995_).put((Object)Items.f_151053_, (Object)Items.f_150997_).put((Object)Items.f_151051_, (Object)Items.f_150996_).put((Object)ModItems.RAW_MAGNETITE.get(), (Object)ModBlocks.RAW_MAGNETITE_BLOCK.get().m_5456_()).put((Object)ModItems.CINNABAR.get(), (Object)ModBlocks.CINNABAR_BLOCK.get().m_5456_()).put((Object)Items.f_42451_, (Object)Items.f_42153_).put((Object)Items.f_42534_, (Object)Items.f_41854_).put((Object)Items.f_42616_, (Object)Items.f_42110_).put((Object)Items.f_42415_, (Object)Items.f_41959_).put((Object)ModItems.ROUGH_CINNABAR.get(), (Object)ModBlocks.ROUGH_CINNABAR_BLOCK.get().m_5456_()).put((Object)ModItems.ROUGH_LAZURITE.get(), (Object)ModBlocks.ROUGH_LAZURITE_BLOCK.get().m_5456_()).put((Object)ModItems.ROUGH_EMERALD.get(), (Object)ModBlocks.ROUGH_EMERALD_BLOCK.get().m_5456_()).put((Object)ModItems.ROUGH_DIAMOND.get(), (Object)ModBlocks.ROUGH_DIAMOND_BLOCK.get().m_5456_());
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "sullysmod:rough_jade", "sullysmod:rough_jade_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "oreganized:raw_silver", "oreganized:raw_silver_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "oreganized:raw_lead", "oreganized:raw_lead_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "create:raw_zinc", "create:raw_zinc_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "sullysmod:jade", "sullysmod:jade_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "oreganized:silver_ingot", "oreganized:silver_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "oreganized:lead_ingot", "oreganized:lead_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "create:zinc_ingot", "create:zinc_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<Item, Item>)builder, "create:brass_ingot", "create:brass_block");
        return builder.build();
    });

    public HandheldCompactorItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.wip_items").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
            switch (HandheldCompactorItem.getMode(stack)) {
                case DISABLED: {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.inactive").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC})));
                    break;
                }
                case NUGGETS_TO_INGOTS: {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.handheld_compactor_nuggets_to_ingots").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.ITALIC})));
                    break;
                }
                case INGOTS_TO_BLOCKS: {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.handheld_compactor_ingots_to_blocks").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
                    break;
                }
                case ALL: {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.handheld_compactor_all").m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})));
                }
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.handheld_compactor_1").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.handheld_compactor_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && HandheldCompactorItem.getMode(stack) != CompressionMode.DISABLED) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11738_, SoundSource.BLOCKS, 1.0f, 2.0f);
            HandheldCompactorItem.setMode(stack, CompressionMode.DISABLED);
        } else {
            HandheldCompactorItem.toggleCompactor(player, stack, level);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static void toggleCompactor(Player player, ItemStack stack, Level level) {
        if (!player.f_19853_.f_46443_ && stack.m_41720_() instanceof HandheldCompactorItem) {
            CompressionMode getMode = HandheldCompactorItem.getMode(stack);
            HandheldCompactorItem.setMode(stack, CompressionMode.VALUES[(getMode.ordinal() + 1) % CompressionMode.VALUES.length]);
            boolean deactivate = getMode == CompressionMode.ALL;
            SoundEvent beaconSound = deactivate ? SoundEvents.f_11738_ : SoundEvents.f_11736_;
            level.m_5594_(null, player.m_20183_(), beaconSound, SoundSource.BLOCKS, 1.0f, 2.0f);
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return HandheldCompactorItem.getMode(stack) != CompressionMode.DISABLED;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, Entity entity, int slotId, boolean isSelected) {
        CompressionMode mode = HandheldCompactorItem.getMode(stack);
        if (entity.m_5833_() || mode == CompressionMode.DISABLED || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack foundItem = inventory.m_8020_(i);
            if (foundItem.m_41613_() < 9) continue;
            HandheldCompactorItem.doCompacting(HandheldCompactorItem.getCompressedNugget(foundItem), foundItem, player, mode, CompressionMode.NUGGETS_TO_INGOTS);
            HandheldCompactorItem.doCompacting(HandheldCompactorItem.getCompressedIngot(foundItem), foundItem, player, mode, CompressionMode.INGOTS_TO_BLOCKS);
        }
    }

    private static void doCompacting(Optional<ItemStack> compressionType, ItemStack sourceItem, Player player, CompressionMode currentMode, CompressionMode targetMode) {
        if (compressionType.isEmpty() || currentMode != targetMode && currentMode != CompressionMode.ALL) {
            return;
        }
        ItemStack newStack = compressionType.get();
        if (!player.m_150109_().m_36054_(newStack)) {
            player.m_36176_(newStack, false);
        }
        sourceItem.m_41774_(9);
    }

    public static void addOptional(ImmutableBiMap.Builder<Item, Item> map, String moddedId, String moddedId2) {
        Optional o1 = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(moddedId));
        Optional o2 = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((Item)o1.get()), (Object)((Item)o2.get()));
        }
    }

    public static Optional<ItemStack> getCompressedNugget(ItemStack stack) {
        return Optional.ofNullable((Item)NUGGET_COMPACTING.get().get((Object)stack.m_41720_())).map(item -> item.m_5456_().m_7968_());
    }

    public static Optional<ItemStack> getCompressedIngot(ItemStack stack) {
        return Optional.ofNullable((Item)INGOT_COMPACTING.get().get((Object)stack.m_41720_())).map(item -> item.m_5456_().m_7968_());
    }

    private static void setMode(ItemStack stack, CompressionMode mode) {
        stack.m_41784_().m_128359_("mode", mode.name());
    }

    public static CompressionMode getMode(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("mode")) {
            return CompressionMode.valueOf(tag.m_128461_("mode").toUpperCase(Locale.ROOT));
        }
        return CompressionMode.DISABLED;
    }

    public static enum CompressionMode {
        DISABLED,
        NUGGETS_TO_INGOTS,
        INGOTS_TO_BLOCKS,
        ALL;

        public static CompressionMode[] VALUES;

        static {
            VALUES = CompressionMode.values();
        }
    }
}

