/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.fluids;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.fluids.PortalFluidRenderer;
import com.ordana.spelunkery.reg.ModFluids;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModParticles;
import com.ordana.spelunkery.reg.ModSoundEvents;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties;
import net.mehvahdjukaar.moonlight.api.fluids.ModFlowingFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PortalFluid
extends ModFlowingFluid {
    public PortalFluid(ModFlowingFluid.Properties properties, Supplier<? extends LiquidBlock> block) {
        super(properties, block);
    }

    public ModFluidRenderProperties createRenderProperties() {
        return new PortalFluidRenderer(Spelunkery.res("block/portal_fluid"), Spelunkery.res("block/portal_fluid_flowing"), -1, Spelunkery.res("block/portal_fluid_overlay"), Spelunkery.res("block/portal_fluid_overlay"), new Vec3(133.0, 0.0, 0.0));
    }

    @NotNull
    public Fluid m_5615_() {
        return (Fluid)ModFluids.FLOWING_PORTAL_FLUID.get();
    }

    @NotNull
    public Fluid m_5613_() {
        return (Fluid)ModFluids.PORTAL_FLUID.get();
    }

    @NotNull
    public Item m_6859_() {
        return ModItems.PORTAL_FLUID_BUCKET.get();
    }

    @NotNull
    public Optional<SoundEvent> m_142520_() {
        return Optional.of((SoundEvent)ModSoundEvents.PORTAL_FLUID_BUCKET_FILL.get());
    }

    protected ParticleOptions m_7792_() {
        return ParticleTypes.f_123786_;
    }

    public void m_213811_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos blockPos = pos.m_7494_();
        if (level.m_8055_(blockPos).m_60795_() && !level.m_8055_(blockPos).m_60804_((BlockGetter)level, blockPos)) {
            if (random.m_188503_(20) == 0) {
                double d = (double)pos.m_123341_() + random.m_188500_();
                double e = (double)pos.m_123342_() + 1.0;
                double f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)ModParticles.PORTAL_FLAME.get(), d, e + 0.2, f, 0.0, 0.0, 0.0);
            }
            if (random.m_188503_(200) == 0) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ModSoundEvents.PORTAL_FLUID_AMBIENT.get(), SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
            }
        }
    }

    protected int m_6719_(@NotNull LevelReader level) {
        return 4;
    }

    protected int m_6713_(@NotNull LevelReader level) {
        return 1;
    }

    public int m_6718_(@NotNull LevelReader level) {
        return 5;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    public boolean m_7444_(@NotNull FluidState state) {
        return false;
    }

    public int m_7430_(@NotNull FluidState state) {
        return 0;
    }

    public static class Source
    extends PortalFluid {
        public Source(ModFlowingFluid.Properties properties, Supplier<? extends LiquidBlock> block) {
            super(properties, block);
        }

        @Override
        public int m_7430_(@NotNull FluidState state) {
            return 8;
        }

        @Override
        public boolean m_7444_(@NotNull FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends PortalFluid {
        public Flowing(ModFlowingFluid.Properties properties, Supplier<? extends LiquidBlock> block) {
            super(properties, block);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        @Override
        public int m_7430_(@NotNull FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        @Override
        public boolean m_7444_(@NotNull FluidState state) {
            return false;
        }
    }
}

