/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.entities;

import com.ordana.spelunkery.blocks.GlowstickBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import com.ordana.spelunkery.reg.ModItems;
import java.util.HashMap;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownGlowstickEntity
extends ImprovedProjectileEntity {
    private static final EntityDataAccessor<Integer> DATA_GLOWSTICK_COLOR = SynchedEntityData.m_135353_(ThrownGlowstickEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final HashMap<DyeColor, Block> DYE_COLOR_TO_BLOCK = new HashMap();

    public ThrownGlowstickEntity(EntityType<? extends ThrownGlowstickEntity> type, Level world) {
        super(type, world);
    }

    public ThrownGlowstickEntity(Level level, LivingEntity thrower) {
        super(ModEntities.GLOWSTICK.get(), thrower, level);
    }

    public ThrownGlowstickEntity(Level worldIn, double x, double y, double z) {
        super(ModEntities.GLOWSTICK.get(), x, y, z, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GLOWSTICK_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        DyeColor color = this.getColor();
        compound.m_128344_("GlowstickColor", color == null ? (byte)16 : (byte)color.m_41060_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        int i = compound.m_128451_("GlowstickColor");
        this.setColor(i == 16 ? null : DyeColor.m_41053_((int)i));
    }

    public DyeColor getColor() {
        int i = (Integer)this.f_19804_.m_135370_(DATA_GLOWSTICK_COLOR);
        return i == 16 ? null : DyeColor.m_41053_((int)i);
    }

    public void setColor(DyeColor glowstickColor) {
        if (glowstickColor != null) {
            this.f_19804_.m_135381_(DATA_GLOWSTICK_COLOR, (Object)glowstickColor.m_41060_());
        } else {
            this.f_19804_.m_135381_(DATA_GLOWSTICK_COLOR, (Object)16);
        }
    }

    protected Item m_7881_() {
        return ModItems.GLOWSTICK.get();
    }

    public void spawnTrailParticles() {
        SimpleParticleType particle = ParticleTypes.f_175827_;
        for (int i = 0; i < 4; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        super.spawnTrailParticles();
    }

    public static Block getGlowstickBlock(DyeColor color) {
        return DYE_COLOR_TO_BLOCK.getOrDefault(color, ModBlocks.GLOWSTICK.get());
    }

    protected void m_6532_(HitResult result) {
        if (result instanceof BlockHitResult) {
            BlockHitResult bResult = (BlockHitResult)result;
            this.placeGlowstick(this.f_19853_, bResult);
        }
        super.m_6532_(result);
    }

    public void placeGlowstick(Level level, BlockHitResult hitResult) {
        Direction dir = hitResult.m_82434_();
        BlockPos pos = hitResult.m_82425_();
        BlockPos relativePos = pos.m_121945_(dir);
        BlockState replaceState = level.m_8055_(relativePos);
        Block glowstickCheck = ThrownGlowstickEntity.getGlowstickBlock(this.getColor());
        if (replaceState.m_247087_()) {
            boolean waterlogged = replaceState.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
            level.m_46597_(relativePos, (BlockState)((BlockState)glowstickCheck.m_49966_().m_61124_((Property)RodBlock.f_52588_, (Comparable)dir)).m_61124_((Property)GlowstickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        } else {
            level.m_7967_((Entity)new ItemEntity(level, (double)relativePos.m_123341_(), (double)relativePos.m_123342_(), (double)relativePos.m_123343_(), new ItemStack((ItemLike)glowstickCheck)));
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected float getWaterInertia() {
        return 0.95f;
    }

    static {
        DYE_COLOR_TO_BLOCK.put(null, ModBlocks.GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.RED, ModBlocks.RED_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.ORANGE, ModBlocks.ORANGE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.YELLOW, ModBlocks.YELLOW_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.LIME, ModBlocks.LIME_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.GREEN, ModBlocks.GREEN_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.CYAN, ModBlocks.CYAN_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.LIGHT_BLUE, ModBlocks.LIGHT_BLUE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.BLUE, ModBlocks.BLUE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.PURPLE, ModBlocks.PURPLE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.MAGENTA, ModBlocks.MAGENTA_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.PINK, ModBlocks.PINK_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.BROWN, ModBlocks.BROWN_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.BLACK, ModBlocks.BLACK_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.WHITE, ModBlocks.WHITE_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.GRAY, ModBlocks.GRAY_GLOWSTICK.get());
        DYE_COLOR_TO_BLOCK.put(DyeColor.LIGHT_GRAY, ModBlocks.LIGHT_GRAY_GLOWSTICK.get());
    }
}

