/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironshulkerbox.common.network;

import com.progwml6.ironshulkerbox.common.block.entity.ICrystalShulkerBox;
import com.progwml6.ironshulkerbox.common.network.helper.IThreadsafePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class InventoryTopStacksSyncPacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final NonNullList<ItemStack> topStacks;

    public InventoryTopStacksSyncPacket(NonNullList<ItemStack> topStacks, BlockPos pos) {
        this.topStacks = topStacks;
        this.pos = pos;
    }

    public InventoryTopStacksSyncPacket(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        NonNullList topStacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int item = 0; item < size; ++item) {
            ItemStack itemStack = buffer.m_130267_();
            topStacks.set(item, (Object)itemStack);
        }
        this.topStacks = topStacks;
        this.pos = buffer.m_130135_();
    }

    @Override
    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.topStacks.size());
        for (ItemStack stack : this.topStacks) {
            packetBuffer.m_130055_(stack);
        }
        packetBuffer.m_130064_(this.pos);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(InventoryTopStacksSyncPacket packet) {
            BlockEntity te;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (te = world.m_7702_(packet.pos)) != null && te instanceof ICrystalShulkerBox) {
                ((ICrystalShulkerBox)te).receiveMessageFromServer(packet.topStacks);
                Minecraft.m_91087_().f_91060_.m_109544_(null, packet.pos, null, null, 0);
            }
        }
    }
}

