/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.spelunkeryplus.world.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public record GemOreFeatureConfig(List<TargetWeightedState> targetStates, float discardChanceOnAirExposure) implements FeatureConfiguration
{
    public static final Codec<GemOreFeatureConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list(TargetWeightedState.CODEC).fieldOf("targets").forGetter(GemOreFeatureConfig::targetStates), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(GemOreFeatureConfig::discardChanceOnAirExposure)).apply((Applicative)builder, GemOreFeatureConfig::new));

    public static class TargetWeightedState {
        public static final Codec<TargetWeightedState> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)RuleTest.f_74307_.fieldOf("target").forGetter(config -> config.target), (App)Codec.list(WeightedState.CODEC).fieldOf("states").forGetter(config -> config.weightedStates)).apply((Applicative)builder, TargetWeightedState::new));
        public final RuleTest target;
        public final List<WeightedState> weightedStates;
        public final List<BlockState> states;

        TargetWeightedState(RuleTest ruleTest, List<WeightedState> weightedStates) {
            this.target = ruleTest;
            this.weightedStates = weightedStates;
            this.states = new ArrayList<BlockState>();
            for (WeightedState weightedState : weightedStates) {
                for (int i = 0; i < weightedState.weight; ++i) {
                    this.states.add(weightedState.state);
                }
            }
        }
    }

    public record WeightedState(BlockState state, int weight) {
        public static final Codec<WeightedState> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.f_61039_.fieldOf("state").forGetter(WeightedState::state), (App)Codec.intRange((int)0, (int)100).optionalFieldOf("weight", (Object)1).forGetter(WeightedState::weight)).apply((Applicative)builder, WeightedState::new));
    }
}

