/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillar;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import software.bernie.geckolib.core.animation.RawAnimation;

public class SpawnPillarAbility
extends PlayerAbility {
    private static int MAX_DURATION = 120;
    private static int MAX_RANGE_TO_GROUND = 12;
    private BlockPos spawnPillarPos;
    private BlockState spawnPillarBlock;
    private EntityPillar pillar;
    private static final RawAnimation PILLAR_SPAWN_ANIM = RawAnimation.begin().thenPlay("pillar_spawn");

    public SpawnPillarAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 2), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, MAX_DURATION)});
    }

    @Override
    public void start() {
        super.start();
        ((Player)this.getUser()).m_20256_(((Player)this.getUser()).m_20184_().m_82520_(0.0, -2.0, 0.0));
    }

    @Override
    public boolean tryAbility() {
        Vec3 from = ((Player)this.getUser()).m_20182_();
        Vec3 to = from.m_82492_(0.0, (double)MAX_RANGE_TO_GROUND, 0.0);
        BlockHitResult result = ((Player)this.getUser()).m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
        if (result.m_6662_() != HitResult.Type.MISS) {
            BlockState blockAbove;
            this.spawnPillarPos = result.m_82425_();
            this.spawnPillarBlock = ((Player)this.getUser()).m_9236_().m_8055_(this.spawnPillarPos);
            if (result.m_82434_() != Direction.UP && ((blockAbove = ((Player)this.getUser()).m_9236_().m_8055_(this.spawnPillarPos.m_7494_())).m_60828_((BlockGetter)((Player)this.getUser()).m_9236_(), this.spawnPillarPos.m_7494_()) || blockAbove.m_60795_())) {
                return false;
            }
            return EffectGeomancy.isBlockUseable(this.spawnPillarBlock);
        }
        return false;
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        ((Player)this.getUser()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 3, 2, false, false));
    }

    @Override
    protected void beginSection(AbilitySection section) {
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            this.spawnPillar();
        }
    }

    private void spawnPillar() {
        this.pillar = new EntityPillar((EntityType<? extends EntityPillar>)((EntityType)EntityHandler.PILLAR.get()), ((Player)this.getUser()).m_9236_(), (LivingEntity)this.getUser(), this.spawnPillarBlock, this.spawnPillarPos);
        this.pillar.m_6034_((float)this.spawnPillarPos.m_123341_() + 0.5f, this.spawnPillarPos.m_123342_() + 1, (float)this.spawnPillarPos.m_123343_() + 0.5f);
        if (!((Player)this.getUser()).m_9236_().f_46443_ && this.pillar.checkCanSpawn()) {
            ((Player)this.getUser()).m_9236_().m_7967_((Entity)this.pillar);
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.pillar != null) {
            this.pillar.stopRising();
        }
        this.pillar = null;
    }

    @Override
    public boolean canUse() {
        return EffectGeomancy.canUse(this.getUser()) && this.damageGauntlet() && super.canUse();
    }

    @Override
    protected boolean canContinueUsing() {
        return super.canContinueUsing() && this.damageGauntlet() && (this.pillar == null || this.getLevel().m_45933_((Entity)this.pillar, this.pillar.m_20191_().m_82377_(0.0, 6.0, 0.0)).contains(this.getUser()));
    }

    @Override
    public void onJump(LivingEvent.LivingJumpEvent event) {
        super.onJump(event);
        if (((Player)this.getUser()).m_6047_() && !event.getEntity().m_9236_().m_5776_()) {
            AbilityHandler.INSTANCE.sendAbilityMessage(event.getEntity(), AbilityHandler.SPAWN_PILLAR_ABILITY);
        }
    }

    @Override
    public void onSneakUp(Player player) {
        super.onSneakUp(player);
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.isUsing()) {
            if (this.pillar != null) {
                this.pillar.stopRising();
            }
            this.nextSection();
        }
    }

    public boolean damageGauntlet() {
        ItemStack stack = ((Player)this.getUser()).m_21205_();
        if (!stack.m_150930_((Item)ItemHandler.EARTHREND_GAUNTLET.get())) {
            stack = ((Player)this.getUser()).m_21206_();
        }
        if (!stack.m_150930_((Item)ItemHandler.EARTHREND_GAUNTLET.get())) {
            return false;
        }
        if (stack.m_41720_() == ItemHandler.EARTHREND_GAUNTLET.get()) {
            InteractionHand handIn = ((Player)this.getUser()).m_7655_();
            if (stack.m_41773_() + 6 < stack.m_41776_()) {
                stack.m_41622_(6, (LivingEntity)((Player)this.getUser()), p -> p.m_21190_(handIn));
                return true;
            }
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.breakable.get()).booleanValue()) {
                stack.m_41622_(6, (LivingEntity)((Player)this.getUser()), p -> p.m_21190_(handIn));
            }
            return false;
        }
        return false;
    }
}

